<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>About Us | Global Measures Malawi</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />

  <style>
    body, html {
      margin: 0;
      padding: 0;
      font-family: 'Roboto', sans-serif;
    }

    /* Hero Section */
    .hero-section {
      background: url('images/about.jpg') no-repeat center center;
      background-size: cover;
      color: white;
      padding: 100px 0;
      text-align: center;
      font-weight: bold;
    }

    .hero-section h1 {
      font-size: 3.5rem;
      letter-spacing: 2px;
      text-transform: uppercase;
    }

    .hero-section p {
      font-size: 1.2rem;
      margin-top: 20px;
    }

    /* About Content */
    .about-section {
      padding: 60px 20px;
    }

    .about-section h2 {
      font-weight: 700;
      margin-bottom: 30px;
    }

    .highlight-box {
      background: #f8f9fa;
      border-left: 6px solid #008cba;
      padding: 20px;
      margin-bottom: 20px;
      border-radius: 8px;
    }

    footer {
      background-color: #343a40;
      color: white;
      padding: 30px 0;
      text-align: center;
    }

    footer p {
      margin-bottom: 0;
    }
  </style>
</head>

<body>

  <!-- Hero Section -->
  <section class="hero-section">
    <div class="container">
      <h1>About Us</h1>
      <p>Waging Trade in Malawi – Empowering Rural Communities Through Partnerships</p>
    </div>
  </section>

  <!-- About GMM Content -->
  <section class="about-section container">
    <div class="row">
      <div class="col-lg-10 offset-lg-1">
        <h2>About Global Measure Malawi (GMM)</h2>
        <p>
          Global Measure Malawi Limited (GMM) facilitates the creation and sustainable maintenance of Trade Ecosystems aimed at birthing win-win partnerships between smallholder farmers and various stakeholders along the on-farm, off-farm, and non-farm value chains in rural Malawi.
        </p>
        <p>
          The innovative Trade Ecosystem for Smallholder Farmers (TESH) brings together relevant partners to organized groups of smallholder farmers for business.
        </p>
        <p>
          GMM has been in operation for close to 3 years, indirectly supporting over 50,000 rural Malawians to improve their food and income security.
        </p>
        <p>
          TESH has been operational in Lilongwe and Ntchisi districts in the Central Region and Zomba and Thyolo districts in the Southern Region of Malawi, targeting 3,500 direct participants who access genuine improved seed right at their doorstep. There is growing demand to expand into new areas.
        </p>
        <p>
          GMM upholds the following guiding principles: <strong>Integrity</strong> in all dealings; <strong>Value Innovation</strong> for smallholder farmers; <strong>Quality Service Delivery</strong>; <strong>Collaboration</strong>; and a strong <strong>Community Responsibility</strong>.
        </p>

        <div class="highlight-box">
          <h5><i class="fas fa-eye me-2 text-info"></i> Vision</h5>
          <p>Every Malawian household visible, connected, thriving and growing incomes.</p>
        </div>

        <div class="highlight-box">
          <h5><i class="fas fa-bullseye me-2 text-info"></i> Mission</h5>
          <p>GMM provides new emerging opportunities for efficiency in trade and services for low-income communities across Malawi.</p>
        </div>

        <div class="highlight-box">
          <h5><i class="fas fa-bell me-2 text-info"></i> Clarion Call</h5>
          <p>Waging trade in Malawi.</p>
        </div>
      </div>
    </div>
  </section>

  <?php include 'includes/footer.php'; ?>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
