<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Our Team | Global Measures Malawi</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />

  <!-- Custom Styles -->
  <style>
    body, html {
      margin: 0;
      padding: 0;
      font-family: 'Roboto', sans-serif;
    }

    /* Hero Section */
    .hero-section {
      background: url('images/team-concept-with-two-man-sunset-background_493806-6439.avif') no-repeat center center;
      background-size: cover;
      color: white;
      padding: 100px 0;
      text-align: center;
      font-weight: bold;
      position: relative;
    }

    .hero-section h1 {
      font-size: 3.5rem;
      letter-spacing: 2px;
      text-transform: uppercase;
    }

    .hero-section p {
      font-size: 1.2rem;
      margin-top: 20px;
    }

    /* Team Cards */
    .team-card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      background: #fff;
    }

    .team-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
    }

    .team-card img {
      max-height: 120px;
      object-fit: cover;
      margin-bottom: 20px;
      border-radius: 50%;
    }

    .team-logo {
      width: 100px;
      height: auto;
      display: block;
      margin: 0 auto;
    }

    .btn-info {
      background-color: #008cba;
      border-color: #008cba;
    }

    .btn-info:hover {
      background-color: #005f7f;
      border-color: #005f7f;
    }

    .modal-header, .modal-body {
      background-color: #f8f9fa;
    }

    .modal-header .btn-close {
      outline: none;
    }

    /* Custom Footer */
    footer {
      background-color: #343a40;
      color: white;
      padding: 30px 0;
      text-align: center;
    }

    footer p {
      margin-bottom: 0;
    }
	
	.modal-content {
  border-radius: 20px;
  background: #ffffff;
  box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
  animation: fadeInZoom 0.6s ease;
}

@keyframes fadeInZoom {
  from {
    opacity: 0;
    transform: scale(0.85);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
}

.profile-modal-img {
  width: 120px;
  height: 120px;
  border-radius: 50%;
  border: 4px solid #fff;
  box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
  margin-top: -70px;
}

.profile-name {
  font-size: 1.6rem;
  font-weight: 700;
  color: #2c3e50;
}

.profile-title {
  font-size: 1rem;
  color: #6c757d;
  margin-bottom: 0.5rem;
}

.profile-list {
  text-align: left;
  margin-top: 1rem;
}

.profile-list li {
  margin-bottom: 0.5rem;
  line-height: 1.5;
}

.team-card {
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.team-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
}



  </style>
</head>

<body>
  <!-- Hero Section -->
  <section class="hero-section">
    <div class="container">
      <h1>Meet Our Team</h1>
      <p>Driven by passion, guided by vision. Get to know the faces behind our success.</p>
    </div>
  </section>
  
  <section class="container-fluid my-5 px-5">
  <h2 class="text-center mb-5 display-6 fw-bold">Our Dedicated Staff Team 👥</h2>
  <div class="row g-4">

    <!-- Staff 1: CEO/General Manager -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Charles Mwenda" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Charles Mwenda</h5>
        <p class="text-muted">CEO/General Manager</p>
      </div>
    </div>

    <!-- Staff 2: Finance & Admin -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Cynthia Kephas" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Cynthia Kephas</h5>
        <p class="text-muted">Finance & Administration Officer</p>
      </div>
    </div>

    <!-- Staff 3: Marketing & Operations -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Julius Banda" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Julius Banda</h5>
        <p class="text-muted">Marketing & Operating Officer</p>
      </div>
    </div>

    <!-- Staff 4: Business Dev -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Yamikani Kampeni" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Yamikani Kampeni</h5>
        <p class="text-muted">Business Development Coordinator</p>
      </div>
    </div>

    <!-- Staff 5: Blessings Zembani -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Blessings Zembani" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Blessings Zembani</h5>
        <p class="text-muted">Central Regional Trade Coordinator</p>
      </div>
    </div>

    <!-- Staff 6: Francis Ligomeka -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Francis Ligomeka" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Francis Ligomeka</h5>
        <p class="text-muted">Northern Regional Trade Coordinator</p>
      </div>
    </div>

    <!-- Staff 7: Charles Mphoyo -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="Charles Mphoyo" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">Charles Mphoyo</h5>
        <p class="text-muted">Southern Regional Trade Coordinator</p>
      </div>
    </div>

    <!-- Staff 8: Digital Coordinator -->
    <div class="col-sm-6 col-lg-3">
      <div class="p-4 bg-light text-center shadow rounded-4 h-100">
        <img src="images/8847419.png" alt="William Mwachande" class="img-fluid rounded-circle mb-3" style="height: 150px; width: 150px; object-fit: cover;" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
        <h5 class="fw-bold">William Mwachande</h5>
        <p class="text-muted">Digital Coordinator</p>
      </div>
    </div>

  </div>
</section>

<section class="container my-5">
  <h2 class="text-center mb-5 display-6 fw-bold">Our Directors 👩‍💼👨‍💼</h2>
  <div class="row justify-content-center g-4">

    <!-- Card: David Ruchiu -->
    <div class="col-md-6 col-lg-4 mb-4">
  <div class="bg-white text-center p-4 shadow-lg rounded-4 h-100 d-flex flex-column align-items-center team-card">
    <div class="position-relative mb-3">
      <img src="images/8847419.png" alt="David Ruchiu"
           class="rounded-circle border border-3 border-info"
           style="height: 150px; width: 150px; object-fit: cover;"
           onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
    </div>
    <h5 class="fw-bold text-dark mb-1">David Ruchiu</h5>
    <p class="text-info fw-semibold mb-1">Board Director</p>
    <p class="text-muted small mb-3 px-2">Key Contributor in GMM’s Leadership Team.</p>
    <a href="#" class="text-decoration-none text-success fw-semibold mt-auto" data-bs-toggle="modal" data-bs-target="#modal-david">
      Read More <i class="bi bi-arrow-right ms-1"></i>
    </a>
  </div>
</div>


    <!-- Card: Mumbi Kimathi -->
    <div class="col-sm-6 col-lg-4 mb-4">
  <div class="bg-white text-center p-4 shadow-lg rounded-4 h-100 d-flex flex-column align-items-center team-card">
    <div class="position-relative mb-3">
      <img src="images/8847419.png" alt="Mumbi Kimathi"
           class="rounded-circle border border-3 border-info"
           style="height: 150px; width: 150px; object-fit: cover;"
           onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
    </div>
    <h5 class="fw-bold text-dark mb-1">Mumbi Kimathi</h5>
    <p class="text-info fw-semibold mb-1">Board Director</p>
    <p class="text-muted small mb-3 px-2">Board oversight and community engagement leader.</p>
    <a href="#" class="text-decoration-none text-success fw-semibold mt-auto" data-bs-toggle="modal" data-bs-target="#modal-mumbi">
      Read More <i class="bi bi-arrow-right ms-1"></i>
    </a>
  </div>
</div>


    <!-- Card: Limbani Kaluwa -->
    <div class="col-sm-6 col-lg-4 mb-4">
  <div class="bg-white text-center p-4 shadow-lg rounded-4 h-100 d-flex flex-column align-items-center team-card">
    <div class="position-relative mb-3">
      <img src="images/8847419.png" alt="Limbani Kaluwa"
           class="rounded-circle border border-3 border-info"
           style="height: 150px; width: 150px; object-fit: cover;"
           onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
    </div>
    <h5 class="fw-bold text-dark mb-1">Limbani Kaluwa</h5>
    <p class="text-info fw-semibold mb-1">Board Director</p>
    <p class="text-muted small mb-3 px-2">Expert in irrigation and agricultural development.</p>
    <a href="#" class="text-decoration-none text-success fw-semibold mt-auto" data-bs-toggle="modal" data-bs-target="#modal-limbani">
      Read More <i class="bi bi-arrow-right ms-1"></i>
    </a>
  </div>
</div>


    <!-- Card: Mwiza Chirwa -->
    <div class="col-sm-6 col-lg-4 mb-4">
  <div class="bg-white text-center p-4 shadow-lg rounded-4 h-100 d-flex flex-column align-items-center team-card">
    <div class="position-relative mb-3">
      <img src="images/8847419.png" alt="Mwiza Chirwa"
           class="rounded-circle border border-3 border-info"
           style="height: 150px; width: 150px; object-fit: cover;"
           onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
    </div>
    <h5 class="fw-bold text-dark mb-1">Mwiza Chirwa</h5>
    <p class="text-info fw-semibold mb-1">Board Director</p>
    <p class="text-muted small mb-3 px-2">Championing productivity and food security at GMM.</p>
    <a href="#" class="text-decoration-none text-success fw-semibold mt-auto" data-bs-toggle="modal" data-bs-target="#modal-mwiza">
      Read More <i class="bi bi-arrow-right ms-1"></i>
    </a>
  </div>
</div>


    <!-- Card: Charles Mwenda -->
    <div class="col-sm-6 col-lg-4 mb-4">
  <div class="bg-white text-center p-4 shadow-lg rounded-4 h-100 d-flex flex-column align-items-center team-card">
    <div class="position-relative mb-3">
      <img src="images/8847419.png" alt="Charles Mwenda"
           class="rounded-circle border border-3 border-info"
           style="height: 150px; width: 150px; object-fit: cover;"
           onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
    </div>
    <h5 class="fw-bold text-dark mb-1">Charles Mwenda</h5>
    <p class="text-info fw-semibold mb-1">Board Director</p>
    <p class="text-muted small mb-3 px-2">Leads financial strategy and rural partnerships.</p>
    <a href="#" class="text-decoration-none text-success fw-semibold mt-auto" data-bs-toggle="modal" data-bs-target="#modal-charles">
      Read More <i class="bi bi-arrow-right ms-1"></i>
    </a>
  </div>
</div>

</section>

<!-- Stylish Modal: David Ruchiu -->
<div class="modal fade" id="modal-david" tabindex="-1" aria-labelledby="modalDavidLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content text-center p-4">
      <button type="button" class="btn-close position-absolute end-0 top-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <img src="images/8847419.png" alt="David Ruchiu" class="profile-modal-img mx-auto" onerror="this.onerror=null;this.src='images/default-avatar.jpg';">
      <div class="modal-body">
        <h5 class="profile-name">👨‍💼 David Ruchiu</h5>
        <p class="profile-title">Board Director</p>
        <ul class="profile-list list-unstyled">
          <li>📌 Strategic advisor at Global Measure Malawi Limited</li>
          <li>📊 15+ years in enterprise leadership</li>
          <li>🧠 Mentor to growth-stage businesses</li>
        </ul>
      </div>
    </div>
  </div>
</div>



<!-- Modal: Mumbi Kimathi -->
<div class="modal fade" id="modal-mumbi" tabindex="-1" aria-labelledby="modalMumbiLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content text-center p-4">
      <button type="button" class="btn-close position-absolute end-0 top-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <img src="images/default-avatar.jpg" class="profile-modal-img mx-auto">
      <div class="modal-body">
        <h5 class="profile-name">👩‍💼 Mumbi Kimathi</h5>
        <p class="profile-title">Board Director</p>
        <ul class="profile-list list-unstyled">
          <li>🧭 Offers governance and leadership support</li>
          <li>💪 Passionate about community empowerment</li>
          <li>📋 Provides oversight for development programs</li>
        </ul>
      </div>
    </div>
  </div>
</div>


<!-- Modal: Limbani Kaluwa -->
<div class="modal fade" id="modal-limbani" tabindex="-1" aria-labelledby="modalLimbaniLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content text-center p-4">
      <button type="button" class="btn-close position-absolute end-0 top-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <img src="images/default-avatar.jpg" class="profile-modal-img mx-auto">
      <div class="modal-body">
        <h5 class="profile-name">🌾 Limbani Kaluwa</h5>
        <p class="profile-title">Director</p>
        <ul class="profile-list list-unstyled mb-3">
          <li>🎓 MSc in Water Science and Engineering (IHE Delft, Netherlands)</li>
          <li>💧 Expert in irrigation engineering and agricultural development</li>
          <li>🌍 Leads the Trade Ecosystem for Smallholder Farmers (TESH)</li>
          <li>🚀 Supports 50,000+ rural Malawians through GMM programs</li>
          <li>📈 Drives agricultural productivity and profitability</li>
          <li>🧠 Integrates sustainable practices into profit models</li>
          <li>📊 Champions market research and digital innovation</li>
        </ul>
        <p class="text-muted small px-2" style="text-align:justify;">
          Limbani Kaluwa is a seasoned professional with extensive expertise in irrigation engineering and agricultural development, currently serving as a Director at Global Measure Malawi Limited (GMM). With a Master's degree in Water Science and Engineering from IHE Delft in the Netherlands, Limbani is adept at integrating sustainable practices within profit-making frameworks. His strategic leadership focuses on enhancing agricultural productivity and profitability through innovative partnerships with smallholder farmers. At GMM, he spearheads the Trade Ecosystem for Smallholder Farmers (TESH), which has successfully supported over 50,000 rural Malawians. By leveraging market research and tailored digital solutions, he ensures GMM achieves both financial success and community impact—advancing food security and sustainable agriculture in Malawi.
        </p>
      </div>
    </div>
  </div>
</div>
	


<!-- Modal: Mwiza Chirwa -->
<div class="modal fade" id="modal-mwiza" tabindex="-1" aria-labelledby="modalMwizaLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content text-center p-4">
      <button type="button" class="btn-close position-absolute end-0 top-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <img src="images/default-avatar.jpg" class="profile-modal-img mx-auto">
      <div class="modal-body">
        <h5 class="profile-name">💼 Mwiza Chirwa</h5>
        <p class="profile-title">Director</p>
        <ul class="profile-list list-unstyled mb-3">
          <li>🎓 Master's in Commerce (University of Johannesburg)</li>
          <li>📊 Strategic leader in agricultural ecosystems</li>
          <li>🌱 Leads GMM’s Trade Ecosystem for Smallholder Farmers (TESH)</li>
          <li>👨‍🌾 Supports 50,000+ rural Malawians through value-chain partnerships</li>
          <li>🚜 Drives access to certified seeds & solar-powered tech</li>
        </ul>
        <p class="text-muted small px-2" style="text-align:justify;">
          Mwiza Chirwa is an accomplished leader with a robust background in strategic management, currently positioned as a Director at Global Measure Malawi Limited (GMM). With a Master's degree in Commerce from the University of Johannesburg, Mwiza specializes in developing sustainable partnerships that empower smallholder farmers. Under his leadership, GMM has significantly expanded its impact, improving food security and farmer income across multiple districts. His dedication to innovation, integrity, and service excellence drives GMM’s mission to advance agricultural development and economic growth in Malawi.
        </p>
      </div>
    </div>
  </div>
</div>



<!-- Modal: Charles Mwenda -->
<div class="modal fade" id="modal-charles" tabindex="-1" aria-labelledby="modalCharlesLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content text-center p-4">
      <button type="button" class="btn-close position-absolute end-0 top-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
      <img src="images/default-avatar.jpg" class="profile-modal-img mx-auto">
      <div class="modal-body">
        <h5 class="profile-name">💼 Charles Mwenda</h5>
        <p class="profile-title">General Manager</p>
        <ul class="profile-list list-unstyled mb-3">
          <li>🎓 BA in Management (Manchester Metropolitan University)</li>
          <li>🎓 Completing Master of Commerce at DMI St. Eugene University</li>
          <li>📘 Final paper of CIMA underway</li>
          <li>📜 Holds diplomas in Accountancy, IT, and Financial Management</li>
          <li>📊 10+ years’ experience in management and finance</li>
          <li>🌱 Leads partnerships with smallholder farmers across value chains</li>
          <li>🚀 Supports 50,000+ rural Malawians through GMM’s initiatives</li>
        </ul>
        <p class="text-muted small px-2" style="text-align:justify;">
          Charles Mwenda is a seasoned General Manager at Global Measure Malawi Limited (GMM), where he leverages over a decade of experience to drive profitability and sustainable growth. His leadership ensures GMM’s innovative offerings, such as certified seeds and solar-powered equipment, meet market demands effectively. With a strong academic foundation and financial expertise, Charles excels in optimizing operations and forging impactful partnerships. He embodies integrity and innovation—key to advancing GMM’s mission of enhancing agricultural productivity and sustainability across Malawi.
        </p>
      </div>
    </div>
  </div>
</div>







  <?php include 'includes/footer.php'; ?>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
  document.querySelectorAll('.toggle-link').forEach(link => {
    const targetId = link.getAttribute('href').substring(1);
    const target = document.getElementById(targetId);

    target.addEventListener('show.bs.collapse', () => {
      link.textContent = 'Read Less';
    });

    target.addEventListener('hide.bs.collapse', () => {
      link.textContent = 'Read More';
    });
  });
</script>




</body>
</html>
