<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Contact Us | Global Measures Malawi</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />

  <style>
    body, html {
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .contact-hero {
      background: url('images/gi-malawi-data.jpg') center center/cover no-repeat;
      height: 300px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      text-shadow: 1px 1px 4px #000;
    }

    .contact-hero h1 {
      font-size: 3rem;
    }

    .bg-light-blue {
      background-color: #e3f2fc;
    }
  </style>
</head>
<body>

<!-- Contact Hero Banner -->
<section class="contact-hero">
  <h1>Contact Us</h1>
</section>

<!-- Location and Contact Info -->
<section class="bg-light-blue py-5">
  <div class="container">
    <div class="row text-start">
      <div class="col-md-6 mb-4">
        <h4>Our Office Location</h4>
        <p><i class="fas fa-map-marker-alt text-primary me-2"></i> Area 47 Sector 4, Lilongwe, Malawi</p>
        <p><i class="fas fa-mail-bulk text-secondary me-2"></i> P.O. Box 1585, Lilongwe, Malawi</p>
        <p><i class="fas fa-clock text-primary me-2"></i> Monday to Friday: 8:00 AM – 5:00 PM</p>
      </div>
      <div class="col-md-6">
        <h4>Contact Information</h4>
        <p>
          <i class="fas fa-phone-alt text-success me-2"></i>
          <a href="tel:+265888874839" class="text-decoration-none text-success">+265 888 87 48 39</a>
        </p>
        <p>
          <i class="fas fa-envelope text-danger me-2"></i>
          <a href="mailto:info@globalmeasuremalawi.com" class="text-decoration-none text-danger">info@globalmeasuremalawi.com</a>
        </p>
        <p>
          <i class="fas fa-globe text-info me-2"></i>
          <a href="https://www.globalmeasuremalawi.com" target="_blank" rel="noopener noreferrer" class="text-decoration-none text-info">www.globalmeasuremalawi.com</a>
        </p>
      </div>
    </div>
  </div>
</section>

<!-- Contact Section -->
<section class="container my-5">
  <div class="row align-items-stretch" style="min-height: 400px;">
    <!-- Map -->
    <div class="col-md-6 p-0">
      <iframe
        src="https://www.google.com/maps/embed?pb=!1m17!1m12!1m3!1d3872.122126108089!2d33.76335507509392!3d-13.95133318646167!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2smw!4v1747911037395!5m2!1sen!2smw"
        width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy" class="h-100 w-100"
      ></iframe>
    </div>

    <!-- Contact Form -->
    <div class="col-md-6 bg-light d-flex align-items-center">
      <form class="w-100 p-4">
        <h4 class="mb-3">Send Us a Message</h4>
        <div class="mb-3">
          <label for="subject" class="form-label">Subject</label>
          <input type="text" class="form-control" id="subject" name="subject" required>
        </div>
        <div class="mb-3">
          <label for="email" class="form-label">Email Address</label>
          <input type="email" class="form-control" id="email" name="email" required>
        </div>
        <div class="mb-3">
          <label for="message" class="form-label">Your Message</label>
          <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Submit</button>
      </form>
    </div>
  </div>
</section>

<?php include 'includes/footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
