<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Partners | Global Measures Malawi</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />

  <!-- Custom Styles -->
  <style>
    body, html {
      margin: 0;
      padding: 0;
      font-family: 'Roboto', sans-serif;
    }

    /* Hero Section */
    .hero-section {
      background: url('images/dark-businesswoman-shaking-hands-with-male-colleague.jpg') no-repeat center center;
      background-size: cover;
      color: white;
      padding: 100px 0;
      text-align: center;
      font-weight: bold;
      position: relative;
    }

    .hero-section h1 {
      font-size: 3.5rem;
      letter-spacing: 2px;
      text-transform: uppercase;
    }

    .hero-section p {
      font-size: 1.2rem;
      margin-top: 20px;
    }

    /* Partner Cards */
    .partner-card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      background: #fff;
    }

    .partner-card:hover {
      transform: translateY(-10px);
      box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
    }

    .partner-card img {
      max-height: 120px;
      object-fit: contain;
      margin-bottom: 20px;
    }

    .partner-logo {
      width: 100px;
      height: auto;
      display: block;
      margin: 0 auto;
    }

    .btn-info {
      background-color: #008cba;
      border-color: #008cba;
    }

    .btn-info:hover {
      background-color: #005f7f;
      border-color: #005f7f;
    }

    .modal-header, .modal-body {
      background-color: #f8f9fa;
    }

    .modal-header .btn-close {
      outline: none;
    }

    /* Custom Footer */
    footer {
      background-color: #343a40;
      color: white;
      padding: 30px 0;
      text-align: center;
    }

    footer p {
      margin-bottom: 0;
    }
  </style>
</head>

<body>
<!-- Hero Section -->
<section class="hero-section">
  <div class="container">
    <h1>Our Esteemed Partners 🤝</h1>
    <p>Working together to drive positive change in Malawi's agricultural and energy sectors.</p>
  </div>
</section>


	<section class="container my-5">
  <h2 class="text-center mb-5 display-6 fw-bold">Our Esteemed Partners <span class="text-primary">🤝</span></h2>
  
  <!-- Farm Concern Section - Styled Like Partner Cards -->
<div class="partner-card d-flex align-items-start p-4 shadow-sm bg-white rounded-4 border-start border-4 border-info mb-5">
  <img src="images/farm_concern.png" alt="Farm Concern International Logo" class="me-4 rounded" style="width: 100px; height: auto;" />
  <div>
    <h5 class="fw-bold text-info">Farm Concern International (FCI) 🌍</h5>
    <p class="mb-3">
      Strategic partner and parent organization to Global Measure Malawi (GMM), empowering over <strong>18 million smallholder farmers</strong> in <strong>24 countries</strong> through market access and commercialization.
    </p>
    <button class="btn btn-outline-info btn-sm" data-bs-toggle="modal" data-bs-target="#partnerModalFCI">
      <i class="fas fa-circle-info me-1"></i>More Info
    </button>
  </div>
</div>


  <div class="row g-5">

    <!-- Partner Card 1 -->
    <div class="col-lg-6">
      <div class="partner-card d-flex align-items-start p-4 shadow-sm bg-white rounded-4 border-start border-4 border-success h-100">
        <img src="images/global-seeds.png" alt="Global Seeds Logo" class="me-4 rounded" style="width: 100px; height: auto;" />
        <div>
          <h5 class="fw-bold">Global Seeds <span class="text-success">🌱</span></h5>
          <p class="mb-3">100% Malawian-owned seed company producing drought-tolerant maize and legumes.</p>
          <button class="btn btn-outline-success btn-sm" data-bs-toggle="modal" data-bs-target="#partnerModal1">
            <i class="fas fa-circle-info me-1"></i>More Info
          </button>
        </div>
      </div>
    </div>

    <!-- Partner Card 2 -->
    <div class="col-lg-6">
      <div class="partner-card d-flex align-items-start p-4 shadow-sm bg-white rounded-4 border-start border-4 border-warning h-100">
        <img src="images/Sun-King-Logo-01.png" alt="Sun King Logo" class="me-4 rounded" style="width: 100px; height: auto;" />
        <div>
          <h5 class="fw-bold">Sun King <span class="text-warning">🌞</span></h5>
          <p class="mb-3">World leader in off-grid solar solutions, providing affordable solar energy.</p>
          <button class="btn btn-outline-warning btn-sm" data-bs-toggle="modal" data-bs-target="#partnerModal2">
            <i class="fas fa-circle-info me-1"></i>More Info
          </button>
        </div>
      </div>
    </div>

    <!-- Partner Card 3 -->
    <div class="col-lg-6">
      <div class="partner-card d-flex align-items-start p-4 shadow-sm bg-white rounded-4 border-start border-4 border-primary h-100">
        <img src="images/cic-africa.png" alt="CIC General Malawi Logo" class="me-4 rounded" style="width: 100px; height: auto;" />
        <div>
          <h5 class="fw-bold">CIC General Malawi <span class="text-primary">🛡️</span></h5>
          <p class="mb-3">Providing essential crop insurance coverage to protect agricultural investments.</p>
          <button class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#partnerModal3">
            <i class="fas fa-circle-info me-1"></i>More Info
          </button>
        </div>
      </div>
    </div>

    <!-- Partner Card 4 -->
    <div class="col-lg-6">
      <div class="partner-card d-flex align-items-start p-4 shadow-sm bg-white rounded-4 border-start border-4 border-success h-100">
        <img src="images/uptrade.webp" alt="Uptread General Dealers Logo" class="me-4 rounded" style="width: 100px; height: auto;" />
        <div>
          <h5 class="fw-bold">Uptread General Dealers <span class="text-success">🌾</span></h5>
          <p class="mb-3">Manufacturers of Gold Organic Fertilizer, promoting eco-friendly farming practices.</p>
          <button class="btn btn-outline-success btn-sm" data-bs-toggle="modal" data-bs-target="#partnerModal4">
            <i class="fas fa-circle-info me-1"></i>More Info
          </button>
        </div>
      </div>
    </div>

  </div>
</section>


<!-- Modal Sections for Each Partner -->

<!-- Modal - Farm Concern International -->
<div class="modal fade" id="partnerModalFCI" tabindex="-1" aria-labelledby="partnerModalFCILabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-info text-white">
        <div class="d-flex align-items-center">
          <img src="images/farm_concern.png" alt="Farm Concern Logo" class="me-3" style="width: 50px; height: auto;" />
          <h5 class="modal-title mb-0" id="partnerModalFCILabel">Farm Concern International (FCI) 🌍</h5>
        </div>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p><strong>🌍 Overview:</strong> Farm Concern International (FCI) is a pan-African development organization and parent to Global Measure Malawi (GMM).</p>
        <p><strong>🌱 Key Impact Areas:</strong></p>
        <div class="row">
          <div class="col-md-6">
            <ul class="list-unstyled">
              <li>👨‍🌾 18M+ smallholder farmers impacted</li>
              <li>🌍 24 countries of operation</li>
              <li>🧩 Value chain analysis expertise</li>
              <li>📈 Smallholder commercialization</li>
            </ul>
          </div>
          <div class="col-md-6">
            <ul class="list-unstyled">
              <li>🔗 137+ development partners</li>
              <li>🏘️ Commercial Village Model implementation</li>
              <li>🤝 Win-win market partnerships</li>
              <li>🚜 Rural economic development</li>
            </ul>
          </div>
        </div>
        <p>✅ FCI & GMM use a hybrid development-private sector model to create sustainable market ecosystems for smallholder farmers.</p>
      </div>
    </div>
  </div>
</div>

	<!-- Modal Template -->
<div class="modal fade" id="partnerModal1" tabindex="-1" aria-labelledby="partnerModal1Label" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-success text-white">
        <div class="d-flex align-items-center">
          <img src="images/global-seeds.png" alt="Global Seeds Logo" class="me-3" style="width: 50px; height: auto;" />
          <h5 class="modal-title mb-0" id="partnerModal1Label">Global Seeds 🌱</h5>
        </div>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p><strong>🌍 Overview:</strong> Global Seeds is a 100% Malawian-owned seed company specializing in drought-tolerant crops. Their offerings include:</p>
        <div class="row">
          <div class="col-md-6">
            <ul class="list-unstyled">
              <li>🌰 Groundnuts (CG7, CG9, CG11)</li>
              <li>🌿 Pigeon Peas (Mwaiwathu Alimi)</li>
              <li>🥗 Beans (NUA45, Kholophethe)</li>
              <li>🌾 Soybeans (Tikolore, Makwacha)</li>
            </ul>
          </div>
          <div class="col-md-6">
            <ul class="list-unstyled">
              <li>🌽 Hybrid Maize (Mwazangati - MH34)</li>
              <li>🧡 Pro-vitamin A Maize (MH40A)</li>
              <li>🥬 Veggies: Tomato (Tengeru), Cabbage, Mustard</li>
            </ul>
          </div>
        </div>
        <p>✅ All seeds are certified under Malawi Law and sourced from local growers and cooperatives.</p>
      </div>
    </div>
  </div>
</div>

<!-- Modal 2: Sun King -->
<div class="modal fade" id="partnerModal2" tabindex="-1" aria-labelledby="partnerModal2Label" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-warning text-dark">
        <div class="d-flex align-items-center">
          <img src="images/Sun-King-Logo-01.png" alt="Sun King Logo" class="me-3" style="width: 50px; height: auto;" />
          <h5 class="modal-title mb-0" id="partnerModal2Label">Sun King 🌞</h5>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p><strong>🔋 Overview:</strong> Sun King leads the world in off-grid solar energy solutions.</p>
        <ul>
          <li>💡 Solar lighting & phone charging kits</li>
          <li>🏠 Complete home solar systems (replace the grid!)</li>
          <li>📦 One-stop service: delivery, installation, support</li>
          <li>💰 Flexible payment plans + warranty coverage</li>
        </ul>
        <p>🌍 With 29,000+ Energy Officers, they bring power to every home — affordably and reliably.</p>
      </div>
    </div>
  </div>
</div>

<!-- Modal 3: CIC General Malawi -->
<div class="modal fade" id="partnerModal3" tabindex="-1" aria-labelledby="partnerModal3Label" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-primary text-white">
        <div class="d-flex align-items-center">
          <img src="images/cic-africa.png" alt="CIC Logo" class="me-3" style="width: 50px; height: auto;" />
          <h5 class="modal-title mb-0" id="partnerModal3Label">CIC General Malawi 🛡️</h5>
        </div>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p><strong>🛡️ Protection Overview:</strong> CIC General Malawi provides crop insurance that covers:</p>
        <ul>
          <li>🔥 Fire, Flooding, Drought, Earthquakes</li>
          <li>🦗 Pest outbreaks and Malicious Damage</li>
          <li>🚜 Coverage for riots, explosions, and more</li>
        </ul>
        <p>📋 GMM ensures all crops are either fully insured or declared in a formal insurance plan.</p>
        <p>🌱 This helps sustain agricultural investments with peace of mind and national standards.</p>
      </div>
    </div>
  </div>
</div>

<!-- Modal 4: Uptread General Dealers -->
<div class="modal fade" id="partnerModal4" tabindex="-1" aria-labelledby="partnerModal4Label" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4 shadow">
      <div class="modal-header bg-success text-white">
        <div class="d-flex align-items-center">
          <img src="images/uptrade.webp" alt="Uptread Logo" class="me-3" style="width: 50px; height: auto;" />
          <h5 class="modal-title mb-0" id="partnerModal4Label">Uptread General Dealers 🌾</h5>
        </div>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p><strong>🌿 About Uptread:</strong> Manufacturers of Gold Organic Fertilizer, designed for healthier and eco-friendly farming.</p>
        <ul>
          <li>♻️ Organic inputs for better soil structure</li>
          <li>🌱 Enhances microbial activity and natural nutrition</li>
          <li>🌾 Supports long-term yield and plant health</li>
        </ul>
        <p>🤝 Together with GMM, Uptread is helping farmers adopt sustainable agriculture practices across Malawi.</p>
      </div>
    </div>
  </div>
</div>


<?php include 'includes/footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
