<?php include 'includes/topbar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Products & Services | Global Measures Malawi</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />

  <style>
    body {
      font-family: 'Roboto', sans-serif;
    }

    .hero-section {
      background: url('images/Woman-smallholder-with-bicycle-giong-to-market-in-Uganda.avif') no-repeat center center;
      background-size: cover;
      color: white;
      padding: 100px 0;
      text-align: center;
      position: relative;
    }

    .hero-section h1 {
      font-size: 3.5rem;
      text-transform: uppercase;
      font-weight: bold;
    }

    .product-card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
      transition: all 0.3s ease-in-out;
    }

    .product-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 8px 15px rgba(0, 0, 0, 0.15);
    }

    .product-card img {
      height: 80px;
      object-fit: contain;
    }

    .btn-outline-primary {
      border-radius: 20px;
    }

    .modal-header {
      background-color: #0d6efd;
      color: white;
    }

    .modal-content {
      border-radius: 10px;
    }
  </style>
</head>

<body>

<!-- Hero Section -->
<section class="hero-section">
  <div class="container">
    <h1>Our Products & Services 🌾</h1>
    <p>Empowering agriculture and energy sustainability in Malawi through innovation.</p>
  </div>
</section>
<section class="container my-5">
  <h2 class="text-center mb-5 display-4 fw-bold">What We Offer <span class="text-success">🌿</span></h2>
  
  <div class="row row-cols-1 row-cols-md-2 row-cols-lg-4 g-4">

    <!-- Certified Seeds -->
    <div class="col">
      <div class="card h-100 border-0 shadow-lg rounded-4 text-center p-4">
        <img src="images/seeds.webp" alt="Certified Seeds" class="img-fluid mb-3" style="max-height: 140px; object-fit: contain;">
        <h5 class="fw-bold mb-2">Certified Seeds</h5>
        <p class="text-muted small mb-3">High-quality, drought-resistant seeds offered on affordable credit to smallholder farmers.</p>
        <button class="btn btn-success btn-sm px-3" data-bs-toggle="modal" data-bs-target="#modalSeeds">
          <i class="fas fa-leaf me-1"></i> Learn More
        </button>
      </div>
    </div>

    <!-- Solar Energy Tools -->
    <div class="col">
      <div class="card h-100 border-0 shadow-lg rounded-4 text-center p-4">
        <img src="images/Top-10-solar-farm-companies.webp" alt="Solar Energy Tools" class="img-fluid mb-3" style="max-height: 140px; object-fit: contain;">
        <h5 class="fw-bold mb-2">Green Energy Tools</h5>
        <p class="text-muted small mb-3">Solar-powered equipment designed to reduce energy costs and promote sustainability.</p>
        <button class="btn btn-warning btn-sm px-3" data-bs-toggle="modal" data-bs-target="#modalSolar">
          <i class="fas fa-solar-panel me-1"></i> Learn More
        </button>
      </div>
    </div>

    <!-- Market Research -->
    <div class="col">
      <div class="card h-100 border-0 shadow-lg rounded-4 text-center p-4">
        <img src="images/market-research.jpg" alt="Market Research" class="img-fluid mb-3" style="max-height: 140px; object-fit: contain;">
        <h5 class="fw-bold mb-2">Market Research</h5>
        <p class="text-muted small mb-3">We analyze markets and value chains to guide data-driven strategic decisions.</p>
        <button class="btn btn-primary btn-sm px-3" data-bs-toggle="modal" data-bs-target="#modalResearch">
          <i class="fas fa-chart-line me-1"></i> Learn More
        </button>
      </div>
    </div>

    <!-- Digital Platforms -->
    <div class="col">
      <div class="card h-100 border-0 shadow-lg rounded-4 text-center p-4">
        <img src="images/1_PIXd6S7CYFgfsnbHrrUv7w.png" alt="Digital Platforms" class="img-fluid mb-3" style="max-height: 140px; object-fit: contain;">
        <h5 class="fw-bold mb-2">Digital Platforms</h5>
        <p class="text-muted small mb-3">Tailor-made mobile apps and web solutions for rural and urban user engagement.</p>
        <button class="btn btn-dark btn-sm px-3" data-bs-toggle="modal" data-bs-target="#modalDigital">
          <i class="fas fa-mobile-alt me-1"></i> Learn More
        </button>
      </div>
    </div>

  </div>
</section>

<section class="my-5">
  <h4 class="text-center fw-bold mb-5">What Our Partners Say 💬</h4>
  <div class="container" style="max-width: 900px;">
    <div class="row row-cols-1 row-cols-md-2 g-4">

      <!-- Testimonial 1 -->
      <div class="col">
        <div class="d-flex align-items-start bg-light rounded shadow-sm p-4 h-100">
          <img src="images/vga1.jpeg" alt="Village Headman" class="rounded-circle me-3" style="width: 60px; height: 60px; object-fit: cover;">
          <div>
            <p class="mb-2">"GMM's solar kits have transformed our community!"</p>
            <footer class="blockquote-footer mt-2">Village Headman, <cite title="Mchinji">Mchinji</cite></footer>
          </div>
        </div>
      </div>

      <!-- Testimonial 2 -->
      <div class="col">
        <div class="d-flex align-items-start bg-light rounded shadow-sm p-4 h-100">
          <img src="images/Asimenye.webp" alt="Farmer" class="rounded-circle me-3" style="width: 60px; height: 60px; object-fit: cover;">
          <div>
            <p class="mb-2">"We’ve seen real crop yield improvement using their certified seeds."</p>
            <footer class="blockquote-footer mt-2">Farmer Cooperative, <cite title="Lilongwe">Lilongwe</cite></footer>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>


<section class="bg-success text-white text-center py-5 rounded-4 mt-5">
  <h3 class="fw-bold mb-3">Ready to Grow with GMM?</h3>
  <p class="mb-4">Partner with us to empower Malawian agriculture through innovation and sustainability.</p>
  <a href="contact.php" class="btn btn-light px-4 py-2">Contact Us</a>
</section>


<!-- Modals -->

<!-- Seeds Modal -->
<div class="modal fade" id="modalSeeds" tabindex="-1" aria-labelledby="modalSeedsLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title" id="modalSeedsLabel">Certified Seeds on Credit</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>GMM provides <strong>Certified Seeds</strong> — including maize, legumes, and vegetables — sold on <strong>affordable and farmer-friendly credit</strong>.</p>
        <ul>
          <li>🌽 Improves crop yield & quality</li>
          <li>💳 Accessible via credit for smallholders</li>
          <li>📈 Boosts food security and agricultural output</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<!-- Solar Modal -->
<div class="modal fade" id="modalSolar" tabindex="-1" aria-labelledby="modalSolarLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4">
      <div class="modal-header bg-warning text-dark">
        <h5 class="modal-title" id="modalSolarLabel">Green Energy Tools</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>GMM promotes <strong>solar-powered agricultural tools and household systems</strong> to reduce fossil fuel reliance and costs.</p>
        <ul>
          <li>☀️ Environmentally friendly technology</li>
          <li>⚡ Lower energy bills and maintenance costs</li>
          <li>🚜 Supports off-grid rural communities</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<!-- Market Research Modal -->
<div class="modal fade" id="modalResearch" tabindex="-1" aria-labelledby="modalResearchLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalResearchLabel">Market Research & Value Chain Analysis</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>GMM conducts <strong>data-driven research</strong> to analyze markets and value chains for clients in agriculture and development sectors.</p>
        <ul>
          <li>🔍 Identifies consumer trends and demands</li>
          <li>🧩 Uncovers gaps and growth opportunities</li>
          <li>📊 Enables smarter investment and planning</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<!-- Digital Platforms Modal -->
<div class="modal fade" id="modalDigital" tabindex="-1" aria-labelledby="modalDigitalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content rounded-4">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title" id="modalDigitalLabel">Custom Digital Platforms</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>We build <strong>tailored digital platforms</strong> including mobile apps and web tools for clients with specific needs.</p>
        <ul>
          <li>📱 Smart and feature phone apps</li>
          <li>💻 Web platforms optimized for rural & urban use</li>
          <li>🔗 Seamless integration with services & data</li>
        </ul>
        <p>GMM can also <strong>partner as a consortium member, co-implementer, or last-mile distributor</strong>.</p>
      </div>
    </div>
  </div>
</div>



<?php include 'includes/footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
