<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>About Us | Golden Buddha Spa</title>
  <meta name="description" content="Learn more about Golden Buddha Spa, our vision, mission, and commitment to your well-being.">
  <meta property="og:title" content="About Golden Buddha Spa" />
  <meta property="og:description" content="Your destination for peace, healing, and rejuvenation." />
  <meta property="og:image" content="images/logo-tr.png" />
  <link rel="icon" type="image/png" href="images/logo-tr.png" />

  <!-- Bootstrap & Google Fonts -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500&family=Open+Sans&display=swap" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <link rel="stylesheet" href="css/style.css">
  
  <style>
    .text-gold { color: #c39a5f; }
    .section-bg { background-color: #fdf8f5; }
    .about-section h2 {
      font-family: 'Playfair Display', serif;
      font-weight: 500;
    }
  </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<!-- About Us Section -->
<section class="about-section py-5 section-bg">
  <div class="container">
    <div class="row align-items-center">
      
      <div class="col-md-6 mb-4 mb-md-0" data-aos="fade-right">
        <img src="images/steam.jpg" alt="Spa Interior" class="img-fluid rounded shadow">
      </div>

      <div class="col-md-6" data-aos="fade-left">
        <h2 class="text-gold mb-4">About Golden Buddha Spa</h2>
        <p>At <strong>Golden Buddha Spa</strong>, we believe that true wellness is achieved when the body, mind, and spirit are in harmony. Our sanctuary in the heart of South Africa offers a serene escape from the stresses of daily life.</p>
        <p>Founded with a vision to bring ancient healing practices into the modern world, our team of certified massage therapists and wellness professionals are passionate about your relaxation and rejuvenation.</p>
        <p><strong>Whether you’re looking for deep tissue therapy, calming aromatherapy, or a tranquil space to unwind, you’ll find your peace here.</strong></p>
      </div>

    </div>
  </div>
</section>

<!-- Vision & Mission -->
<section class="py-5">
  <div class="container">
    <div class="row text-center" data-aos="zoom-in-up">
      <div class="col-md-6 mb-4">
        <div class="p-4 border rounded bg-white h-100 shadow-sm">
          <h4 class="text-gold mb-3">Our Vision</h4>
          <p>To be the most loved destination for spa and wellness, known for soul-soothing experiences, natural therapies, and mindful service.</p>
        </div>
      </div>
      <div class="col-md-6 mb-4">
        <div class="p-4 border rounded bg-white h-100 shadow-sm">
          <h4 class="text-gold mb-3">Our Mission</h4>
          <p>To guide every guest on a journey of renewal through expert touch, ancient healing wisdom, and an atmosphere of sacred serenity.</p>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include 'footer.php'; ?>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
<script>
  AOS.init({
    duration: 2000,
    once: true
  });
</script>

</body>
</html>
