  <!DOCTYPE html>
  <html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard</title>
    <link rel="apple-touch-icon" sizes="76x76" href="../images/logo-tr.png">
    <link rel="icon" type="image/png" href="../images/logo-tr.png">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
  </head>
  <body class="hold-transition sidebar-mini layout-fixed">

  <?php 
    include('menu_admin.php');
    include_once 'model/services_model.php';
    include_once 'model/bookings_model.php';
    include_once 'model/users_model.php';

    $users_model = new users_model();
    $services_model = new services_model();
    $bookings_model = new bookings_model();

    $number_of_services = $services_model->getNumberofServices();
    $num_bookings = $bookings_model->countActiveBookings();
    $num_users = $users_model->getNumberofUsers();

    // Booking stats per month
    $monthlyStatsRaw = $bookings_model->getMonthlyBookingStats();
    // Initialize all months with zero data for each status
    $months = array_fill(1, 12, [
        'cancelled' => 0,
        'awaiting' => 0,
        'successful' => 0,
        'missed' => 0
    ]);

    // Fill the months array with actual data from the database
    foreach ($monthlyStatsRaw as $row) {
        $month = (int)$row['month'];
        $status = $row['status'];
        $count = (int)$row['total'];

        if (isset($months[$month][$status])) {
            $months[$month][$status] = $count;
        }
    }

    // Create the labels and data arrays for the chart
    $labels = $cancelled = $awaiting = $successful = $missed = [];
    for ($i = 1; $i <= 12; $i++) {
        $labels[] = date('M', mktime(0, 0, 0, $i, 10)); // Month names (Jan, Feb, ...)
        $cancelled[] = $months[$i]['cancelled'];
        $awaiting[] = $months[$i]['awaiting'];
        $successful[] = $months[$i]['successful'];
        $missed[] = $months[$i]['missed'];
    }
?>


  ?>

  <div class="content-wrapper">
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- Services Card -->
          <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
              <div class="inner">
                <h3><?php echo number_format($number_of_services, 0); ?></h3>
                <p>Spa Services</p>
              </div>
              <div class="icon"><i class="fa fa-spa"></i></div>
              <a href="services.php" class="small-box-footer">View Services Offered <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>

          <!-- Active Bookings Card -->
          <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
              <div class="inner">
                <h3><?php echo $num_bookings; ?></h3>
                <p>Active Bookings</p>
              </div>
              <div class="icon"><i class="fas fa-bed"></i></div>
              <a href="active_bookings.php" class="small-box-footer">View Active Bookings <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>

          <!-- View Bookings Card -->
          <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
              <div class="inner">
                <h3><i class="fa fa-calendar-alt"></i></h3>
                <p>View Bookings</p>
              </div>
              <div class="icon"><i class="fas fa-calendar"></i></div>
              <a href="bookings.php" class="small-box-footer">View All Bookings <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>

          <!-- System Users Card -->
          <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
              <div class="inner">
                <h3><?php echo $num_users; ?></h3>
                <p>System Users</p>
              </div>
              <div class="icon"><i class="fa fa-users"></i></div>
              <a href="system_users.php" class="small-box-footer">View Users <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
        </div>

        <!-- Chart Section -->
        <div class="row mt-4">
          <div class="col-12">
            <div class="card">
              <div class="card-header bg-gradient-primary">
                <h3 class="card-title">Monthly Booking Summary</h3>
              </div>
              <div class="card-body">
                <canvas id="bookingsChart" height="120"></canvas>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

  <aside class="control-sidebar control-sidebar-dark"></aside>

  <!-- JS Libraries -->
  <script src="plugins/jquery/jquery.min.js"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js"></script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="dist/js/adminlte.js"></script>
  <script src="plugins/chart.js/Chart.min.js"></script>
  <script src="js/script.js"></script>

  <!-- Toast Function -->
  <script>
    function refuse(Role) {
      toastr.options = {
        "closeButton": true,
        "progressBar": false,
        "positionClass": "toast-top-right",
        "timeOut": "5000",
        "extendedTimeOut": "3000"
      };
      toastr.error(`You don't have permission to view ${Role} Transactions.`, "Permission Denied");
    }
  </script>

  <!-- Booking Chart Data -->
  <script>
  const bookingLabels = <?php echo json_encode($labels); ?>;
  const cancelledData = <?php echo json_encode($cancelled); ?>;
  const awaitingData = <?php echo json_encode($awaiting); ?>;
  const successfulData = <?php echo json_encode($successful); ?>;
  const missedData = <?php echo json_encode($missed); ?>;
  document.addEventListener('DOMContentLoaded', function () {
  const ctx = document.getElementById('bookingsChart').getContext('2d');

  new Chart(ctx, {
    type: 'bar', // Overall chart type
    data: {
      labels: bookingLabels,
      datasets: [
        {
          label: 'Cancelled',
          data: cancelledData,
          backgroundColor: 'rgba(255, 99, 132, 0.6)',
          borderColor: 'rgba(255, 99, 132, 1)',
          borderWidth: 1
        },
        {
          label: 'Missed / Skipped',
          data: missedData,
          backgroundColor: 'rgba(255, 159, 64, 0.6)',
          borderColor: 'rgba(255, 159, 64, 1)',
          borderWidth: 1
        },
        {
          label: 'Awaiting Confirmation',
          data: awaitingData,
          type: 'line',  // Line chart type
          borderColor: 'rgba(54, 162, 235, 1)', // Line color
          backgroundColor: 'rgba(54, 162, 235, 0.2)', // Transparent fill for line
          pointBackgroundColor: 'rgba(54, 162, 235, 1)', // Point color
          pointRadius: 4, // Make points noticeable
          fill: false,  // No fill under the line
          tension: 0.3, // Line smoothness
          borderWidth: 2,
        },
        {
          label: 'Successful',
          data: successfulData,
          backgroundColor: 'rgba(75, 192, 192, 0.6)',
          borderColor: 'rgba(75, 192, 192, 1)',
          borderWidth: 1
        }
      ]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'top' },
        tooltip: { mode: 'index', intersect: false }
      },
      scales: {
        y: {
          beginAtZero: true,
          title: {
            display: true,
            text: 'Bookings Count'
          }
        }
      }
    }
  });
});

  </script>

  </body>
  </html>
