<style>
  .service-card {
    border: 2px solid transparent;
    cursor: pointer;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  .service-card:hover {
    border-color: #c5a25d;
  }

  .service-card.selected {
    border-color: #c5a25d;
    box-shadow: 0 0 8px rgba(197, 162, 93, 0.5);
  }

  .text-gold {
    color: #c5a25d;
  }
</style>



<!-- Top Bar -->
	      <div class="top-bar py-2">
          <div class="container">
          <!-- Contact Info -->
          <div class="contact-info">
            <a href="tel:+27655555577"><i class="fas fa-phone"></i> <span class="text">+27 65 555 5577</span></a>
            <a href="https://wa.me/+27711553577" target="_blank"><i class="fab fa-whatsapp"></i> <span class="text">+27 71 155 3577</span></a>
            <a href="mailto:info@goldenbuddhaspa.co.za"><i class="fas fa-envelope"></i> <span class="text">info@goldenbuddhaspa.co.za</span></a>
            <a href="https://maps.google.com/?q=Golden+Buddha+Spa+90+Blairegowrie+Dr+Randburg+South+Africa" target="_blank"><i class="fas fa-map-marker-alt"></i> <span class="text">90 Blairegowrie, Randburg</span></a>
          </div>

          <!-- Social Icons -->
            <div class="social-icons">
              <a href="https://facebook.com" target="_blank"><i class="fab fa-facebook-f"></i></a>
              <a href="https://instagram.com" target="_blank"><i class="fab fa-instagram"></i></a>
              <a href="https://twitter.com" target="_blank"><i class="fab fa-twitter"></i></a>
            </div>
          </div>
        </div>
        <!-- Navbar -->
	      <nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top">
		      <div class="container">
		        <a class="navbar-brand d-flex align-items-center" href="#home">
			        <img src="images/logo-tr.png" alt="Logo" height="40" class="me-2"> Golden Buddha Spa
			      </a>

		        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
			        <span class="navbar-toggler-icon"></span>
		        </button>
            <div class="collapse navbar-collapse" id="navbarNav">
              <ul class="navbar-nav ms-auto">
                <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="about.php">About</a></li>
                <li class="nav-item"><a class="nav-link" href="services.php">Services</a></li>
                <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
                <li class="nav-item">
                <a class="btn btn-gold ms-2" data-bs-toggle="modal" data-bs-target="#bookingModal">Book appointment</a>
                </li>

              </ul>
            </div>
          </div>
        </nav>

        <?php
            include_once 'model/service_model.php';

            $service_model = new service_model();

            $services = $service_model->getActiveServices();
        ?>


        <!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">

<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">




<style>
  body {
    font-family: 'Inter', sans-serif;
  }

  /* FIRST MODAL ONLY - Service Selection */
#bookingModal .modal-content {
  max-width: 900px;
  margin: auto;
  border-radius: 16px;
  overflow: hidden;
}


  .modal-body {
    display: flex;
    flex-direction: row;
    padding: 0;
    min-height: 600px;
    position: relative;
  }

  .booking-left {
    background: #f4f4f4;
    width: 280px;
    padding: 30px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
  }

  .booking-right {
    flex: 1;
    padding: 30px 40px;
    overflow-y: auto;
    width: 100%;
  }

  .booking-right h4 {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 10px;
  }

  .booking-right h5 {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 20px;
  }

  .service-card {
    border: 1px solid #eee;
    border-radius: 10px;
    cursor: pointer;
    transition: 0.3s;
  }

  .service-card:hover {
    border-color: #c5a25d;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
  }

  .service-card .card-body {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
  }

  .service-card img {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 8px;
  }

  .service-card h6 {
    font-size: 0.95rem;
    font-weight: 600;
    margin-bottom: 2px;
  }

  .service-card p {
    font-size: 0.8rem;
    margin-bottom: 4px;
    color: #666;
  }

  .service-card strong {
    font-size: 0.9rem;
    color: #bfa14f;
  }

  .close-btn {
    position: absolute;
    top: 15px;
    right: 20px;
    font-size: 1.5rem;
    font-weight: bold;
    color: #333;
    background: none;
    border: none;
    z-index: 10;
  }

  /* Responsive: Mobile View */
  @media (max-width: 768px) {
    .modal-dialog {
      max-width: 90% !important;
      margin: 1.75rem auto;
    }

    .modal-body {
      flex-direction: column;
      min-height: 90vh;
    }

    .booking-left {
      display: none !important;
    }

    .booking-right {
      padding: 20px 20px;
      overflow-y: auto;
    }
  }
</style>

<!-- Modal -->
<div class="modal fade" id="bookingModal" tabindex="-1" aria-labelledby="bookingModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content shadow">
      <div class="modal-body">
        <!-- Close Button -->
        <button type="button" class="close-btn" data-bs-dismiss="modal" aria-label="Close">&times;</button>

        <!-- Left Info Panel (hidden on mobile) -->
        <div class="booking-left d-none d-md-flex">
          <div>
            <h5>Service Selection</h5>
            <p>Please select a service for which you want to schedule an appointment.</p>
          </div>
          <div class="text-center">
            <img src="images/logo-tr.png" alt="Logo" class="img-fluid mb-3" style="max-height: 250px;">
            <p class="small">Questions?<br>Call <strong>+27 65 555 5577</strong></p>
          </div>
        </div>

        <!-- Right Services Panel -->
        <div class="booking-right">
          <h5>Available Services</h5>

          <div class="row g-3" id="serviceList">
            <?php foreach($services as $lst): ?>
              <div class="col-12">
                <div class="card service-card" 
     role="button" 
     tabindex="0"
     data-service-code="<?= $lst['service_code']?>" 
     data-service="<?= $lst['service_name'] ?>" 
     data-price="<?= $lst['service_cost'] ?>"
     data-duration="<?= $lst['duration'] ?>">

                  <div class="card-body">
                    <img src="images/services/<?= $lst['service_image'] ?>" alt="<?= $lst['service_name'] ?>">
                    <div class="flex-grow-1">
                      <h6><?= $lst['service_name'] ?></h6>
                      <p class="text-muted"><?= $lst['short_description'] ?></p>
                      <strong><?= $lst['duration']?> - R <?= $lst['service_cost'] ?> <span class="small text-muted"></span></strong>
                    </div>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<style>
    /* MODAL WIDTH & CONTAINER */
#dateModal .modal-dialog.step2-dialog {
  max-width: 1366px;
  width: 100%;
  margin: 1.75rem auto;
}

#dateModal .modal-content.step2-content {
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
}

/* LAYOUT PANELS */
#dateModal .step2-body {
  display: flex;
  flex-wrap: nowrap;
  height: 100%;
  min-height: 650px;
  padding: 0;
  font-family: 'Inter', sans-serif;
}

#dateModal .left-panel {
  width: 300px;
  background: linear-gradient(to bottom, #2c2c2c, #1a1a1a);
  color: white;
  padding: 30px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

#dateModal .middle-panel {
  flex: 1;
  border-right: 1px solid #eee;
  background: #fff;
  overflow-y: auto;
  position: relative;
}

#dateModal .right-panel {
  width: 450px;
  background: #f8f8f8;
}

/* CALENDAR WIDTH FIXES */
#calendarContainer,
#inlineCalendar {
  width: 100%;
}

#inlineCalendar .flatpickr-innerContainer {
  width: 100% !important;
}

#inlineCalendar .flatpickr-days {
  width: 100% !important;
  display: flex;
  flex-wrap: wrap;
  justify-content: space-between;
}

/* TIME SLOT BUTTON BASE */
.time-slot-btn {
  min-width: 120px;
  text-align: center;
  padding: 0.5rem 0;
  font-size: 0.9rem;
  transition: all 0.3s ease;
  border-radius: 6px;
  border: 1px solid #ccc;
  background-color: #fff;
  cursor: pointer;
  position: relative;
}

/* AVAILABLE SLOT (Default) */
.time-slot-btn.enabled {
  background-color: #198754;
  color: white;
  border-color: #198754;
}

/* HOVER FOR AVAILABLE SLOT */
.time-slot-btn.enabled:hover {
  background-color: #157347;
  color: #fff;
}

/* SELECTED TIME SLOT */
.time-slot-btn.selected {
  background-color: #c5a25d !important;
  border-color: #c5a25d !important;
  color: white !important;
  position: relative;
}

/* Thumbs up icon on selected slot */
.time-slot-btn.selected::after {
  content: "👍";
  position: absolute;
  right: 8px;
  top: 50%;
  transform: translateY(-50%);
  font-size: 0.9rem;
  animation: pop 0.3s ease;

}

/* DISABLED TIME SLOT */
.time-slot-btn:disabled,
.time-slot-btn.bg-danger {
  background-color: #f8d7da !important;
  color: #842029;
  cursor: not-allowed;
  pointer-events: none;
  border-color: #f5c2c7;
  opacity: 0.85;
}

/* HOVER PREVENTED FOR DISABLED */
.time-slot-btn:disabled:hover {
  background-color: #f8d7da !important;
  cursor: not-allowed;
}

/* RESPONSIVE STYLES */
@media (max-width: 768px) {
  #dateModal .step2-body {
    flex-direction: column;
  }

  #dateModal .left-panel {
    display: none;
  }

  #dateModal .right-panel {
    width: 100%;
  }

  .modal-body {
    padding: 10px;
  }

  .middle-panel h5 {
    font-size: 1rem;
    margin-bottom: 1rem;
  }

  .time-slot-btn {
    font-size: 0.75rem;
    padding: 0.4rem 0.5rem;
    min-width: 90px;
  }

  .middle-panel .btn {
    font-size: 0.8rem;
  }
}
@keyframes pop {
  0% { transform: translateY(-50%) scale(0); opacity: 0; }
  80% { transform: translateY(-50%) scale(1.2); opacity: 1; }
  100% { transform: translateY(-50%) scale(1); }
}





</style>


<!-- Step 2: Date & Time Selection Modal -->
<div class="modal fade" id="dateModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl step2-dialog modal-dialog-centered">
    <div class="modal-content step2-content">
      <div class="modal-body step2-body">
        
        <!-- Left Panel -->
        <div class="left-panel">
          <div>
            <h5>Select Date & Time</h5>
            <p class="small">Please select date and time for your appointment.</p>
          </div>
          <div class="text-center mt-auto">
            <img src="images/logo-tr.png" alt="Logo" class="img-fluid mb-3" style="max-height: 200px;">
            <p class="small">Questions?<br><strong>+27 65 555 5577</strong></p>
          </div>
        </div>

        <!-- Middle Panel -->
        <div class="middle-panel position-relative">
          <button type="button" class="btn-close position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>
          <div class="p-4">
            <h5 class="mb-4">Date & Time Selection</h5>
            <div id="calendarContainer" class="mb-4">
              <div id="inlineCalendar"></div>
            </div>
            <div id="timeSlots" class="d-flex flex-wrap gap-2"></div>
            <div class="mt-4">
              <button class="btn btn-outline-secondary btn-sm" onclick="backToServiceSelection()">
                <i class="fas fa-arrow-left me-2"></i> Back
              </button>
            </div>
          </div>
        </div>

        <!-- Right Panel -->
        <div class="right-panel">
          <div class="p-4 d-flex flex-column justify-content-between h-100">
            <div>
              <h6 class="mb-3">Summary</h6>
              <div id="summaryService" class="mb-3">
                <p class="fw-bold">Tranquil Massage Retreat</p>
              </div>
            </div>

            <div>
              <hr>
              <div class="text-uppercase small text-muted mb-2">Cost Breakdown</div>
              <div class="d-flex justify-content-between mb-2">
                <span id="summaryCostLabel">Tranquil Massage Retreat</span>
                <span id="summaryCostValue">R100.00</span>
              </div>
              <hr>
              <div class="d-flex justify-content-between fw-bold">
                <span>Total Price</span>
                <span id="totalPrice">R100.00</span>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<style>
/* === Step 3 Modal === */
#confirmModal .confirm-dialog {
  max-width: 1366px;
  width: 100%;
  margin: 1.75rem auto;
}

#confirmModal .confirm-content {
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
}

#confirmModal .confirm-body {
  display: flex;
  flex-wrap: nowrap;
  height: 100%;
  min-height: 650px;
  padding: 0;
  font-family: 'Inter', sans-serif;
}

/* LEFT */
.confirm-left {
  width: 300px;
  background: linear-gradient(to bottom, #2c2c2c, #1a1a1a);
  color: white;
  padding: 30px;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}

/* MIDDLE */
.confirm-middle {
  flex: 1;
  background: #fff;
  border-right: 1px solid #eee;
  overflow-y: auto;
}

/* RIGHT */
.confirm-right {
  width: 400px;
  background: #f8f8f8;
}

/* Form Fields */
.confirm-middle label {
  font-weight: 500;
}

.confirm-middle input,
.confirm-middle select,
.confirm-middle textarea {
  font-size: 0.9rem;
}

/* Responsive */
@media (max-width: 768px) {
  #confirmModal .confirm-body {
    flex-direction: column;
  }

  .confirm-left {
    display: none;
  }

  .confirm-right {
    width: 100%;
  }

  .confirm-middle {
    padding: 20px;
  }
}
</style>

<!-- Step 3: Customer Info Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl confirm-dialog modal-dialog-centered">
    <div class="modal-content confirm-content">
      <div class="modal-body confirm-body">

        <!-- Left Panel -->
        <div class="confirm-left">
          <div>
            <h5>Enter Your Details</h5>
            <p class="small">We’ll use these details to confirm your booking.</p>
          </div>
          <div class="text-center mt-auto">
            <img src="images/logo-tr.png" alt="Logo" class="img-fluid mb-3" style="max-height: 200px;">
            <p class="small">Questions?<br><strong>+27 65 555 5577</strong></p>
          </div>
        </div>

        <!-- Middle Panel -->
        <div class="confirm-middle p-4">
          <h5 class="mb-4">Contact Information</h5>
          <form id="bookingForm">
            <div class="mb-3">
              <label for="fullname" class="form-label">Full Name *</label>
              <input type="text" class="form-control" id="fullname" required>
            </div>
            <div class="mb-3">
              <label for="sex" class="form-label">Sex *</label>
              <select class="form-select" id="sex" required>
                <option value="">Select</option>
                <option value="Female">Female</option>
                <option value="Male">Male</option>
              </select>
            </div>
            <div class="mb-3">
                <label for="phone" class="form-label">Phone Number *</label>
                <div class="input-group">
                    <select id="countryCode" class="form-select" style="max-width: 160px;" required></select>
                    <input type="tel" class="form-control" id="phone" placeholder="712345678" required>
                </div>
                <div class="form-text">Exclude leading zero (0) from your number.</div>
                </div>

            <div class="mb-3">
              <label for="email" class="form-label">Email *</label>
              <input type="email" class="form-control" id="email" required>
            </div>
            <div class="mb-3">
              <label for="notes" class="form-label">Notes</label>
              <textarea class="form-control" id="notes" rows="3" placeholder="Any special requests?"></textarea>
            </div>
          </form>
          <div class="mt-4 d-flex justify-content-between">
            <button class="btn btn-outline-secondary btn-sm" onclick="backToDateModal()">
              <i class="fas fa-arrow-left me-2"></i> Back
            </button>
           <button class="btn btn-gold btn-sm" onclick="submitBooking()" id="submitBtn">
                <span class="submit-text">Confirm Booking</span>
                <span class="spinner-border spinner-border-sm d-none" id="submitSpinner" role="status" aria-hidden="true"></span>
            </button>

          </div>
        </div>

        <!-- Right Panel -->
        <div class="confirm-right p-4 d-flex flex-column justify-content-between h-100">
          <div>
            <h6 class="mb-3">Booking Summary</h6>
            <div class="mb-2"><strong></strong> <span id="summaryServiceName">--</span></div>
            <div class="mb-2"><strong></strong> <span id="summaryServiceCode">--</span></div>
            <div class="mb-2"><strong>Date:</strong> <span id="summaryDate">--</span></div>
            <div class="mb-2"><strong>Time:</strong> <span id="summaryTime">--</span></div>
          </div>

          <div>
            <hr>
            <div class="text-uppercase small text-muted mb-2">Cost Breakdown</div>
            <div class="d-flex justify-content-between mb-2">
              <span id="summaryCostLabel2">Service Cost</span>
              <span id="summaryCostValue2">R0.00</span>
            </div>
            <hr>
            <div class="d-flex justify-content-between fw-bold">
              <span>Total</span>
              <span id="totalCost">R0.00</span>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>




<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  let selectedTime = "";
  let selectedDate = "";

  function generateTimeSlots(start, end, interval = 30, booked = [], selectedDate = "") {
    const slots = [];
    const now = new Date();
    const today = now.toISOString().split('T')[0];

    const startTime = new Date();
    startTime.setHours(start.split(':')[0], start.split(':')[1], 0, 0);

    const endTime = new Date();
    endTime.setHours(end.split(':')[0], end.split(':')[1], 0, 0);

    while (startTime <= endTime) {
      let hours = startTime.getHours();
      let minutes = startTime.getMinutes();
      let formatted = `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}`;
      let ampm = hours >= 12 ? 'PM' : 'AM';
      let display = `${(hours % 12 || 12).toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')} ${ampm}`;

      let disabled = false;

      if (selectedDate === today && startTime < now) {
        disabled = true; // Past time
      }

      if (booked.includes(formatted)) {
        disabled = true; // Already booked
      }

      slots.push({ display, disabled });
      startTime.setMinutes(startTime.getMinutes() + interval);
    }

    return slots;
  }

  function displayTimeSlots(slots, serviceCode) {
    const container = document.getElementById("timeSlots");
    container.innerHTML = "";

    slots.forEach(({ display, disabled }) => {
        const btn = document.createElement("button");
        btn.className = "time-slot-btn";
        btn.innerText = display;

        if (disabled) {
        btn.disabled = true;
        } else {
        btn.classList.add("enabled"); // apply bg-success
        btn.addEventListener("click", () => {
  document.querySelectorAll("#timeSlots .time-slot-btn").forEach(b => b.classList.remove("selected"));
  btn.classList.add("selected");
  selectedTime = display;

  // === Step 3 Summary Data ===
  document.getElementById("summaryTime").textContent = selectedTime;
  document.getElementById("summaryDate").textContent = selectedDate;

  const selectedService = document.querySelector(".service-card.selected");
  const serviceName = selectedService?.dataset.service || '--';
  const serviceCost = selectedService?.dataset.price || '0.00';

  document.getElementById("summaryServiceName").textContent = serviceName;
  document.getElementById("summaryServiceCode").textContent = serviceCode;
  document.getElementById("summaryCostLabel2").textContent = serviceName;
  document.getElementById("summaryCostValue2").textContent = `R${serviceCost}`;
  document.getElementById("totalCost").textContent = `R${serviceCost}`;

  // === Switch to Step 3 Modal ===
  const dateModal = bootstrap.Modal.getInstance(document.getElementById("dateModal"));
  dateModal.hide();

  const confirmModal = new bootstrap.Modal(document.getElementById("confirmModal"));
  confirmModal.show();
});

        }

        container.appendChild(btn);
    });
    }



  // Main calendar
  flatpickr("#inlineCalendar", {
    inline: true,
    minDate: "today",
    onChange: function (selectedDates, dateStr) {
      selectedDate = dateStr;

        const selectedServiceCard = document.querySelector(".service-card.selected");
        const serviceCode = selectedServiceCard ? selectedServiceCard.dataset.serviceCode : "";

      fetch(`get_booked_slots.php?date=${dateStr}&service=${serviceCode}`)
        .then(res => res.json())
        .then(booked => {
            console.log("Booked slots from server:", booked);
          const slots = generateTimeSlots("10:00", "19:30", 30, booked, dateStr);
          displayTimeSlots(slots, serviceCode);
        })
        .catch(err => {
          console.error("Error fetching booked slots:", err);
        });
    }
  });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
document.addEventListener("DOMContentLoaded", function () {
  const serviceCards = document.querySelectorAll(".service-card");

  serviceCards.forEach(card => {
    card.addEventListener("click", function () {
      // Remove previous selections
      serviceCards.forEach(c => c.classList.remove("selected"));
      this.classList.add("selected");

      // Get service details
      const serviceName = this.dataset.service || this.querySelector("h6").innerText;
      const serviceCost = this.dataset.price || this.querySelector("strong").innerText;

      // Update Step 2 modal
      document.getElementById("summaryService").innerHTML = `<p class="fw-bold">${serviceName}</p>`;
      document.getElementById("summaryCostLabel").textContent = serviceName;
      document.getElementById("summaryCostValue").textContent = `R${serviceCost}`;
      document.getElementById("totalPrice").textContent = `R${serviceCost}`;

      // Switch modals
      const bookingModal = bootstrap.Modal.getInstance(document.getElementById("bookingModal"));
      bookingModal.hide();

      const dateModal = new bootstrap.Modal(document.getElementById("dateModal"));
      dateModal.show();
    });
  });
});

// Go back from Step 2 to Step 1
function backToServiceSelection() {
  const dateModal = bootstrap.Modal.getInstance(document.getElementById("dateModal"));
  dateModal.hide();

  const bookingModal = new bootstrap.Modal(document.getElementById("bookingModal"));
  bookingModal.show();

  
}
function backToDateModal() {
  const confirmModal = bootstrap.Modal.getInstance(document.getElementById("confirmModal"));
  confirmModal.hide();

  const dateModal = new bootstrap.Modal(document.getElementById("dateModal"));
  dateModal.show();
}
</script>

<script>
// Basic list — you can expand this
const countries = [
  { name: "South Africa", code: "ZA", dial: "+27" },
  { name: "Malawi", code: "MW", dial: "+265" },
  { name: "Botswana", code: "BW", dial: "+267" },
  { name: "Zambia", code: "ZM", dial: "+260" },
  { name: "Zimbabwe", code: "ZW", dial: "+263" },
];

function loadCountryCodes() {
  const select = document.getElementById("countryCode");
  countries.forEach(country => {
    const option = document.createElement("option");
    option.value = country.dial;
    option.innerHTML = `🇨🇿 ${country.name} (${country.dial})`.replace("🇨🇿", getFlagEmoji(country.code));
    select.appendChild(option);
  });
}

function getFlagEmoji(countryCode) {
  const codePoints = countryCode
    .toUpperCase()
    .split('')
    .map(char => 127397 + char.charCodeAt());
  return String.fromCodePoint(...codePoints);
}

document.addEventListener("DOMContentLoaded", loadCountryCodes);
</script>
<script>

    function submitBooking() {
  const submitBtn = document.getElementById("submitBtn");
  const spinner = document.getElementById("submitSpinner");
  const submitText = submitBtn.querySelector(".submit-text");

  // Disable button and show spinner
  submitBtn.disabled = true;
  spinner.classList.remove("d-none");
  submitText.textContent = "Submitting...";

  const name = document.getElementById("fullname").value.trim();
  const sex = document.getElementById("sex").value;
  const phone = document.getElementById("phone").value.trim();
  const countryCode = document.getElementById("countryCode").value;
  const email = document.getElementById("email").value.trim();
  const notes = document.getElementById("notes").value.trim();

  if (!name || !sex || !phone || !countryCode) {
    Swal.fire("Missing Info", "Please fill in all required fields.", "warning");
    resetSubmitBtn();
    return;
  }

  if (phone.startsWith("0")) {
    Swal.fire("Invalid Phone", "Phone number should not start with 0.", "error");
    resetSubmitBtn();
    return;
  }

  const fullPhone = `${countryCode}${phone}`;

  const bookingData = {
    name,
    sex,
    phone: fullPhone,
    email,
    notes,
    service: document.getElementById("summaryServiceCode").textContent,
    date: document.getElementById("summaryDate").textContent,
    time: document.getElementById("summaryTime").textContent,
    cost: document.getElementById("totalCost").textContent.replace("R", "")
  };

  fetch("submit_booking.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(bookingData)
  })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        Swal.fire({
          icon: "success",
          title: "Booking Confirmed",
          text: "Thank you! Your appointment has been successfully booked.",
          confirmButtonColor: "#c5a25d"
        });

        document.getElementById("bookingForm").reset();
        document.getElementById("countryCode").selectedIndex = 0;

        const confirmModal = bootstrap.Modal.getInstance(document.getElementById("confirmModal"));
        confirmModal.hide();
      } else {
        Swal.fire("Error", data.message || "Booking failed. Please try again.", "error");
      }
    })
    .catch(err => {
      console.error(err);
      Swal.fire("Error", "An error occurred while submitting your booking.", "error");
    })
    .finally(() => {
      resetSubmitBtn();
    });

  function resetSubmitBtn() {
    submitBtn.disabled = false;
    spinner.classList.add("d-none");
    submitText.textContent = "Confirm Booking";
  }
}


</script>


