<?php

include_once 'config.php';

class services_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getNumberofServices() {
        try {
            $sql = "SELECT COUNT(*) as total FROM spa_services WHERE service_state = 1";
            $stmt = $this->link->prepare($sql);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            return $row['total'];
        } catch (PDOException $e) {
            error_log("Service count error: " . $e->getMessage());
            return 0;
        }
    }

    public function getServices(){
        $sql = "SELECT * FROM spa_services WHERE service_state = 1";
        $smtp = $this->link->prepare($sql);

        $smtp->execute();
        $services = $smtp->fetchAll(PDO::FETCH_ASSOC);
        return $services;

    }

    public function updateService($code, $name, $short, $full, $duration, $cost, $imageName = null) {
        try {
            if ($imageName) {
                $sql = "UPDATE spa_services 
                        SET service_name = ?, short_description = ?, full_description = ?, duration = ?, service_cost = ?, service_image = ? 
                        WHERE service_code = ?";
                $stmt = $this->link->prepare($sql);
                return $stmt->execute([$name, $short, $full, $duration, $cost, $imageName, $code]);
            } else {
                $sql = "UPDATE spa_services 
                        SET service_name = ?, short_description = ?, full_description = ?, duration = ?, service_cost = ? 
                        WHERE service_code = ?";
                $stmt = $this->link->prepare($sql);
                return $stmt->execute([$name, $short, $full, $duration, $cost, $code]);
            }
        } catch (PDOException $e) {
            error_log("Update Error: " . $e->getMessage());
            return false;
        }
    }

    public function softDeleteService($service_code){
        $sql = "UPDATE spa_services SET service_state = 3 WHERE service_code = :code";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([':code' => $service_code]);
    }

    public function addService($data) {
        $sql = "INSERT INTO spa_services (service_code, service_name, short_description, full_description, duration, service_cost, service_image, service_state, operator)
                VALUES (:service_code, :name, :short_desc, :full_desc, :duration, :cost, :image, 1, :operator)";
        $stmt = $this->link->prepare($sql);
        return $stmt->execute([
            ':service_code' => $data['service_code'],
            ':name' => $data['service_name'],
            ':short_desc' => $data['short_description'],
            ':full_desc' => $data['full_description'],
            ':duration' => $data['service_duration'],
            ':cost' => $data['service_cost'],
            ':image' => $data['service_image'],
            'operator' => $data['operator']
        ]);
    }

    public function generateNextCode() {
        $sql = "SELECT MAX(service_code) AS max_code FROM spa_services";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result && !empty($result['max_code'])) {
            return $result['max_code'] + 1;
        } else {
            return 2000;
        }
    }





}