	<!DOCTYPE html>
	  <html lang="en">
	    <head>
	      <meta charset="UTF-8" />
	      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
	      <title>Golden Buddha Spa</title>
	      <meta name="description" content="Golden Buddha Spa - Your destination for peace, healing, and rejuvenation in Blantyre.">
        <meta property="og:title" content="Golden Buddha Spa">
        <meta property="og:description" content="Book a massage, relax, and rejuvenate at our peaceful spa.">
        <meta property="og:image" content="images/logo-tr.png">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

  	    <link rel="icon" type="image/png" href="images/logo-tr.png">



	      <!-- Bootstrap & Google Fonts -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500&family=Open+Sans&display=swap" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
        <link rel="stylesheet" href="css/style.css">
      </head>
	    <body>

	      <?php
          include 'navbar.php';
        ?>

	  <header style="position: relative;">
	  <div id="heroCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-pause="false" data-bs-interval="8000">
		<div class="carousel-inner">

		  <!-- Slide 1 -->
		  <div class="carousel-item active">
			<img src="images/massage.jpg" class="d-block w-100" alt="Welcome Slide">
			<div class="carousel-caption text-center">
			  <div class="caption-box">
				<h1>Golden Buddha Spa</h1>
				<p>The home of stillness, A Return to self sanctuary .</p>
				<a data-bs-toggle="modal" data-bs-target="#bookingModal" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Slide 2 -->
		  <div class="carousel-item">
			<img src="images/facial.jpg" class="d-block w-100" alt="Facial Treatment">
			<div class="carousel-caption text-center">
			  <div class="caption-box">
				<h1>Unwind in Pure Bliss</h1>
				<p>Where ancient healing meets sacred serenity.</p>
				<a data-bs-toggle="modal" data-bs-target="#bookingModal" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Slide 3 -->
		  <div class="carousel-item">
			<img src="images/steam.jpg" class="d-block w-100" alt="Steam Therapy">
			<div class="carousel-caption text-center">
			  <div class="caption-box">
				<h1>Because You Deserve This</h1>
				<p>Take time for yourself — your mind, body and you soul will thank you.</p>
				<a data-bs-toggle="modal" data-bs-target="#bookingModal" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		</div>

		<!-- Carousel Controls -->
		<button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
		  <span class="carousel-control-prev-icon"></span>
		</button>
		<button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
		  <span class="carousel-control-next-icon"></span>
		</button>
	  </div>
	</header>

	<!-- Welcome Features Section -->
	<section class="parallax-welcome text-white text-center">
	  <div class="overlay">
		<div class="container py-5">
		  <div class="row g-4">

			<div class="col-md-4">
			  <i class="fas fa-spa fa-3x text-gold mb-3"></i>
			  <h4>Relaxing Atmosphere</h4>
			  <p>Immerse yourself in a calm, peaceful environment designed for ultimate relaxation.</p>
			</div>

			<div class="col-md-4">
			  <i class="fas fa-hand-holding-water fa-3x text-gold mb-3"></i>
			  <h4>Expert Therapists</h4>
			  <p>Our skilled therapists provide personalized treatments tailored to your needs.</p>
			</div>

			<div class="col-md-4">
			  <i class="fas fa-leaf fa-3x text-gold mb-3"></i>
			  <h4>Natural Ingredients</h4>
			  <p>We use only the finest natural and organic products for your skin and body.</p>
			</div>

		  </div>
		</div>
	  </div>
	</section>


	<style>
	  .text-gold {
		color: #c8aa6e;
	  }
	</style>
	<!-- SERVICES SECTION -->
	<section id="services" class="py-5" style="background-color: #fdf8f5;">
	  <div class="container">
		<div class="text-center mb-5">
		  <h2 class="section-title">Our Services</h2>
		  <p class="text-muted">Relax, recharge, and restore with our premium massage treatments</p>
		</div>
		<div class="row g-4">

		  <!-- Service 1 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-right">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/thai.jpg" class="card-img-top service-img" alt="Thai Aroma Hot Oil Massage">
			  <div class="card-body">
				<h5 class="card-title">Thai Aroma Hot Oil Massage Asian Blend</h5>
				<p class="card-text">Gentle pressure massage with essential oils for deep relaxation and healing.</p>
				<ul class="list-unstyled">
				  <li>✓ Soft, soothing strokes</li>
				  <li>✓ Essential oil therapy</li>
				  <li>✓ Full-body relaxation</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>60min - R 400</li>
				  <li>90min - R 550</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Service 2 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-up">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/thai-sports.jpg" class="card-img-top service-img" alt="Thai Sports Massage">
			  <div class="card-body">
				<h5 class="card-title">Thai Sports Massage Full Body</h5>
				<p class="card-text">Targets muscle tension and repetitive-use injuries using deep pressure.</p>
				<ul class="list-unstyled">
				  <li>✓ Ideal for athletes</li>
				  <li>✓ Relieves repetitive strain</li>
				  <li>✓ Full-body or focused therapy</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>60min - R 400</li>
				  <li>90min - R 580</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Service 3 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-left">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/swedish-massage.jpg" class="card-img-top service-img" alt="Swedish Massage">
			  <div class="card-body">
				<h5 class="card-title">Full Body Swedish Massage</h5>
				<p class="card-text">Gentle massage ideal for relaxation, tension relief, and first-timers.</p>
				<ul class="list-unstyled">
				  <li>✓ Light to medium pressure</li>
				  <li>✓ Releases muscle knots</li>
				  <li>✓ Ideal for stress relief</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>60min - R 400</li>
				  <li>90min - R 550</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Service 4 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-right">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/indian-head.jpg" class="card-img-top service-img" alt="Indian Head Massage">
			  <div class="card-body">
				<h5 class="card-title">Indian Head Massage</h5>
				<p class="card-text">Stimulates blood flow, clears sinuses, and enhances sleep.</p>
				<ul class="list-unstyled">
				  <li>✓ Focused on head, neck, shoulders</li>
				  <li>✓ Boosts circulation</li>
				  <li>✓ Reduces stress & insomnia</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>30min - R 250</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Service 5 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-up">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/deep.jpg" class="card-img-top service-img" alt="Deep Tissue Massage">
			  <div class="card-body">
				<h5 class="card-title">Deep Tissue Massage</h5>
				<p class="card-text">Focused massage to relieve chronic muscle tension and pain.</p>
				<ul class="list-unstyled">
				  <li>✓ Deep finger pressure</li>
				  <li>✓ Targets inner muscle layers</li>
				  <li>✓ Ideal for chronic pain</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>60min - R 400</li>
				  <li>90min - R 580</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		  <!-- Service 6 -->
		  <div class="col-md-6 col-lg-4" data-aos="fade-left">
			<div class="card h-100 shadow-sm">
			  <img src="images/services/thai-back.jpeg" class="card-img-top service-img" alt="Thai Back Massage">
			  <div class="card-body">
				<h5 class="card-title">Thai Back Massage</h5>
				<p class="card-text">Oil and balm therapy focused on the back, neck, and shoulders.</p>
				<ul class="list-unstyled">
				  <li>✓ Relieves knots & tightness</li>
				  <li>✓ Improves circulation</li>
				  <li>✓ Deep back therapy</li>
				</ul>
				<p><strong>Pricing:</strong></p>
				<ul>
				  <li>60min - R 400</li>
				  <li>90min - R 550</li>
				</ul>
				<a onclick="bookingModule()" class="btn btn-gold">Book Now</a>
			  </div>
			</div>
		  </div>

		</div>
	  </div>
	</section>

	<section id="about" class="parallax-about">
	  <div class="parallax-overlay text-center text-white">
		<h2 class="mb-4 text-gold">About Golden Buddha Spa</h2>
		<p class="mb-5">
		  At Golden Buddha Spa, we believe that true wellness begin within. Rooted in the ancient wisdom of eastern healing traditions, our spa is more than just a space to relax but a sacred space for inner peace , energetic balance and spiritual renewal.
		</p>

		<!-- Tabs Navigation -->
		<ul class="nav nav-tabs justify-content-center mb-4" id="aboutTabs" role="tablist">
		  <li class="nav-item" role="presentation">
			<button class="nav-link active" id="aim-tab" data-bs-toggle="tab" data-bs-target="#aim" type="button" role="tab">Our Aim</button>
		  </li>
		  <li class="nav-item" role="presentation">
			<button class="nav-link" id="vision-tab" data-bs-toggle="tab" data-bs-target="#vision" type="button" role="tab">Our Vision</button>
		  </li>
		  <li class="nav-item" role="presentation">
			<button class="nav-link" id="mission-tab" data-bs-toggle="tab" data-bs-target="#mission" type="button" role="tab">Our Mission</button>
		  </li>
		</ul>

		<!-- Tabs Content -->
		<div class="tab-content text-start" id="aboutTabsContent">
		  <div class="tab-pane fade show active" id="aim" role="tabpanel">
			<p>To offer a peaceful, healing environment where stress melts away and your well-being is restored through professional care and holistic practices.</p>
		  </div>
		  <div class="tab-pane fade" id="vision" role="tabpanel">
			<p>To be the most loved destination for spa and wellness, known for soul-soothing experiences, natural therapies, and mindful service.</p>
		  </div>
		  <div class="tab-pane fade" id="mission" role="tabpanel">
			<p>To guide every guest on a journey of renewal through expert touch, ancient healing wisdom, and an atmosphere of sacred serenity.</p>
		  </div>
		</div>
	  </div>
	</section>
	<section id="testimonials" class="py-5" style="background-color: #f9f4f1;">
  <div class="container">
    <div class="text-center mb-5">
      <h2 class="text-gold">What Our Guests Say</h2>
      <p class="text-muted">Real stories from satisfied clients</p>
    </div>

    <!-- Desktop layout -->
    <div class="row d-none d-md-flex g-4">
      <div class="col-md-4">
        <div class="testimonial-card p-4 h-100 shadow rounded bg-white">
          <p class="mb-3 text-muted">“The ambiance is heavenly. I felt completely renewed after my massage. Golden Buddha Spa is my go-to wellness sanctuary.”</p>
          <div class="stars mb-2">
            ★★★★★
          </div>
          <h6 class="text-gold mb-0">– Thandi M.</h6>
        </div>
      </div>
      <div class="col-md-4">
        <div class="testimonial-card p-4 h-100 shadow rounded bg-white">
          <p class="mb-3 text-muted">“A serene and beautiful experience. The staff are kind and highly professional. The best spa I’ve been so far.”</p>
          <div class="stars mb-2">
            ★★★★☆
          </div>
          <h6 class="text-gold mb-0">– James K.</h6>
        </div>
      </div>
      <div class="col-md-4">
        <div class="testimonial-card p-4 h-100 shadow rounded bg-white">
          <p class="mb-3 text-muted">“From the moment I walked in, I felt at peace. The therapies are divine and deeply healing. Highly recommended!”</p>
          <div class="stars mb-2">
            ★★★★★
          </div>
          <h6 class="text-gold mb-0">– Loveness P.</h6>
        </div>
      </div>
    </div>

    <!-- Mobile carousel layout -->
    <div id="testimonialCarousel" class="carousel slide d-md-none" data-bs-ride="carousel">
      <div class="carousel-inner">
        <div class="carousel-item active">
          <div class="testimonial-card p-4 shadow rounded bg-white mx-3">
            <p class="mb-3 text-muted">“The ambiance is heavenly. I felt completely renewed after my massage. Golden Buddha Spa is my go-to wellness sanctuary.”</p>
            <div class="stars mb-2">★★★★★</div>
            <h6 class="text-gold mb-0">– Thandi M.</h6>
          </div>
        </div>
        <div class="carousel-item">
          <div class="testimonial-card p-4 shadow rounded bg-white mx-3">
            <p class="mb-3 text-muted">“A serene and beautiful experience. The staff are kind and highly professional. The best spa I’ve been so far.”</p>
            <div class="stars mb-2">★★★★☆</div>
            <h6 class="text-gold mb-0">– James K.</h6>
          </div>
        </div>
        <div class="carousel-item">
          <div class="testimonial-card p-4 shadow rounded bg-white mx-3">
            <p class="mb-3 text-muted">“From the moment I walked in, I felt at peace. The therapies are divine and deeply healing. Highly recommended!”</p>
            <div class="stars mb-2">★★★★★</div>
            <h6 class="text-gold mb-0">– Loveness P.</h6>
          </div>
        </div>
      </div>
      <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>
    </div>
  </div>
</section>






	  <!-- Gallery Section -->
<section id="gallery" class="py-5" style="background-color: #fdf8f5;">
  <div class="container-fluid px-5">
    <h2 class="text-center mb-4">Review Our Gallery</h2>
    <div class="row g-4">

      <!-- Image 1 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery1.jpeg" class="img-fluid rounded shadow-sm" alt="Spa Image 1">
        </div>
      </div>

      <!-- Image 2 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery2.jpg" class="img-fluid rounded shadow-sm" alt="Spa Image 2">
        </div>
      </div>

      <!-- Image 3 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery3.jpg" class="img-fluid rounded shadow-sm" alt="Spa Image 3">
        </div>
      </div>

      <!-- Image 4 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery4.jpg" class="img-fluid rounded shadow-sm" alt="Spa Image 4">
        </div>
      </div>

      <!-- Image 5 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery5.webp" class="img-fluid rounded shadow-sm" alt="Spa Image 5">
        </div>
      </div>

      <!-- Image 6 -->
      <div class="col-12 col-sm-6 col-md-4">
        <div class="gallery-img-wrap">
          <img src="images/gallery/gallery6.jpg" class="img-fluid rounded shadow-sm" alt="Spa Image 6">
        </div>
      </div>

    </div>
  </div>
</section>

<!-- Booking CTA -->
<section id="booking" class="text-center booking-cta-alt py-5">
  <div class="container">
    <h2 class="mb-3">Ready to Relax?</h2>
    <p class="mb-4">Book your appointment today and indulge in pure bliss.</p>
    <a data-bs-toggle="modal" data-bs-target="#bookingModal" class="btn btn-outline-gold btn-lg">Book Appointment</a>
  </div>
</section>
<!-- Mobile CTA Bar -->
<div class="mobile-cta-bar d-md-none">
  <a data-bs-toggle="modal" data-bs-target="#bookingModal" class="cta-btn">
    <i class="fas fa-calendar-alt me-1"></i> Book Now
  </a>
  <a href="tel:+27655555577" class="cta-btn">
    <i class="fas fa-phone-alt me-1"></i> Call
  </a>
  <a href="https://wa.me/+27711553577" class="cta-btn">
    <i class="fab fa-whatsapp me-1"></i> WhatsApp
  </a>
</div>



	 <?php   
    include 'footer.php';
   ?>




	  <!-- Bootstrap JS -->
	  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
	  <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>
	<script>
	  AOS.init({
		duration: 2000,
		once: true
	  });
	</script>
	
	


	</body>
	</html>
