<?php 
    include('menu_admin.php');
    include_once 'model/users_model.php';

    // Instantiate posts model and fetch all posts
    $users_model = new users_model();
    $users = $users_model->getsystemusers();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - Users</title>
    <link rel="apple-touch-icon" sizes="76x76" href="images/logo.png">
    <link rel="icon" type="image/png" href="images/logo.png">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">System Users</h3>
                                <button class="btn btn-primary float-right" data-toggle="modal" data-target="#addUserModal">
                                    Add New User
                                </button>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Full Name</th>
                                            <th>Email</th>
                                            <th>Registered On</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            <th style="width:12%;text-align:center">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($users as $index => $user): ?>
                                            <tr>
                                                <td><?= $index + 1 ?></td>
                                                <td><?= htmlspecialchars($user['user_fullname']) ?></td>
                                                <td><?= htmlspecialchars($user['username_email']) ?></td>
                                                <td><?= date('d F,Y', strtotime($user['user_registered'])) ?></td>
                                                <td><?= htmlspecialchars($user['user_role']) ?></td>
                                                <td><?= htmlspecialchars($user['user_state']) ?></td>
                                                <td style="text-align:center">
                                                    <a href="#" class="btn btn btn-warning"><i class="fa fa-edit"></i></a>
                                                    <a href="#" class="btn btn btn-info"><i class="fa fa-sync"></i></a>    
                                                    <a href="#" class="btn btn btn-danger"><i class="fa fa-ban"></i></a>    
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Modal for Adding New User -->
    <div class="modal fade" id="addUserModal" tabindex="-1" role="dialog" aria-labelledby="addUserModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addUserModalLabel">Add New User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addUserForm" method="POST" action="add_user.php">
                        <div class="form-group">
                            <label for="fullname">Full Name</label>
                            <input type="text" class="form-control" id="fullname" name="fullname" required>
                        </div>
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label for="userpassword">Password (sent via email)</label>
                            <input type="password" class="form-control" id="userpassword" name="userpassword" value="4345345345345345434" disabled >
                            <small class="form-text text-muted">Password will be auto-generated and sent to the user email.</small>
                        </div>
                        <div class="form-group">
                            <label for="userrole">User Role</label>
                            <select class="form-control" id="userrole" name="userrole" required>
                                <option value="" selected disabled>-- Select Role --</option>
                                <option value="Administrator">Administrator</option>
                                <option value="Editor">Editor</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="user_state">User Status</label>
                            <select class="form-control" id="user_state" name="user_state" required>
                                <option value="" selected disabled>-- Select Status --</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary" id="submitBtn">
                            Add User
                            <span id="loadingSpinner" class="spinner-border spinner-border-sm" role="status" aria-hidden="true" style="display: none;"></span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- JS Libraries -->
    <script src="plugins/jquery/jquery.min.js"></script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="dist/js/adminlte.js"></script>
    <script src="js/script.js"></script>

    <script>
        $(document).ready(function() {
            $('#addUserForm').on('submit', function(event) {
                // Disable the submit button and show the loading spinner
                $('#submitBtn').prop('disabled', true);
                $('#loadingSpinner').show();

                // Allow the form to be submitted
                // We don't need to manually handle form submission here, it's handled by the form action.
            });
        });
    </script>
</body>
</html>

