<?php
include_once 'model/posts_model.php';

// Get the post ID from the URL
$post_id = $_GET['id'] ?? 0;

if ($post_id) {
    // Instantiate the posts model
    $posts_model = new posts_model();
    
    // Fetch the post details
    $post = $posts_model->get_post_by_id($post_id);
    $comments = $posts_model->get_comments_by_post($post_id);

    if ($post) {
        // Return post details in JSON format
        echo json_encode([
            'success' => true,
            'post' => [
                'title' => $post['post_title'],
                'date' => date("F j, Y", strtotime($post['post_date'])),
                'content' => $post['post_content'],  // Assuming post_content holds the content of the post
                'image' => $post['image'],  // Add the image field
                'comments' => $comments  // Array of comments
            ]
        ]);
    } else {
        echo json_encode(['success' => false]);
    }
} else {
    echo json_encode(['success' => false]);
}
