<footer>
  <div class="footer-container">
    <div class="footer-about">
      <h3>Human Rights Defenders Coalition</h3><hr/>
      <p>
        Defending and promoting human rights through advocacy, legal support, and awareness. Committed to empowering individuals and communities in Malawi to stand up for justice and equality.
      </p>
        <p>
        <i class="fas fa-envelope"></i> 
        <a href="mailto:info@hrdcmalawi.org">info@hrdcmalawi.org</a>
      </p>
      
      <p>
        <i class="fas fa-envelope"></i> 
        <a href="mailto:support@hrdcmalawi.org">support@hrdcmalawi.org</a>
      </p>
    </div>

    <div class="footer-links">
      <h3>Quick Links</h3><hr/>
      <ul>
        <li><a href="about.php">About Us</a></li>
      
        <li><a href="contact_us.php">Contact Us</a></li>
        <li><a href="login.php">Admin Login</a></li>
      </ul>
    </div>

    <div class="footer-newsletter">
      <h3>Newsletter</h3><hr/>
      <p>Subscribe to receive updates, programs and upcoming events.</p>
      <form action="#" method="POST" class="newsletter-form">
        <input type="email" name="email" placeholder="Enter your email" required>
        <button type="submit"><i class="fas fa-paper-plane"></i> Subscribe</button>
      </form>
      <div class="social-icons">
        <a href="https://web.facebook.com/profile.php?id=100069412757081"><i class="fab fa-facebook-f"></i></a>
        <a href="https://x.com/hrdcmw"><i class="fab fa-twitter"></i></a>
        <a href="https://www.instagram.com/hrdcmw/"><i class="fab fa-instagram"></i></a>
      </div>
    </div>
  </div>

  <div class="footer-bottom">
    <p>&copy; <?php echo date("Y"); ?> Human Rights Defenders Coalition, Malawi. All Rights Reserved.</p>
  </div>
</footer>

<style>
  footer {
    background: #353330;
    color: white;
    padding: 50px 20px 20px;
    font-family: 'Poppins', sans-serif;
  }

  .footer-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 30px;
    max-width: 1200px;
    margin: auto;
  }

  .footer-about h3, .footer-links h3, .footer-newsletter h3 {
    color: #00bfa5;
    margin-bottom: 15px;
  }

  .footer-about p, .footer-links ul, .footer-newsletter p {
    font-size: 0.95rem;
    line-height: 1.6;
    color: #e0e0e0;
  }

  .footer-links ul {
    list-style: none;
    padding: 0;
    margin: 0;
  }

  .footer-links ul li {
    margin-bottom: 8px;
  }

  .footer-links ul li a {
    color: #e0e0e0;
    text-decoration: none;
    transition: color 0.3s;
  }

  .footer-links ul li a:hover {
    color: #00bfa5;
  }

  .newsletter-form {
    display: flex;
    gap: 10px;
    margin-top: 10px;
  }

  .newsletter-form input {
    flex: 1;
    padding: 10px;
    border-radius: 6px;
    border: none;
    outline: none;
  }

  .newsletter-form button {
    background: #00bfa5;
    color: white;
    border: none;
    padding: 10px 18px;
    border-radius: 6px;
    cursor: pointer;
    font-weight: 600;
    transition: background 0.3s;
  }

  .newsletter-form button:hover {
    background: #009688;
  }

  .social-icons {
    margin-top: 15px;
  }

  .social-icons a {
    color: white;
    margin-right: 10px;
    font-size: 20px;
    display: inline-block;
    transition: color 0.3s, transform 0.3s;
  }

  .social-icons a:hover {
    color: #00bfa5;
    transform: scale(1.15);
  }

  .footer-bottom {
    text-align: center;
    border-top: 1px solid rgba(255,255,255,0.1);
    margin-top: 30px;
    padding-top: 15px;
    font-size: 0.9rem;
    color: #ccc;
  }

  @media (max-width: 768px) {
    .newsletter-form { flex-direction: column; }
    .newsletter-form button { width: 100%; }
  }
</style>
