<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>HRDC Malawi | Home</title>

  <!-- Bootstrap -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <!-- FontAwesome -->
  <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <!-- GOOGLE FONT -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="css/style.css">

  <!-- MAIN HRDC ACTIVIST THEME -->
  <style>

/* =========================================================
   GLOBAL STYLES — Activist Theme
========================================================= */
body {
    font-family: "Poppins", sans-serif;
    background: #f8f9fa;
    color: #333;
    line-height: 1.7;
}

section {
    padding: 90px 0;
}

h1, h2, h3, h4 {
    font-weight: 800;
    letter-spacing: 0.5px;
}

.section-title {
    text-align: center;
    font-size: 2.4rem;
    font-weight: 800;
    color: #bf1e2e;
}

.section-underline {
    width: 80px;
    height: 5px;
    background: #bf1e2e;
    border-radius: 3px;
    margin: 10px auto 40px auto;
}

/* =========================================================
   HERO SLIDER — Activist Style
========================================================= */
#heroCarousel .carousel-item {
    height: 680px;
}

#heroCarousel .carousel-item img {
    height: 100%;
    width: 100%;
    object-fit: cover;
}

#heroCarousel .carousel-item::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(
        to bottom,
        rgba(0,0,0,0.35),
        rgba(0,0,0,0.75)
    );
}

.carousel-caption {
    bottom: 25%;
    text-shadow: 0 3px 8px rgba(0,0,0,0.75);
}

.carousel-caption h2 {
    font-size: 2.9rem;
    font-weight: 900;
    text-transform: uppercase;
}

.carousel-caption p {
    font-size: 1.1rem;
    font-weight: 500;
}

.btn-red {
    background: #bf1e2e;
    border: none;
    padding: 12px 26px;
    border-radius: 50px;
    font-weight: 700;
    color: white;
    transition: 0.3s;
}
.btn-red:hover {
    background: #8a1521;
    transform: translateY(-3px);
}

/* =========================================================
   ABOUT HRDC — Modern Activist Card
========================================================= */
.about-wrapper {
    max-width: 1100px;
    margin: auto;
}

.about-card {
    display: flex;
    flex-wrap: wrap;
    gap: 40px;
    background: #ffffff;
    padding: 55px;
    border-radius: 20px;
    box-shadow: 0 15px 45px rgba(0,0,0,0.12);
    border-left: 12px solid #bf1e2e;
}

.about-card img {
    border-radius: 50%;
    width: 300px;
    height: 300px;
    object-fit: cover;
    border: 4px solid #bf1e2e;
    box-shadow: 0 10px 25px rgba(0,0,0,0.25);
}

/* =========================================================
   LATEST NEWS — Magazine Style
========================================================= */
.news-section {
    background: #feecee;
}

.news-card {
    border-radius: 16px;
    background: #fff;
    box-shadow: 0 8px 25px rgba(0,0,0,0.12);
    overflow: hidden;
    transition: 0.35s;
}

.news-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.18);
}

.news-card img {
    height: 220px;
    object-fit: cover;
    width: 100%;
}

.news-card h5 {
    font-weight: 800;
    color: #bf1e2e;
}

.news-card a {
    font-weight: 700;
    color: #bf1e2e;
}

/* =========================================================
   MISSION & VISION — Activist Red Gradient Blocks
========================================================= */
.mission-vision {
    background: linear-gradient(to right, #bf1e2e, #8a1521);
    color: white;
    text-align: center;
    display: flex;
    justify-content: center;
    flex-wrap: wrap;
    gap: 40px;
}

.mv-box {
    max-width: 450px;
    background: rgba(255,255,255,0.15);
    padding: 40px;
    border-radius: 18px;
    border: 1px solid rgba(255,255,255,0.3);
    backdrop-filter: blur(3px);
    transition: 0.3s;
}
.mv-box:hover {
    transform: translateY(-8px);
}

.mv-icon {
    background: white;
    color: #bf1e2e;
    width: 90px;
    height: 90px;
    border-radius: 50%;
    font-size: 2.4rem;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: auto;
}

/* =========================================================
   GALLERY — Hover Zoom
========================================================= */
.hrdc-gallery {
    background: #fdf5f5;
}

.gallery-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    gap: 20px;
}

.gallery-item {
    overflow: hidden;
    border-radius: 12px;
    box-shadow: 0 12px 25px rgba(0,0,0,0.1);
}

.gallery-item img {
    width: 100%;
    height: 250px;
    object-fit: cover;
    transition: 0.4s ease;
}

.gallery-item:hover img {
    transform: scale(1.1);
}

/* =========================================================
   QUICK ACCESS — Activist Boxes
========================================================= */
.quick-access-card {
    padding: 45px;
    background: #fff;
    border-radius: 18px;
    text-align: center;
    border: 3px solid #bf1e2e;
    transition: 0.3s;
}

.quick-access-card:hover {
    transform: translateY(-8px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.18);
}

.quick-access-card i {
    font-size: 3rem;
    color: #bf1e2e;
}
.carousel-caption {
    bottom: 25%;  /* Adjust to provide more space from the bottom */
    text-shadow: 0 3px 8px rgba(0, 0, 0, 0.75);
    z-index: 5;  /* Ensure the caption is not hidden behind the arrows */
}

.carousel-control-prev,
.carousel-control-next {
    z-index: 15;  /* Make sure the arrows are above everything else */
    top: 50%;  /* Vertically center the arrows */
    transform: translateY(-50%);  /* Center the arrows correctly */
}

.carousel-control-prev-icon,
.carousel-control-next-icon {
    background-color: rgba(0, 0, 0, 0.5);  /* Optional: Slightly transparent arrows */
}



  </style>
</head>
<body>


<!-- =====================================================
     HERO SECTION
===================================================== -->
<div id="heroCarousel" class="carousel slide" data-bs-ride="carousel">

  <div class="carousel-inner">

    <div class="carousel-item active">
      <img src="images/slider.jpeg" alt="">
      <div class="carousel-caption">
        <h2>Promote and Defend Human Rights</h2>
        <p>Championing human rights, transparency, justice & good governance.</p>
        <a href="about.php" class="btn btn-red">Learn More</a>
      </div>
    </div>

    <div class="carousel-item">
      <img src="images/slider2.jpeg" alt="">
      <div class="carousel-caption">
        <h2>A Malawi that Respects Human Dignity</h2>
        <p>Empowering communities & holding duty-bearers accountable.</p>
        <a href="about.php" class="btn btn-red">Learn More</a>
      </div>
    </div>

    <div class="carousel-item">
      <img src="images/slider1.jpeg" alt="">
      <div class="carousel-caption">
        <h2>Empowering Human Rights Defenders</h2>
        <p>Strengthening voices that protect fundamental freedoms.</p>
        <a href="about.php" class="btn btn-red">Learn More</a>
      </div>
    </div>

  </div>

</div>


<!-- =====================================================
     ABOUT SECTION
===================================================== -->
<section>
 <div class="about-wrapper">

  <div class="about-card">
    <img src="images/michael_kaiyatsa.jpg" alt="">
    <div>
      <h2>About HRDC</h2>
      <p>
        The Human Rights Defenders Coalition (HRDC) is a network of organizations 
        and individuals committed to promoting and protecting human rights in Malawi.
      </p>
      <a href="about.php" class="btn btn-red mt-3">Read More</a>
    </div>
  </div>

 </div>
</section>


<!-- =====================================================
     LATEST NEWS
===================================================== -->
<section class="news-section">
  <h2 class="section-title">Latest News & Updates</h2>
  <div class="section-underline"></div>

  <div class="container-fluid">
    <div id="newsCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000" aria-label="Latest News Carousel">
      <div class="carousel-inner">

      <?php
$conn = new mysqli('localhost', 'smplus_hrdc', '0991123495@Tomaida', 'smplus_hrdc');
if ($conn->connect_error) { die("Connection failed: " . $conn->connect_error); }

$sql = "SELECT ID as id, post_title as title, post_date, image FROM hrdc_posts WHERE post_status = 'publish' ORDER BY post_date DESC LIMIT 8";
$result = $conn->query($sql);

$news = [];
while($row = $result->fetch_assoc()) { 
    $news[] = $row; 
}

$slides = array_chunk($news, 4); // 4 items per slide
$active = "active";

foreach ($slides as $slide) {
    echo '<div class="carousel-item '.$active.'">';
    echo '<div class="row g-4 justify-content-center">';
    foreach ($slide as $item) {
        // Format the date
        $formattedDate = date("M d, Y", strtotime($item['post_date']));

        // Use database image if exists, else default
        $imagePath = !empty($item['image']) && file_exists('uploads/'.$item['image']) 
                     ? 'uploads/'.$item['image'] 
                     : 'images/default_news.jpg';

        echo '
        <div class="col-lg-3 col-md-4 col-12">
          <div class="news-card p-3 bg-white rounded shadow-sm h-100">
            <img src="'.$imagePath.'" alt="'.htmlspecialchars($item["title"]).'" class="img-fluid rounded news-image">
            <div class="news-content mt-3">
              <h5>'.htmlspecialchars($item["title"]).'</h5>
              <small class="text-muted d-block mb-2">'. $formattedDate .'</small>
              <a href="news.php?id='.$item["id"].'" class="btn btn-primary mt-2">Read More →</a>
            </div>
          </div>
        </div>
        ';
    }
    echo '</div></div>';
    $active = "";
}
$conn->close();
?>

      </div>

      <!-- Carousel controls -->
      <button class="carousel-control-prev" type="button" data-bs-target="#newsCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#newsCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
      </button>
    </div>

  </div>
</section>




<!-- =====================================================
     MISSION & VISION
===================================================== -->
<section class="mission-vision">

  <div class="mv-box">
    <div class="mv-icon"><i class="fas fa-bullseye"></i></div>
    <h3>Our Mission</h3>
    <p>To strengthen the resilience of human rights defenders across Malawi.</p>
  </div>

  <div class="mv-box">
    <div class="mv-icon"><i class="fas fa-eye"></i></div>
    <h3>Our Vision</h3>
    <p>A Malawi where every person enjoys their rights without discrimination.</p>
  </div>

</section>


<!-- =====================================================
     GALLERY
===================================================== -->
<section class="hrdc-gallery">
  <h2 class="section-title">Our Work in Action</h2>
  <div class="section-underline"></div>

  <div class="gallery-container">
    <div class="gallery-item"><img src="images/one.jpg" alt=""></div>
    <div class="gallery-item"><img src="images/two.jpg" alt=""></div>
    <div class="gallery-item"><img src="images/slider2.jpeg" alt=""></div>
    <div class="gallery-item"><img src="images/four.jpg" alt=""></div>
  </div>
</section>


<!-- =====================================================
     QUICK ACCESS
===================================================== -->
<section>
  <h2 class="section-title">Quick Access</h2>
  <div class="section-underline"></div>

  <div class="container">
    <div class="row g-4">

      <div class="col-md-4">
        <div class="quick-access-card">
          <i class="fas fa-bullhorn"></i>
          <h4 class="fw-bold mt-3">Complaints</h4>
          <p>Report rights violations or abuses.</p>
          <a class="btn btn-red btn-sm mt-2" href="complaints.php">Submit</a>
        </div>
      </div>

      <div class="col-md-4">
        <div class="quick-access-card">
          <i class="fas fa-folder-open"></i>
          <h4 class="fw-bold mt-3">Resources</h4>
          <p>Access reports, publications & documents.</p>
          <a class="btn btn-red btn-sm mt-2" href="#">View</a>
        </div>
      </div>

      <div class="col-md-4">
        <div class="quick-access-card">
          <i class="fas fa-handshake"></i>
          <h4 class="fw-bold mt-3">Partners</h4>
          <p>Organizations working with HRDC.</p>
          <a class="btn btn-red btn-sm mt-2" href="partnerships.php">View Partners</a>
        </div>
      </div>

    </div>
  </div>
</section>




<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>

</body>
</html>
