<?php
// Include necessary files
include_once 'model/posts_model.php';

// Check if the category_id is provided in the GET request
if (isset($_GET['category_id'])) {
    $category_id = $_GET['category_id'];

    // Instantiate the posts model
    $posts_model = new posts_model();

    // Fetch category details
    $category_details = $posts_model->get_category_by_id($category_id);

    if ($category_details) {
        // Fetch posts associated with the category
        $posts = $posts_model->get_posts_by_category($category_id);

        // Format the response data
        $response = array(
            'success' => true,
            'category' => array(
                'category_name' => $category_details['category_name'],
                'date_created' => date("F j, Y", strtotime($category_details['date_created'])),
                'operator' => $category_details['operator'],
                'usage' => $category_details['total'],  // Usage count is already included in the query
            ),
            'posts' => $posts  // List of posts in this category
        );
    } else {
        $response = array('success' => false, 'message' => 'Category not found.');
    }

    // Return the response as JSON
    echo json_encode($response);
} else {
    echo json_encode(array('success' => false, 'message' => 'Category ID is required.'));
}
?>
