<?php  
session_start();

// If session variables are not set, redirect to login/logout
if (!isset($_SESSION['username']) || !isset($_SESSION['user_id']) ){
    header("Location: ../login.php"); // or login.php if preferred
    exit();
}

// If session is valid, assign session values
$username = $_SESSION['username'];
$userId = $_SESSION['user_id'];
$pageName = basename($_SERVER['PHP_SELF']);
?>

  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <link rel="stylesheet" href="plugins/jqvmap/jqvmap.min.css">  
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">
  <script src="plugins/js/core/jquery.min.js"></script>
  <script src="plugins/js/core/popper.min.js"></script>
  <script src="plugins/js/core/bootstrap.min.js"></script>
  <script src="plugins/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <script src="plugins/js/plugins/bootstrap-notify.js"></script>
  <script src="plugins/js/jquery.min.js" type="text/javascript"></script>
  <link rel="stylesheet" href="assets/toastr/toastr.min.css">
  <script src="assets/toastr/jquery.min.js"></script>
  <script src="assets/toastr/toastr.min.js"></script>
  <style type='text/css'>
    .bg-custom-blue{
      background: #0073b7 !important;
      color:#fff;
    }
    .hide{
      border-color: transparent;
      background-color: transparent;
      display: block;
      width: 100%;
      height: calc(2.25rem + 2px);
      padding: .375rem .75rem;
      font-size: 1rem;
      font-weight: 400;
      line-height: 1.5;
      color: #495057;
      background-color: #fff;
      background-clip: padding-box;
      border: 1px solid #ced4da;
      border-radius: .25rem;
      box-shadow: inset 0 0 0 transparent;
      transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    }
    .hide:disabled, .hide[readonly] {
      background-color: transparent;
      opacity: 1;
      border: transparent;
    }
    .table-container {
      margin: 0 auto;
      max-width: 800px;
      width:85%;
    }
    /* Remove arrows from number input */
    input[type="number"] {
      -moz-appearance: textfield;
      appearance: textfield;
    }
      
    .nav-item img {
      width: 40px; /* Adjust as needed */
      height: 40px; /* Adjust as needed */
      border-radius: 50%; /* Make it round */
      object-fit: cover; /* Maintain aspect ratio and cover */
      margin-top:-10px;
    }
    #profileDropdown::after {
      display: none;
    }
    @media print {
      table {
        background-color: #fff; /* Change the color to match your desired background */
      }
    }
  </style>
  

      <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
          <ul class="navbar-nav">
            <li class="nav-item">
              <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
          </ul>   
      
          <?php

            include_once 'model/common_model.php';
            include_once 'model/users_model.php';

            $common_model = new common_model();
            $users_model = new users_model();

            $companyDetails = $common_model->getCompanyDetails();
            $company_name = $companyDetails['company_name'];

            $total_notifications = 0;
            
            $userDetails = $users_model->authenticateUser ($username);
            $profile_picture = $userDetails['avatar'];

            $fullname= $userDetails['user_fullname']; 
            
            
          ?>
          <ul class="navbar-nav ml-auto">
            <li class="nav-item dropdown">
              <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell fa-2x"></i>
                <span class="badge badge-warning navbar-badge"><?php echo $total_notifications?></span>
              </a>
              
              <?php
                if($total_notifications>0){?>
                  <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                    <?php if($total_incomplete_check>0){ ?>
                      <a href="incomplete_transactions.php" class="dropdown-item">
                        <i class="fas fa-random mr-2"></i> View Transactions (<?php echo $total_incomplete ?>)
                        <span class="float-right text-danger text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php } ?>

                    <?php if($check_activities>0){ ?>
                      <a href="review_activities.php" class="dropdown-item">
                        <i class="fas fa-tasks mr-2"></i> You Have <?php echo $count_activities?> Tasks To Review
                        <span class="float-right text-warning text-sm"><i class="fa fa-star"></i></span>
                      </a>
                      <div class="dropdown-divider"></div>
                    <?php } ?>

                  </div>
                <?php 
              } ?>
            </li>
        
            <li class="nav-item dropdown">
              <?php
                $default_pic = 'default.png';

                $picture = (!empty($profile_picture) && file_exists("avatars/$profile_picture"))
                    ? $profile_picture
                    : $default_pic;
                ?>
                <a class="nav-link dropdown-toggle" href="#" id="profileDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <img src="avatars/<?php echo $picture; ?>" alt="Profile" />
                </a>
            
              <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                <a class="dropdown-item" href="personal_account.php"><i class="fa fa-cog"></i> Account Settings</a>
                <a class="dropdown-item" href="change_pass.php?username=<?php echo $_SESSION['username']?>"><i class="fa fa-lock"> </i> Change Password</a>
                <a class="dropdown-item" href="logout.php?username=<?php echo $username?>&session_id=<?php echo $_SESSION['sess_session']?>"><i class="fa fa-sign-in-alt"></i> Account Logout</a>
              </div>
            </li>
          
          </ul>
        </nav>

        <aside class="main-sidebar sidebar-dark-primary elevation-4">
          <a href="dashboard.php" class="brand-link">
            <img src="dist/img/AdminLTELogo.png" alt="Company Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
            <span class="brand-text font-weight-light"><?php echo $company_name?></span>
          </a>
          <div class="sidebar">
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
              <div class="info">
                
                <a href="#" class="d-block" style="color:white;">
                  <?php 
                      echo $fullname; 
                    ?>
                </a>
	              <?php ?>
              </div>
            </div>
      
	
            <nav class="mt-2">
              <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <?php $pageName = basename($_SERVER['PHP_SELF']);
                  if($pageName =='dashboard.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="dashboard.php" class="nav-link active">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="dashboard.php" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                      </a>
                    </li>
                  <?php 
                } ?>


                    <?php if($pageName =='posts.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="posts.php" class="nav-link active">
                        <i class="nav-icon fa fa-list"></i>
                        <p>View Posts</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="posts.php" class="nav-link">
                        <i class="nav-icon fas fa-list"></i>
                        <p>View Posts</p>
                      </a>
                    </li>
                  <?php 
                } ?>


                    <?php if($pageName =='releases.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="releases.php" class="nav-link active">
                        <i class="nav-icon fa fa-newspaper"></i>
                        <p>Press Releases</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="releases.php" class="nav-link">
                        <i class="nav-icon fas fa-newspaper"></i>
                        <p>Press release</p>
                      </a>
                    </li>
                  <?php 
                } ?>
                
                <?php if($pageName =='post_categories.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="post_categories.php" class="nav-link active">
                        <i class="nav-icon fa fa-cubes"></i>
                        <p>View Categories</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="post_categories.php" class="nav-link">
                        <i class="nav-icon fas fa-cubes"></i>
                        <p>View Categories</p>
                      </a>
                    </li>
                  <?php 
                } ?>


                    <?php if($pageName =='complaints.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="#" class="nav-link active">
                        <i class="nav-icon fas fa-file-signature"></i>
                        <p>Client Complaints</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="#" class="nav-link">
                        <i class="nav-icon fa fa-file-signature" ></i>
                        <p>Client Complaints</p>
                      </a>
                    </li>
                  <?php 
                } ?>
                
                <?php if($pageName =='system_users.php'){ ?>
                    <li class="nav-item menu-open">
                      <a href="system_users.php" class="nav-link active">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Users</p>
                      </a>
                    </li>
                    <?php 
                  }else{ 
                  ?>
                    <li class="nav-item">
                      <a href="system_users.php" class="nav-link">
                        <i class="nav-icon fa fa-users"></i>
                        <p>Users</p>
                      </a>
                    </li>
                  <?php 
                } ?>

                
                  
                
                
         

         

         
          

          <li class="nav-item">
            <?php if($pageName=='personal_account.php' or $pageName == 'change_pass.php' or $pageName == 'review_activities_all.php' ) { ?>
            <a href="#" class="nav-link active">
              <i class="nav-icon fas fa-user-alt"></i>
              <p>
                  User Profile
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php }else{ ?>
              <a href="#" class="nav-link">
              <i class="nav-icon fas fa-user-alt"></i>
              <p>
                  User Profile
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <?php } ?>
            <ul class="nav nav-treeview">
              	

              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="fas fa-lock nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>

              
            </ul>
          </li>
              <?php
          if($pageName =='dashboard.php'){ ?>
                  <li class="nav-item menu-open">
                    <a href="logout.php?username=<?php echo $username?>&session_id=<?php echo $_SESSION['sess_session']?>" class="nav-link">
                    <i class="nav-icon fas fa-power-off text-red"></i>
                      <p>Logout</p>
                    </a>
                  </li>
                <?php }else{ ?>
                  <li class="nav-item">
                  <a href="logout.php?username=<?php echo $username?>&session_id=<?php echo $_SESSION['sess_session']?>" class="nav-link">
                    <i class="nav-icon fas fa-power-off text-red"></i>
                      <p>Logout</p>
                    </a>
                  </li>
                <?php } ?> 
    
    <script type="text/javascript">
        $(document).ready(function() {
            <?php if (isset($_SESSION['notification'])) { ?>
                var type = "<?php echo $_SESSION['notification']['type']; ?>";
                var title = "<?php echo $_SESSION['notification']['title']; ?>";
                var message = "<?php echo $_SESSION['notification']['message']; ?>";
                
                toastr.options = {
                    "closeButton": true,
                    "progressBar": false,
                    "positionClass": "toast-top-right",
                    "timeOut": "7000",
                    "extendedTimeOut": "1000"
                };

                if (type === 'success') {
					        toastr.success(message, title || "Success");
				        } else if (type === 'error') {
					        toastr.error(message, title || "Error");
				        } else if(type === 'warning'){
					        toastr.warning(message, title || "Warning");
				        } else if(type === 'info') {
                  toastr.info(message, title || "Info");
                }


                // Clear the notification session
                <?php unset($_SESSION['notification']); ?>
            <?php } ?>
        });
    </script> 
          
         
          
          
        </ul>
      </nav>
    </div>
  </aside>
  
  <script src="plugins/jquery/jquery.min.js"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js"></script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
	  
	  