<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Submit a Complaint | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
 <link rel="stylesheet" href="css/style.css">

<style>

/* GLOBAL */
body {
  font-family: "Poppins", sans-serif;
  background: #fdfdfd;
}

.section-title {
  font-size: 2.4rem;
  font-weight: 800;
  color: #bf1e2e;
  text-align: center;
}

.section-underline {
  width: 80px;
  height: 5px;
  background: #bf1e2e;
  margin: 10px auto 40px auto;
  border-radius: 4px;
}

/* WRAPPERS */
.complaints-wrapper {
  max-width: 1100px;
  margin: auto;
  display: flex;
  flex-wrap: wrap;
  gap: 40px;
  padding: 60px 20px;
}

/* LEFT BOX - Info */
.complaints-info {
  flex: 1;
  min-width: 320px;
  padding: 40px;
  background: white;
  border-left: 10px solid #0d8ac2;
  border-radius: 18px;
  box-shadow: 0 8px 30px rgba(0,0,0,0.10);
}

.complaints-info i {
  font-size: 2rem;
  color: #0d8ac2;
  margin-bottom: 15px;
}

.complaints-info p {
  line-height: 1.6;
}

/* RIGHT BOX - Form */
.complaints-form {
  flex: 1.4;
  min-width: 350px;
  padding: 40px;
  background: white;
  border-radius: 18px;
  box-shadow: 0 8px 30px rgba(0,0,0,0.10);
}

.form-control {
  border-radius: 10px;
  padding: 14px;
  background: #f7faff;
}

.btn-red {
  background: #bf1e2e;
  border: none;
  padding: 12px 26px;
  color: white;
  font-weight: 700;
  border-radius: 50px;
  transition: 0.3s;
}

.btn-red:hover {
  background: #8a1521;
  transform: translateY(-3px);
}

/* FAQ */
.faq-section {
  padding: 60px 20px;
  background: #eef7ff;
}

.faq-question {
  font-weight: 600;
}

.accordion-button:not(.collapsed) {
  background: #0d8ac2;
  color: white;
}

</style>

</head>
<body>

<!-- BANNER -->
<section style="padding:80px 20px; background:#feecee; text-align:center;">
  <h1 class="section-title">Submit a Complaint</h1>
  <div class="section-underline"></div>
  <p style="max-width:700px; margin:auto; font-size:1.1rem;">
    HRDC is committed to protecting human rights across Malawi.  
    Use this form to report violations, abuse, or misconduct — your submission remains confidential.
  </p>
</section>


<!-- COMPLAINTS CONTENT -->
<section>
  <div class="complaints-wrapper">

    <!-- LEFT INFO -->
    <div class="complaints-info">
      <i class="fas fa-shield-alt"></i>
      <h3 class="fw-bold mb-3">Your Rights Matter</h3>

      <p>We take every complaint seriously. HRDC ensures confidentiality  
      and protects the identity of whistleblowers and victims.</p>

      <p class="mt-3"><strong>You can report issues such as:</strong></p>
      <ul>
        <li>Human rights violations</li>
        <li>Police brutality</li>
        <li>Gender-based violence</li>
        <li>Corruption & abuse of office</li>
        <li>Intimidation or harassment of activists</li>
      </ul>

      <hr>

      <p><strong>Need urgent help?</strong><br>
      Call: <span style="color:#bf1e2e;">+265 994 10 44 57</span></p>
    </div>


    <!-- RIGHT FORM -->
    <div class="complaints-form">

      <h3 class="fw-bold mb-4">Complaint Submission Form</h3>

      <form action="" method="POST" enctype="multipart/form-data">

        <div class="mb-3">
          <label class="fw-semibold">Complaint Title*</label>
          <input type="text" name="title" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Your Full Name (Optional)</label>
          <input type="text" name="fullname" class="form-control">
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Email Address*</label>
          <input type="email" name="email" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Phone Number*</label>
          <input type="text" name="phone" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Location of Incident*</label>
          <input type="text" name="location" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Description of Complaint*</label>
          <textarea name="description" rows="6" class="form-control" required></textarea>
        </div>

        <div class="mb-3">
          <label class="fw-semibold">Upload Evidence (Optional)</label>
          <input type="file" name="evidence" class="form-control">
        </div>

        <button type="submit" class="btn-red mt-2">Submit Complaint</button>

      </form>

    </div>

  </div>
</section>



<!-- FAQ SECTION -->
<section class="faq-section">
  <div class="container">

    <h2 class="section-title">Frequently Asked Questions</h2>
    <div class="section-underline"></div>

    <div class="accordion" id="faqAccordion">

      <!-- FAQ 1 -->
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#faq1">
            What happens after I submit a complaint?
          </button>
        </h2>
        <div id="faq1" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
          <div class="accordion-body">
            HRDC reviews your complaint, verifies details, and may contact you for more information.
            Cases requiring legal or humanitarian intervention are escalated to partner organizations.
          </div>
        </div>
      </div>

      <!-- FAQ 2 -->
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#faq2">
            Will my identity remain confidential?
          </button>
        </h2>
        <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
          <div class="accordion-body">
            Yes. HRDC does not disclose personal details without explicit consent.
            Anonymous submissions are accepted.
          </div>
        </div>
      </div>

      <!-- FAQ 3 -->
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#faq3">
            Can I submit complaints on behalf of someone else?
          </button>
        </h2>
        <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
          <div class="accordion-body">
            Yes — you may report violations affecting another person or community.
          </div>
        </div>
      </div>

      <!-- FAQ 4 -->
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#faq4">
            Is there a cost for submitting complaints?
          </button>
        </h2>
        <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
          <div class="accordion-body">
            No. Filing a complaint with HRDC is completely free.
          </div>
        </div>
      </div>

    </div>

  </div>
</section>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>

</body>
</html>
