<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Press Releases | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">

<style>
body {
  font-family: "Poppins", sans-serif;
  background:#f4f7fb;
  color:#333;
}

/* HERO */
.hero {
  background:url('uploads/political.jpg') center/cover no-repeat;
  padding:160px 20px;
  text-align:center;
  color:white;
  position:relative;
}
.hero::after {
  content:""; position:absolute; width:100%; height:100%;
  background:linear-gradient(to bottom right, rgba(0,0,0,.7), rgba(0,0,0,.4));
  top:0; left:0; z-index:1;
}
.hero-content { position:relative; z-index:2; }
.hero-content h1 { font-size:3.2rem; font-weight:800; }
.hero-content p { font-size:1.3rem; }

/* SECTION HEADERS */
.section-title {
  font-weight:800;
  font-size:2.3rem;
  color:#0d8ac2;
  text-align:center;
}
.section-underline {
  width:90px; height:6px; background:#bf1e2e;
  margin:12px auto 40px auto; border-radius:3px;
}

/* GRID */
.team-section { padding:70px 15px; }

.team-grid {
  max-width:1200px; margin:auto;
  display:grid; gap:30px;
  grid-template-columns:repeat(auto-fill, minmax(300px, 1fr));
}

.team-card {
  background:white; border-radius:18px;
  padding:25px; 
  box-shadow:0 10px 25px rgba(0,0,0,0.06);
  transition:0.3s ease;
  position:relative;
}
.team-card:hover {
  transform:translateY(-6px);
  box-shadow:0 18px 35px rgba(0,0,0,0.12);
}
.team-card img {
  width:100%; height:220px; object-fit:cover;
  border-radius:12px; margin-bottom:15px;
}
.team-card h5 {
  font-weight:700; color:#0d8ac2;
}
.team-card p { color:#555; }

/* BADGE */
.badge-file {
  position:absolute;
  top:15px; right:15px;
  padding:8px 12px;
  font-size:0.8rem;
  border-radius:8px;
}

/* SIDEBAR */
.sidebar {
  padding:25px;
  background:white;
  border-radius:15px;
  box-shadow: 0 10px 25px rgba(0,0,0,.08);
  position:sticky;
  top:120px;
}
.sidebar h4 {
  color:#0d8ac2;
  font-size:1.5rem;
  margin-bottom:18px;
  font-weight:700;
}

/* SEARCH */
.search-bar input {
  width:100%;
  padding:12px 15px;
  border-radius:10px;
  border:1px solid #dce3ea;
  background:#f9fbfd;
}
.search-bar input:focus {
  border-color:#0d8ac2;
  box-shadow:0 0 4px rgba(13,138,194,.4);
}

/* LATEST LIST */
.resource-list {
  list-style:none; padding:0; margin-top:15px;
}
.resource-list li {
  margin-bottom:15px;
  padding-bottom:10px;
  border-bottom:1px dashed #ddd;
}
.resource-list a {
  text-decoration:none;
  color:#444;
  font-weight:600;
  display:flex;
  align-items:center;
}
.resource-list a i {
  color:#0d8ac2;
  margin-right:8px;
}
.resource-list a:hover {
  color:#0d8ac2;
  padding-left:4px;
}
</style>
</head>

<body>

<!-- HERO -->
<div class="hero">
  <div class="hero-content">
    <h1>Press Releases</h1>
    <p>Official Statements & Public Updates from HRDC Malawi</p>
  </div>
</div>

<div class="container-fluid mt-5 mb-5 px-4">
<div class="row">

<!-- MAIN CONTENT -->
<div class="col-lg-8 mb-4">
  
    

    <div class="team-grid">
      <?php
      $conn = new mysqli('localhost','smplus_hrdc','0991123495@Tomaida','smplus_hrdc');
      $sql = "SELECT * FROM hrdc_resources ORDER BY date_created DESC";
      $result = $conn->query($sql);

      if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {

          $file = $row['resource_name'];
          $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

          // ICON & BADGE COLOR
          $icon = "fa-file"; $badge = "secondary";
          if ($ext == "pdf") { $icon = "fa-file-pdf"; $badge = "danger"; }
          elseif (in_array($ext, ["doc","docx"])) { $icon = "fa-file-word"; $badge = "primary"; }
          elseif (in_array($ext, ["xls","xlsx"])) { $icon = "fa-file-excel"; $badge = "success"; }
          elseif (in_array($ext, ["jpg","jpeg","png"])) { $icon = "fa-image"; $badge = "warning"; }
      ?>

      <div class="team-card">
        <img src="admin/press_release/images/<?php echo $row['image']; ?>" />

        <span class="badge bg-<?php echo $badge; ?> badge-file">
          <i class="fa-solid <?php echo $icon; ?>"></i> <?php echo strtoupper($ext); ?>
        </span>

        <h5><?php echo $row['title']; ?></h5>
        <p><?php echo substr($row['comment'], 0, 100); ?>...</p>

        <a href="view_press.php?id=<?php echo $row['resource_id']; ?>" class="btn btn-primary mt-2">
          <i class="fa-solid fa-eye"></i> Read Press Release
        </a>
      </div>

      <?php
        }
      }
      $conn->close();
      ?>
    </div>
</div>

<!-- SIDEBAR -->
<div class="col-lg-4">
  <div class="sidebar">
    <h4><i class="fa-solid fa-clock-rotate-left"></i> Latest Releases</h4>

    <form class="search-bar" id="searchForm">
      <input type="text" id="searchInput" placeholder="Search Press Releases...">
    </form>

    <ul class="resource-list" id="recentResources">
      <?php
      $conn = new mysqli('localhost','smplus_hrdc','0991123495@Tomaida','smplus_hrdc');
      $sql = "SELECT * FROM hrdc_resources ORDER BY date_created DESC LIMIT 7";
      $result = $conn->query($sql);

      if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
          echo '<li><a href="view_press.php?id='.$row['resource_id'].'"><i class="fa-solid fa-file-alt"></i>'.$row['title'].'</a></li>';
        }
      }
      $conn->close();
      ?>
    </ul>
  </div>
</div>

</div>
</div>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
// LIVE SEARCH
document.getElementById('searchInput').addEventListener('input', function() {
  const query = this.value;
  fetch(`search_resources.php?q=${query}`)
    .then(response => response.json())
    .then(data => {
      const list = document.getElementById('recentResources');
      list.innerHTML = '';
      data.forEach(item => {
        const li = document.createElement('li');
        li.innerHTML = `<a href="view_press.php?id=${item.id}"><i class="fa-solid fa-file-alt"></i>${item.title}</a>`;
        list.appendChild(li);
      });
    });
});
</script>
<script src="navigation.js"></script>

</body>
</html>
