<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Gallery | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<!-- Lightbox CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">

<style>
body { font-family:"Poppins",sans-serif; background:#fbfeff; }

/* Hero */
.hero {
  background: url('images/header.jpg') center/cover no-repeat;
  padding: 140px 20px; text-align:center; color:white; position:relative;
}
.hero::after {
  content:""; position:absolute; top:0; left:0; width:100%; height:100%;
  background: rgba(0,0,0,0.55); z-index:1;
}
.hero-content { position:relative; z-index:2; }

/* Section title */
.section-title { font-weight:800; font-size:2.4rem; color:#0d8ac2; text-align:center; }
.section-underline { width:70px; height:5px; background:#bf1e2e; margin:10px auto 40px auto; border-radius:3px; }

/* Gallery grid */
.gallery-grid {
  max-width:1200px; margin:auto; display:grid;
  grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
  gap:20px; padding:20px;
}
.gallery-grid img {
  width:100%; height:250px; object-fit:cover; border-radius:12px;
  transition: transform 0.3s ease;
}
.gallery-grid img:hover { transform: scale(1.05); cursor:pointer; }

/* Responsive tweaks */
@media(max-width:768px){ .gallery-grid img { height:200px; } }
@media(max-width:480px){ .gallery-grid img { height:180px; } }

</style>
</head>
<body>

<!-- HERO SECTION -->
<section class="hero">
  <div class="hero-content">
    <h1>Gallery</h1>
    <p>Snapshots of our activities, events, and impact across Malawi.</p>
  </div>
</section>

<!-- GALLERY SECTION -->
<section class="gallery-section">
  <h2 class="section-title">Our Gallery</h2>
  <div class="section-underline"></div>

  <div class="gallery-grid">
    <a href="images/one.jpg" data-lightbox="hrdc-gallery">
        <img src="images/one.jpg" alt="Gallery Image 1">
    </a>
    <a href="images/slider.jpeg" data-lightbox="hrdc-gallery">
        <img src="images/slider.jpeg" alt="Gallery Image 2">
    </a>
    <a href="images/two.jpg" data-lightbox="hrdc-gallery">
        <img src="images/two.jpg" alt="Gallery Image 3">
    </a>
    <a href="images/slider2.jpeg" data-lightbox="hrdc-gallery">
        <img src="images/slider.jpeg" alt="Gallery Image 4">
    </a>
    <a href="images/slider2.jpeg" data-lightbox="hrdc-gallery">
        <img src="images/slider2.jpeg" alt="Gallery Image 5">
    </a>
    <a href="images/four.jpg" data-lightbox="hrdc-gallery">
        <img src="images/four.jpg" alt="Gallery Image 6">
    </a>
</div>

</section>

<?php include 'footer.php'; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>

<!-- Lightbox JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/js/lightbox.min.js"></script>

</body>
</html>
