<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>HRDC - Admin Login</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="admin/plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="admin/dist/css/adminlte.min.css">
  <!-- Toastr CSS -->
  <link rel="stylesheet" href="admin/assets/toastr/toastr.min.css">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <a href="index.php"><b>HRDC</b> Admin Panel</a>
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Sign in to access admin panel</p>

      <form action="process_login.php" method="post">
        <div class="input-group mb-3">
          <input type="email" class="form-control" placeholder="Email" name="email" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" class="form-control" placeholder="Password" name="password" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>

        <div class="row">
          <!-- Go Back Button -->
          <div class="col-12 mb-3">
            <a href="javascript:history.back()" class="btn btn-secondary btn-block">Go Back</a>
          </div>

          <!-- Sign In Button -->
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
        </div>
      </form>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="admin/plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="admin/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="admin/dist/js/adminlte.min.js"></script>

<!-- Toastr JS -->
<script src="admin/assets/toastr/toastr.min.js"></script>

<script type="text/javascript">
        $(document).ready(function() {
            <?php if (isset($_SESSION['notification'])) { ?>
                var type = "<?php echo $_SESSION['notification']['type']; ?>";
                var title = "<?php echo $_SESSION['notification']['title']; ?>";
                var message = "<?php echo $_SESSION['notification']['message']; ?>";
                
                toastr.options = {
                    "closeButton": true,
                    "progressBar": false,
                    "positionClass": "toast-top-right",
                    "timeOut": "5000",
                    "extendedTimeOut": "3000"
                };

                if (type === 'success') {
                    toastr.success(message, title || "Success");
                } else if (type === 'error') {
                    toastr.error(message, title || "Error");
                } else if(type === 'warning'){
                    toastr.warning(message, title || "Warning");
                } else if(type === 'info') {
                    toastr.info(message, title || "Info");
                }

                // Clear the notification session
                <?php unset($_SESSION['notification']); ?>
            <?php } ?>
        });
    </script>
</body>
</html>
