<?php include 'topbar.php'; ?>
<?php include 'header.php'; ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Secretariat | HRDC Malawi</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
 <link rel="stylesheet" href="css/style.css">

<style>
body { font-family:"Poppins",sans-serif; background:#fbfeff; }

/* Hero */
.hero {
  background:url('images/slider2.jpeg') center/cover no-repeat;
  padding:140px 20px; text-align:center; color:white; position:relative;
}
.hero::after {
  content:""; position:absolute; width:100%; height:100%;
  background:rgba(0,0,0,0.55); top:0; left:0; z-index:1;
}
.hero-content { position:relative; z-index:2; }

/* Team */
.team-section { padding:70px 30px; }
.section-title { font-weight:800; font-size:2.4rem; color:#0d8ac2; text-align:center; }
.section-underline { width:80px; height:6px; background:#bf1e2e; margin:10px auto 40px auto; border-radius:3px; }

.team-grid {
  max-width:1200px; margin:auto;
  display:grid; gap:35px;
  grid-template-columns:repeat(3,1fr);
  text-align:center; padding:20px;
}
.team-card {
  background:white; border-radius:20px; padding:30px;
  box-shadow:0 8px 25px rgba(0,0,0,0.08);
  transition:0.3s ease;
}
.team-card:hover { transform:translateY(-6px); box-shadow:0 15px 35px rgba(0,0,0,0.13); }
.team-card img {
  width:170px; height:170px; object-fit:cover;
  border-radius:50%; border:5px solid #0d8ac2;
  margin-bottom:15px;
}

/* Responsive */
@media(max-width:992px){ .team-grid { grid-template-columns:repeat(2,1fr); } }
@media(max-width:600px){ .team-grid { grid-template-columns:1fr; } }
</style>
</head>
<body>

<section class="hero">
  <div class="hero-content">
    <h1>Secretariat</h1>
    <p>The dedicated team managing programs, operations, and implementation for HRDC.</p>
  </div>
</section>

<section class="team-section">
  <h2 class="section-title">Our Secretariat Team</h2>
  <div class="section-underline"></div>

  <div class="team-grid">

    <div class="team-card">
      <img src="images/kelvin.jpg">
      <h5 class="fw-bold mt-2">Kelvin</h5>
      <p class="text-muted">National Coordinator</p>
    </div>

    <div class="team-card">
      <img src="images/foster.jpg">
      <h5 class="fw-bold mt-2">Foster</h5>
      <p class="text-muted">Programs Officer</p>
    </div>

    

  </div>
</section>

<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="navigation.js"></script>
</body>
</html>
