@extends('front.layouts.frontlayout')

@section('mainarea')
    <div class="col-md-12">
        <!--Profile Body-->
        <div class="profile-body">
            

            <hr>

            <div class="panel panel-profile">
                <div class="panel-heading overflow-h">
                    <h2 class="panel-title heading-sm pull-left"><i class="fa fa-tasks"></i>Attendance</h2>
                </div>
                <div class="panel-body panelHolder">

                    <div class="alert-blocks alert-blocks-info">
                        <div class="overflow-h">
                            <strong class="color-dark">Last absent
                                <small class="pull-right">
                                    <em>{{$employee->lastAbsent($employee->employeeID,'date')}}</em></small>
                            </strong>
                            <small class="award-name">{{$employee->lastAbsent($employee->employeeID)}}</small>
                        </div>
                    </div>

                    <div id='calendar'></div>

                </div>
            </div>
            <!--End Profile Blog-->

        </div>
        <!--End Profile Body-->
    </div>


    {{--------------------------Show Notice MODALS-----------------}}




    <div class="modal fade show_notice in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                    <h4 id="myLargeModalLabel" class="modal-title show-notice-title">
                        {{--Notice Title using Javascript--}}
                    </h4>
                </div>
                <div class="modal-body" id="show-notice-body">
                    {{--Notice full Description using Javascript--}}
                </div>
            </div>
        </div>
    </div>



    {{------------------------END Notice MODALS---------------------}}
@endsection

@section('footerjs')
    <script>
        $(document).ready(function () {

            $('#calendar').fullCalendar({
                //			defaultDate: '2014-11-12',
                editable: false,
                eventLimit: true, // allow "more" link when too many events
                eventRender: function (event, element) {
                    if (event.className == "holiday") {
                        var dataToFind = moment(event.start).format('YYYY-MM-DD');
                        $('.fc-day[data-date="' + dataToFind + '"]').css('background', 'rgba(255, 224, 205, 1)');
                    }
                },
                events: [

                        {{-- Attendance on calendar --}}
                        @foreach($attendance as $attend)
                    {

                        title: "{{$attend->status}}",
                        start: '{{$attend->date}}',

                        @if($attend->status=='absent')
                        color: '#e50000',
                        title: "{{$attend->status}}-{{$attend->leaveType}}",
                        @endif


                    },
                        @endforeach

                        {{--Holidays on Calendar--}}
                        @foreach($holidays as $holiday)
                    {
                        className: "holiday",
                        title: "{{$holiday->occassion}}",
                        start: '{{$holiday->date}}',
                        color: 'grey'

                    },
                    @endforeach
                ]
            });
        });
    </script>
@endsection


