<?php $__env->startSection('head'); ?>

<?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainarea'); ?>

			
			<!-- BEGIN PAGE HEADER-->
			<h3 class="page-title">
			    <?php echo e($pageTitle); ?>

			</h3>
			<div class="page-bar">
				<ul class="page-breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a>
						<i class="fa fa-angle-right"></i>
					</li>
					<li>
						<a href="<?php echo e(route('admin.leavetypes.index')); ?>">LeaveTypes</a>
						<i class="fa fa-angle-right"></i>
					</li>
					<li>
						<a href="#">Leave Types</a>
					</li>
				</ul>
			
			</div>
			<!-- END PAGE HEADER-->


			<!-- BEGIN PAGE CONTENT-->

			<div class="row">
				<div class="col-md-12">
					<!-- BEGIN EXAMPLE TABLE PORTLET-->

                   <a class="btn green" onclick="showAdd()">
									Add New Leave Type
                    <i class="fa fa-plus"></i> </a>

                         <hr>
					<div class="portlet box blue">

						<div class="portlet-title">
							<div class="caption">
								<i class="fa fa-users"></i>LeaveTypes List
							</div>
							<div class="tools">
							</div>
						</div>

						<div class="portlet-body">
					<div class="note note-info">
							<p>
								<?php echo Lang::get('messages.noteLeaveTypes'); ?>

							</p>
					</div>
							<table class="table table-striped table-bordered table-hover" id="leaveType" >
							<thead>
							<tr>
								<th> # </th>
								<th> Leave </th>
								<th> Number of Leaves </th>
								<th> Action </th>

							</tr>
							</thead>
							<tbody>

							</tbody>
							</table>
						</div>
					</div>
					<!-- END EXAMPLE TABLE PORTLET-->
					
				</div>
			</div>
			<!-- END PAGE CONTENT-->

    


			
<?php echo $__env->make('admin.include.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('include.show-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
             

<?php $__env->stopSection(); ?>


<?php $__env->startSection('footerjs'); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/media/js/jquery.dataTables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"); ?>


	<script>
        var table = $('#leaveType').dataTable( {
                    "cache": true,
                    "bProcessing": true,
                    "bServerSide": true,
                    "bDestroy": true,
                    "order": [[1, "desc"]],
                    "ajax": "<?php echo e(URL::route("admin.leavetypes.ajax_list")); ?>",
                    "aoColumns": [
                        { 'sClass': 'center', "bSortable": true  },
                        { 'sClass': 'center', "bSortable": true },
                        { 'sClass': 'center', "bSortable": true },
                        { 'sClass': 'center', "bSortable": false }
                    ],
                    "lengthMenu": [
                        [5, 15, 20, -1],
                        [5, 15, 20, "All"] // change per page values here
                    ],
                    "sPaginationType": "full_numbers",
                    "fnRowCallback": function( nRow, aData, iDisplayIndex ) {
                        var row = $(nRow);
                        row.attr("id", 'row'+aData['0']);
                    }

                });

        // Show Delete Modal
        function del(id,name) {

            $('#deleteModal').modal('show');

            $("#deleteModal").find('#info').html('Are you sure ! You want to delete <strong>'+name+'</strong> ?');

            $('#deleteModal').find("#delete").off().click(function () {

                var url = "<?php echo e(route('admin.leavetypes.destroy',':id')); ?>";
                url = url.replace(':id',id);

                var token = "<?php echo e(csrf_token()); ?>";

                $.easyAjax({
                    type: 'DELETE',
                    url: url,
                    data: {'_token': token},
                    container: "#deleteModal",
                    success: function (response) {
                        if (response.status == "success") {
                            $('#deleteModal').modal('hide');
							table.fnDraw();
                        }
                    }
                });

            });
        }
        // Show Create Department Modal
        function showEdit(id,leaveType,num) {
            var url = "<?php echo e(route('admin.leavetypes.edit',':id')); ?>";
            url = url.replace(':id',id);
             $.ajaxModal('#showModal', url);

        $("#edit_leaveType").val(leaveType);
        $("#edit_num_of_leave").val(num);
        }

        // Show Create Department Modal
        function showAdd() {
            var url = "<?php echo e(route('admin.leavetypes.create')); ?>";
             $.ajaxModal('#showModal', url);

        }
        // Javascript function to update the company info and Bank Info
        function addUpdateLeaveType(id){

            if(typeof id!='undefined') {
                var url = "<?php echo e(route('admin.leavetypes.update',':id')); ?>";
                url = url.replace(':id',id);
            } else {
                url ="<?php echo e(route('admin.leavetypes.store')); ?>";
            }
            $.easyAjax({
                type: 'POST',
                url: url,
                container: '#leave_type_update_form',
                data: $('#leave_type_update_form').serialize(),
                success: function () {
                    $('#showModal').modal('hide');
                    table.fnDraw();
                }
            });
        }

</script>
<?php $__env->stopSection(); ?>
	
<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\hrm1\resources\views/admin/leavetypes/index.blade.php ENDPATH**/ ?>