<?php $__env->startSection('head'); ?>
	<!-- BEGIN PAGE LEVEL STYLES -->
	<?php echo HTML::style("assets/global/plugins/select2/select2.css"); ?>

	<?php echo HTML::style("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css"); ?>

	<!-- END PAGE LEVEL STYLES -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


			<!-- BEGIN PAGE HEADER-->
			<h3 class="page-title">
			<?php echo e($pageTitle); ?>

			</h3>
			<div class="page-bar">
				<ul class="page-breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a>
						<i class="fa fa-angle-right"></i>
					</li>

					<li>
                        <a href="#">Departments and Designations</a>
                        <i class="fa"></i>
                    </li>

				</ul>

			</div>
			<!-- END PAGE HEADER-->

			  <div id="load">
                        
                               <?php echo $__env->make('admin.common.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                       
                        </div>

			<!-- BEGIN PAGE CONTENT-->
			<div class="row">
				<div class="col-md-12">
					<!-- BEGIN EXAMPLE TABLE PORTLET-->


				<a class="btn green" onclick="showAdd();">
                                        Add New Department
                         <i class="fa fa-plus"></i> </a>

                     <hr>
					<div class="portlet box blue">
						<div class="portlet-title">
							<div class="caption">
								<i class="fa fa-briefcase"></i>Department List
							</div>
							<div class="tools">
							</div>
						</div>

						<div class="portlet-body">

							<table class="table table-striped table-bordered table-hover" id="departmentTable">
							<thead>
							<tr>
								<th>
									 ID
								</th>
								<th>
									 Department Name
								</th>
								<th>
									 Designations
								</th>
                                <th>
									 Designations
								</th>

								<th>
									 Action
								</th>
							</tr>
							</thead>
							<tbody>
							</tbody>
							</table>
						</div>
					</div>
					<!-- END EXAMPLE TABLE PORTLET-->

				</div>
			</div>
			<!-- END PAGE CONTENT-->

        

             			<div id="static" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                                <h4 class="modal-title"><strong><i class="fa fa-plus"></i> New Department</strong></h4>
                                            </div>
                                            <div class="modal-body">
                                                <div class="portlet-body form">

                                                                    						<!-- BEGIN FORM-->

                                         <!-- END FORM-->
                                     </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                </div>
            </div>

  

			
            <?php echo $__env->make('admin.include.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('include.show-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
<?php $__env->stopSection(); ?>



<?php $__env->startSection('footerjs'); ?>
    <?php echo HTML::script("assets/global/plugins/datatables/media/js/jquery.dataTables.min.js"); ?>

    <?php echo HTML::script("assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"); ?>

<script>
    var table = $('#departmentTable');
    // For Add more destination field for edit
    var $dj = 0;
    function addEditDestination(){
        $dj = $dj+1;
        $('#editDestinationDiv').append(' <div class="form-group" id="edit_field"> <div class="col-md-12"><input class="form-control form-control-inline input-medium"  name="designation['+$dj+']" type="text"  placeholder="Designation #'+($dj+1)+'"/></div></div>');
    }
    // For Add more destination field for add
    var $di = 0;
    function addDestinations(){
        $di = $di+1;
        $('#AddedDestinations').append(' <div class="form-group"> <div class="col-md-12"><input class="form-control form-control-inline input-medium"  name="designation['+$di+']" type="text"  placeholder="Designation #'+($di+1)+'"/></div></div>');
    }

    var tableData = table.dataTable({
                    "cache": true,
                    "bProcessing": true,
                    "bServerSide": true,
                    "bDestroy":true,
                    "order": [[0, "desc"]],
                    "fnDrawCallback": function () {
                        Metronic.init();
                    },
                    "ajax": "<?php echo e(route("admin.departments.ajax_department")); ?>",
                    "aoColumns": [
                        {'sClass': 'center', 'bSortable': true},
                        {'sClass': 'center', 'bSortable': false},
                        {'sClass': 'center', 'bSortable': false,"visible": false},
                        {'sClass': 'center', 'bSortable': false},
                        {'sClass': 'center', 'bSortable': false},
                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex ) {
                            var row = $(nRow);
                            row.attr("id", 'row'+aData['0']);
                    },

                    "sPaginationType": "full_numbers",
                    "language": {
                        "emptyTable": "No data available"
                    },
                    "fnInitComplete": function(oSettings, json) {
                        Metronic.init();
                    },
                });


    // Show Delete Modal
    function del(id,dept) {

        $('#deleteModal').modal('show');

        $("#deleteModal").find('#info').html('Are you sure ! You want to delete <strong>'+dept+'</strong> department?<br>' +
                '<br><div class="note note-warning">' +
                '<?php echo Lang::get('messages.deleteNoteDepartment'); ?>'+
                '</div>');

        $('#deleteModal').find("#delete").off().click(function () {

            var url = "<?php echo e(route('admin.departments.destroy',':id')); ?>";
            url = url.replace(':id',id);

            var token = "<?php echo e(csrf_token()); ?>";

            $.easyAjax({
                type: 'DELETE',
                url: url,
                data: {'_token': token},
                container: "#deleteModal",
                success: function (response) {
                    if (response.status == "success") {
                        $('#deleteModal').modal('hide');
                        tableData.fnDraw();
                    }
                }
            });

        });
    }
    // Javascript function to update the company info and Bank Info
    function UpdateDepartments(id){

        var url = "<?php echo e(route('admin.departments.update',':id')); ?>";
        url = url.replace(':id',id);
        $.easyAjax({
            type: 'POST',
            url: url,
            container: '#edit_department_form',
            data: $('#edit_department_form').serialize(),
            success: function () {
                $('#showModal').modal('hide');
                tableData.fnDraw();
            }
        });
    }
    // Javascript function to update the company info and Bank Info
    function storeDepartments(){

        var url = "<?php echo e(route('admin.departments.store')); ?>";
        $.easyAjax({
            type: 'POST',
            url: url,
            container: '#add_department_form',
            data: $('#add_department_form').serialize(),
            success: function () {
                $('#showModal').modal('hide');
                tableData.fnDraw();
            }
        });
    }

    // Show Create Department Modal
    function showAdd() {
        var url = "<?php echo e(route('admin.departments.create')); ?>";
        $.ajaxModal('#showModal', url);
    }
    // Show Edit Depart Modal
    function showEdit(id) {
        var url = "<?php echo e(route('admin.departments.edit',[':id'])); ?>";
        url = url.replace(':id', id);
        $.ajaxModal('#showModal', url);
    }

</script>
<?php $__env->stopSection(); ?>
	
<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\hrm\resources\views/admin/departments/index.blade.php ENDPATH**/ ?>