<?php
namespace App\Http\Requests\Admin\Employee;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class CreateRequest
 * @package App\Http\Requests\Admin\Employee
 */
class CreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    public function authorize()
    {
        // If admin
        return admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'employeeID'    => 'required|unique:employees,employeeID|alpha_dash',
            'fullName'      => 'required',
            'email'         => 'nullable|email|unique:employees',
            'password'      => 'nullable',
            'profileImage'  => 'nullable|file|mimes:jpeg,jpg,png,bmp,gif,svg|max:9000',
            'resume'        => 'max:4000',
            'offerLetter'   => 'max:4000',
            'joiningLetter' => 'max:4000',
            'contract'      => 'max:4000',
            'IDProof'       => 'max:4000',
        ];
    }

    public function messages()
    {
        return [
            'employeeID.required' => 'Employee ID is required'
        ];
    }
}
