<?php 
include('menu_cashier.php');
include_once 'model/quotations_model.php';

$quotations_model = new quotations_model();
$active_quotations = $quotations_model->fetchActiveQuotations($employee_code, $location);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Active Quotations</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">


    <style>
        body {
            background: #eef1f4;
        }

        .card-modern {
            background: #fff;
            border-radius: 6px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            margin-bottom: 20px;
        }

        .table thead th {
            background-color: #3c8dbc;
            color: #fff;
            font-weight: 500;
        }

        .table tbody tr:hover {
            background-color: #eef7ff;
        }

        .action-btns .btn {
            margin-right: 5px;
        }

        .search-bar {
            max-width: 300px;
        }
        
        #quotationsTable td, 
        #quotationsTable th {
            vertical-align: middle;
        }
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <!-- Header + Search -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-primary"><i class="fa fa-file-alt"></i> Active Quotations</h3>
        <input type="text" id="filter_global" class="form-control search-bar" placeholder="Search quotations...">
    </div>

    <!-- Quotations Table -->
    <div class="card-modern">
        <div class="table-responsive">
            <table class="table table-hover" id="quotationsTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Quote Number</th>
                        <th>Customer</th>
                        <th>Date</th>
                        <th>Valid Until</th>
                        <th>Total Amount</th>
                        <th>Status</th>
                        <th style="text-align: center;width:200px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($active_quotations)): ?>
                        <?php foreach($active_quotations as $index => $q): ?>
                            <tr>
                                <?php
                                    if($q['quotation_state'] == 1 || $q['quotation_state'] ==0) {
                                        $bg_class = 'bg-success';
                                    }else{
                                        $bg_class = 'bg-secondary';
                                    }
                                ?>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($q['quote_number']) ?></td>
                                <td><?= htmlspecialchars($q['customer_name']) ?></td>
                                <td><?= date('d M, Y', strtotime($q['transaction_date'])) ?></td>
                                <td><?= date('d M, Y', strtotime($q['expiry_date'])) ?></td>
                                <td class="text-right"><?= number_format($q['total'], 2) ?></td>
                                <td class="<?= $bg_class ?>"><?= $q['quotation_status'] ?></td>
                                <td class="action-btns text-center" >
                                    <a href="customer_quote.php?quote_number=<?= $q['quote_number'] ?>" class="btn btn-info" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <button 
                                        type="button"
                                        class="btn btn-sm btn-primary edit-quote"
                                        data-quote="<?= $q['quote_number'] ?>">
                                        Edit
                                    </button>

                                    <a href="#" onclick="printQuotation('<?=  $q['quote_number'] ?>')" class="btn btn-success" title="Print">
                                        <i class="fa fa-print"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted">No active quotations found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<div class="modal fade" id="editQuotationModal">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Edit Quotation</h5>
                <button class="close" data-dismiss="modal">&times;</button>
            </div>

            <form id="editQuotationForm">
                <div class="modal-body">
                    <input type="hidden" name="quote_number" id="edit_quote_number">

                    <table class="table table-bordered" id="editQuotationTable">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th width="120">Price</th>
                                <th width="100">Qty</th>
                                <th width="120">Total</th>
                                <th width="60"></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                    <div class="form-inline mb-2">
    <select id="modalProductSelect" class="form-control mr-2">
        <option value="">Select Product</option>
    </select>
    <input type="number" id="modalProductQty" class="form-control mr-2" value="1" min="1" placeholder="Qty">
    <button type="button" id="addRow" class="btn btn-secondary">+ Add Product</button>
</div>


                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">
                        Save Changes
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>


<!-- JS Scripts -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<script>
    // Global search filter
    $("#filter_global").on("keyup", function(){
        let value = $(this).val().toLowerCase();
        $("#quotationsTable tbody tr").filter(function(){
            $(this).toggle($(this).text().toLowerCase().includes(value));
        });
    });

    $(document).on('click', '.edit-quote', function () {
    const quote = $(this).data('quote');

    $.post('controllers/quotations_controller.php', {
        action: 'get_quotation',
        quote_number: quote
        }, function (res) {
            // Ensure res.header and res.items exist
            if(res.header && res.items){
                $('#edit_quote_number').val(res.header.quote_number);

                const tbody = $('#editQuotationTable tbody');
                tbody.empty();

                if(res.items.length){
                    res.items.forEach(item => {
                        tbody.append(renderRow(item));
                    });
                } else {
                    tbody.append('<tr><td colspan="5" class="text-center">No items found</td></tr>');
                }

                $('#editQuotationModal').modal('show');
            } else {
                alert('Failed to fetch quotation items.');
            }
        }, 'json');
    });


function renderRow(item) {
    const total = parseFloat(item.total) || 0; // ensures it's a number

    return `
        <tr>
            <td>
                <input type="hidden" name="items[${item.product_id}][product_id]" value="${item.product_id}">
                ${item.product_name}
            </td>
            <td>
                <input type="number" name="items[${item.product_id}][price]"
                    class="form-control price"
                    value="${item.price}" readonly>
            </td>
            <td>
                <input type="number" name="items[${item.product_id}][quantity]"
                    class="form-control qty"
                    value="${item.quantity}">
            </td>
            <td class="line-total text-right">
                ${total.toFixed(2)}
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm remove-row">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>`;
}

$(document).on('click', '.remove-row', function(){
    const row = $(this).closest('tr');
    const productId = row.find('input[name*="[product_id]"]').val();
    const quoteNumber = $('#edit_quote_number').val();

    Swal.fire({
        title: 'Are you sure?',
        text: "This will remove the item from the quotation.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes, delete',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if(result.isConfirmed){
            // Delete item via AJAX
            $.post('controllers/quotations_controller.php', {
                action: 'delete_item',
                quote_number: quoteNumber,
                product_id: productId
            }, function(res){
                if(res.success){
                    row.remove();
                    updateTotals();
                    Swal.fire('Deleted!', 'Item removed successfully.', 'success');
                } else {
                    Swal.fire('Error!', res.message || 'Failed to delete.', 'error');
                }
            }, 'json');
        }
    });
});

$('#editQuotationForm').submit(function (e) {
    e.preventDefault();

    const formData = $(this).serialize(); // serializes all items and quote_number

    $.post('controllers/quotations_controller.php', {
        action: 'update_quotation',
        data: formData
    }, function(res){
        if(res.success){
            Swal.fire('Saved!', 'Quotation has been updated.', 'success')
                .then(() => location.reload());
        } else {
            Swal.fire('Error!', res.message || 'Could not save quotation.', 'error');
        }
    }, 'json');
});


// Fetch products for modal
function loadProducts() {
    const location = '<?= $location ?>'; // get location from PHP variable
    $.post('controllers/quotations_controller.php', 
        { 
            action: 'get_products',
            location: location
        }, 
        function(res){
            const select = $('#modalProductSelect');
            select.empty().append('<option value="">Select Product</option>');
            res.forEach(p => {
                select.append(`<option value="${p.product_id}" data-price="${p.selling_price}">${p.product_name} (${parseFloat(p.selling_price).toFixed(2)})</option>`);
            });
        }, 'json'
    );
}


// Call on modal show
$('#editQuotationModal').on('show.bs.modal', loadProducts);

// Add selected product to table
$('#addRow').click(function(){
    const select = $('#modalProductSelect');
    const productId = select.val();
    const productName = select.find('option:selected').text();
    const price = parseFloat(select.find('option:selected').data('price')) || 0;
    const qty = parseFloat($('#modalProductQty').val()) || 1;

    if(!productId){
        alert('Select a product first');
        return;
    }

    const tbody = $('#editQuotationTable tbody');

    // Prevent duplicate rows
    if(tbody.find(`input[value="${productId}"]`).length){
        alert('Product already added');
        return;
    }

    const lineTotal = price * qty;

    const row = `
        <tr>
            <td>
                <input type="hidden" name="items[${productId}][product_id]" value="${productId}">
                ${productName}
            </td>
            <td>
                <input type="number" name="items[${productId}][price]" class="form-control price" value="${price}" readonly>
            </td>
            <td>
                <input type="number" name="items[${productId}][quantity]" class="form-control qty" value="${qty}" min="1">
            </td>
            <td class="line-total text-right">${lineTotal.toFixed(2)}</td>
            <td>
                <button type="button" class="btn btn-danger btn-sm remove-row">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>`;
    tbody.append(row);
    updateTotals();
});


function updateTotals() {
    let total = 0;
    $('#editQuotationTable tbody tr').each(function(){
        const price = parseFloat($(this).find('.price').val()) || 0;
        const qty = parseFloat($(this).find('.qty').val()) || 0;
        const lineTotal = price * qty;
        $(this).find('.line-total').text(lineTotal.toFixed(2));
        total += lineTotal;
    });
    // Show total in modal or console
    console.log('Grand total:', total.toFixed(2));
}

// Trigger on quantity change
$(document).on('input', '.qty', function(){
    updateTotals();
});



</script>

<script>
$(document).on('click', '.edit-quote', function () {
    $('#editQuotationModal').modal('show');
});
</script>


</body>
</html>
