<?php 
include('menu_cashier.php');
include_once 'model/sales_model.php';
include_once 'model/branch_model.php';

$sales_model = new sales_model();
$branch_model = new branch_model();

if(isset($_GET['from_date']) && isset($_GET['to_date'])) {
    $start_date = $_GET['from_date'];
    $end_date = $_GET['to_date'];
} else {
    $start_date = date('Y-m-01');
    $end_date = date('Y-m-d');
}

$payments = $sales_model->getCashPayments($location, $start_date, $end_date);
$branchDetails = $branch_model->getBranchDetails($location);

/* Calculate Total Cash */
$total_cash = 0;
foreach($payments as $pay){
    $total_cash += $pay['amount_paid'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Cash Payments</title>

<link rel="stylesheet" href="../includes/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="../includes/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">

<style>
.card-summary {
    border-left: 5px solid #28a745;
    background: #f8f9fa;
}
.total-amount {
    font-size: 1.5rem;
    font-weight: bold;
    color: #28a745;
}
.table thead th {
    background-color: #343a40;
    color: white;
}
.filter-card {
    background: #ffffff;
    border-radius: 8px;
}
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <!-- PAGE TITLE -->
    <!-- HEADER + CONTROLS (Single Row) -->
<div class="card shadow-sm mb-3 p-3">

    <div class="d-flex flex-wrap align-items-end justify-content-between">

        <!-- LEFT: Title -->
        <div class="mb-2">
            <h4 class="mb-0">
                Cash Payments Report
                <small class="text-muted">
                    - <?= htmlspecialchars($branchDetails['branch_name'] ?? "") ?>
                </small>
            </h4>
        </div>

        <!-- CENTER: Date Filter -->
        <form method="GET" class="form-inline mb-2">
            <div class="form-group mr-2">
                <label class="mr-2 mb-0">From</label>
                <input type="date" name="from_date" class="form-control"
                       value="<?= $start_date ?>">
            </div>

            <div class="form-group mr-2">
                <label class="mr-2 mb-0">To</label>
                <input type="date" name="to_date" class="form-control"
                       value="<?= $end_date ?>">
            </div>

            <button type="submit" class="btn btn-primary mr-3">
                Filter
            </button>
        </form>

        <!-- RIGHT: Total + Export -->
        <div class="d-flex align-items-center">

            <!-- TOTAL -->
            <div class="mr-4 text-right">
                <small class="text-muted d-block">Total Cash</small>
                <strong class="text-success" style="font-size:18px;">
                    MWK <?= number_format($total_cash,2) ?>
                </strong>
            </div>

            <!-- EXPORT -->
            <form method="POST" action="export_cash_payments.php" class="mb-0">
                <input type="hidden" name="from_date" value="<?= $start_date ?>">
                <input type="hidden" name="to_date" value="<?= $end_date ?>">
                <input type="hidden" name="location" value="<?= htmlspecialchars($location) ?>">
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-file-excel"></i> Excel
                </button>
            </form>

        </div>

    </div>
</div>

    <!-- TABLE -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped" id="cashPaymentsTable">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Sale / Invoice No</th>
                        <th>Receipt No</th>
                        <th>Transaction Type</th>
                        <th>Customer</th>
                        <th class="text-right">Amount Paid</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!empty($payments)): ?>
                        <?php foreach($payments as $pay): ?>
                        <tr>
                            <td><?= date('d M Y H:i', strtotime($pay['payment_date'])) ?></td>
                            <td><?= htmlspecialchars($pay['sale_id']) ?></td>
                            <td><?= htmlspecialchars($pay['receipt_number']) ?></td>
                            <td><?= htmlspecialchars($pay['transaction_type']) ?></td>
                            <td><?= htmlspecialchars($pay['customer_name']) ?></td>
                            <td class="text-right text-success font-weight-bold">
                                <?= number_format($pay['amount_paid'],2) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">
                                No cash payments found for selected period.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>

                <!-- Footer Total -->
                <tfoot>
                    <tr>
                        <th colspan="5" class="text-right">TOTAL:</th>
                        <th class="text-right text-success">
                            MWK <?= number_format($total_cash,2) ?>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

</div>

<!-- SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
$(document).ready(function () {
    $('#cashPaymentsTable').DataTable({
        pageLength: 25,
        lengthChange: true,
        ordering: true,
        order: [[0, 'desc']],
        responsive: true,
        autoWidth: false
    });
});
</script>

</body>
</html>