<?php
    include 'menu_cashier.php';
    include_once 'model/sales_model.php'; 
    include_once 'model/common_model.php';

    $common_model = new common_model();
    $sales_model = new sales_model();

    $company_details = $common_model->getCompanyDetails();
    $transaction_id = isset($_GET['id']) ? $_GET['id'] : '';

    $items = $sales_model->getInvoiceItems($transaction_id);

    $cashSaleDetails = $sales_model->getCashSaleData($transaction_id);
    $receiptDetails = $sales_model->getReceiptData($transaction_id);
    $payments = $sales_model->getCashSalePayments($transaction_id);

    
    $state = $cashSaleDetails['payment_state'];

?>

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <title>Powertex || Cash Sale Receipt</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" type="image/png" href="../finance/images/favicon.png">

            <style>
                .delivery-note { font-size: 14px; font-family: "Times New Roman", serif; }
                .delivery-note p { font-size: 16px; }
                .delivery-note h6 { font-size: 14px; }

                .office-title {
                    font-size: 20px;
                    font-weight: bold;
                    text-decoration: underline;
                    margin-bottom: 2px;
                }

                .office-text { font-size: 14px; line-height: 1.15; }
                .office-block { padding: 0 5px; }

                .dn-title { font-size: 22px; font-weight: bold; }

                .delivery-note th,
                .delivery-note td { font-size: 16px; padding: 5px !important; }

                .table td, .table th { border-bottom: 1px solid #000; }

                .delivery-logo { max-height: 70px; margin: 5px auto; display: block; }

                .watermark {
                    position: absolute;
                    top: 50%;
                    left: 55%;
                    transform: translate(-50%, -50%) rotate(-30deg);
                    font-size: 100px;
                    font-weight: bold;
                    color: inherit;
                    opacity: 0.55;
                    white-space: nowrap;
                    pointer-events: none;
                    z-index: 0;
                }

                @media print {

                    body {
                        background: #fff !important;
                        margin: 0 !important;
                        padding: 0 !important;
                        font-size: 12pt;
                    }

                    body * {
                        visibility: hidden;
                    }

                    #printableArea, #printableArea * {
                        visibility: visible;
                    }

                    #printableArea {
                        position: absolute;
                        left: 0;
                        top: 0;
                        width: 100%;
                        padding: 0;
                        margin: 0;
                    }

                    /* Remove AdminLTE / Bootstrap visual noise */
                    .card,
                    .card-body,
                    .content-wrapper,
                    .container-fluid {
                        box-shadow: none !important;
                        border: none !important;
                        padding: 0 !important;
                        margin: 0 !important;
                        background: #fff !important;
                    }

                    /* Table print clarity */
                    table {
                        width: 100% !important;
                        border-collapse: collapse !important;
                    }

                    th, td {
                        border: 1px solid #000 !important;
                        padding: 6px !important;
                        font-size: 11pt !important;
                    }

                    /* Force rows not to split across pages */
                    tr {
                        page-break-inside: avoid !important;
                    }

                    /* Hide all buttons & modals */
                    button,
                    .modal,
                    .btn,
                    .card-header {
                        display: none !important;
                    }

                    /* Watermark positioning fix */
                    .watermark {
                        position: fixed !important;
                        top: 45% !important;
                        left: 50% !important;
                        transform: translate(-50%, -50%) rotate(-30deg) !important;
                        font-size: 90px !important;
                        opacity: 0.18 !important;
                        z-index: 999 !important;
                    }
                }

            </style>
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">
            <div class="content-wrapper p-4">
                <section class="content">
                    <div class="container-fluid">
                        <div class="mb-4">
                            <div class="card shadow-sm">
                                <div class="card-body d-flex align-items-center">

                                    <!-- LEFT: TITLE ONLY -->
                                    <h4 class="mb-0" style="font-weight:bold;">
                                        Cash Sale Receipt#<?= htmlspecialchars($transaction_id) ?>
                                    </h4>

                                    <!-- RIGHT: ALL ACTION BUTTONS INCLUDING BACK -->
                                    <div class="d-flex align-items-center ml-auto">  <!-- ✨ THIS IS THE FIX -->

                                        <?php
                                            if($cashSaleDetails['payment_state'] == 1):
                                                ?>
                                                
                                                <button 
                                                    class="btn btn-success mr-2 send-doc"
                                                    data-channel="whatsapp"
                                                    data-doc-type='cash_sale'
                                                    data-reference="<?= $transaction_id ?>  "
                                                    title="Send via WhatsApp">
                                                    <i class="fab fa-whatsapp"></i>
                                                </button>

                                                <!-- Send Email -->
                                                <button 
                                                    class="btn btn-danger mr-2 send-doc"
                                                    data-channel="email"
                                                    data-doc-type='cash_sale'
                                                    data-reference="<?= $transaction_id ?>"
                                                    title="Send via Email">
                                                    <i class="fas fa-envelope"></i>
                                                </button>


                                        <?php 
                                                endif;
                                        ?>

                                        <!-- PRINT BUTTON -->
                                        <button class="btn btn-primary mr-2" onclick="window.print()">
                                            <i class="fa fa-print"></i>
                                        </button>

                                        <!-- BACK BUTTON (NOW ON FAR RIGHT) -->
                                        <button class="btn btn-info" onclick="history.back()">
                                            <i class="fa fa-arrow-left ml-1"></i>
                                        </button>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <div id="printableArea">

                            <?php
                                // -------------------------------------------------------
                                // STATUS AND WATERMARK LOGIC
                                // -------------------------------------------------------
                                // FIXED — now defined early

                                $statusMap = [
                                    0 => ['label' => 'Declined',  'badge' => 'badge-danger'],
                                    1 => ['label' => 'Pending',   'badge' => 'badge-warning'],
                                    2 => ['label' => 'Received',  'badge' => 'badge-success'],
                                    3 => ['label' => 'Cancelled', 'badge' => 'badge-secondary']
                                ];

                                $watermarkText = [
                                    3 => "Cancelled Invoice",
                                ];

                                $watermarkColors = [
                                    0 => 'rgba(255, 0, 0, 0.35)',      // Strong Red
                                    1 => 'rgba(255, 205, 0, 0.40)',    // Strong Yellow
                                    2 => 'rgba(0, 230, 118, 0.35)',    // Strong Green
                                    3 => 'rgba(90, 100, 110, 0.40)'    // Strong Grey
                                ];


                                $wmText  = $watermarkText[$state] ?? '';
                                $wmColor = $watermarkColors[$state];
                            ?>

                            <?php if ($wmText != ''): ?>
                                <div class="watermark" style="color: <?= $wmColor ?>;">
                                    <?= $wmText ?>
                                </div>
                            <?php endif; ?>


                            <div class="container delivery-note" style="max-width: 960px; background:#fff; padding:25px; border:1px solid #000;">

                                <?php 
                                    $docTitle  = "Cash Sale";
                                    $docNumber = $transaction_id;
                                    include('print_header.php'); 
                                ?>

                                <hr>

                                <div style="font-family: Arial; font-size: 12pt; margin-bottom: 15px;">

                                    <div style="display:flex; justify-content:space-between; align-items:center;">
                                        <strong><?= htmlspecialchars($cashSaleDetails['customer_name']) ?></strong>
                                    </div>

                                    <hr style="border:1px solid #000; margin:5px 0;">

                                    <div style="text-align:right;">
                                        <span style="text-decoration:underline;">
                                            <strong>Date:</strong> <?= date('d F Y', strtotime($cashSaleDetails['cash_sale_date'])) ?>
                                        </span>
                                    </div>

                                </div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th style="width:20%">Quantity</th>
                                            <th style="width:25%">@</th>
                                            <th style="width:15%">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                            foreach ($items as $item): 
                                        ?>
                                                <tr>
                                                    <td><?= htmlspecialchars($item['product_name']) ?></td>
                                                    <td><?= htmlspecialchars($item['categoryname']) ?></td>
                                                    <td  style="text-align: center;"><?= htmlspecialchars($item['qty']) ?></td>
                                                    <td style="text-align:right;"><?= number_format($item['selling_price'],2) ?></td>
                                                    <td style="text-align:right;"><?= number_format($item['subtotal'],2) ?></td>
                                                </tr>
                                            <?php endforeach; ?>

                                            <?php for ($i = count($items); $i < 6; $i++): ?>
                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                            <?php endfor; ?>

                                            <!-- ✔ Totals + Customer Block -->
                                        <tr>
                                            <td colspan="3" rowspan="5" style="vertical-align: top;"><strong>Payment Breakdown:</strong><br>
                                                <?php
                                                $totalPaid = 0;
                                                foreach ($payments as $pay):
                                                    $totalPaid += $pay['amount_paid'];
                                                ?>
                                                <?= htmlspecialchars($pay['payment_method']) ?>
                                                — <?= number_format($pay['amount_paid'], 2) ?><br>
                                                <?php endforeach; ?>

                                                <hr style="margin:5px 0;">

                                                <strong>Total Paid:</strong> <?= number_format($totalPaid, 2) ?><br>
                                                <u><strong>Customer Tel:</strong> <?= htmlspecialchars($cashSaleDetails['customer_phone']) ?></u><br>
                                            </td>

                                            <td><strong>Subtotal</strong></td>
                                            <td style="text-align:right;"><?= number_format($cashSaleDetails['subtotal'], 2) ?></td>
                                        </tr>

                                            <?php if ($cashSaleDetails['total_tax'] > 0): ?>
                                                <tr>
                                                    <td><strong>Plus VAT</strong></td>
                                                    <td style="text-align:right;"><?= number_format($cashSaleDetails['total_tax'], 2) ?></td>
                                                </tr>
                                            <?php endif; ?>
                                            
                                        <?php if ($cashSaleDetails['discount'] > 0): ?>
                                        <tr>
                                            <td><strong>Total</strong></td>
                                            <td style="text-align:right; font-weight:bold;"><?= number_format($cashSaleDetails['total_b4_discount'], 2) ?></td>
                                        </tr>

                                        
                                            <tr>
                                                <td><strong>Applied Discount</strong></td>
                                                <td style="text-align:right;"><?= number_format($cashSaleDetails['discount'], 2) ?></td>
                                            </tr>
                                        <?php endif; ?>

                                        <tr>
                                            <td><strong>Grand Total</strong></td>
                                            <td style="text-align:right; font-weight:bold;"><?= number_format($cashSaleDetails['total'], 2) ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div> <!-- /printableArea -->
                    </div>
                </section>
            </div>

            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/dist/js/adminlte.js"></script>
            <script>
                function dispatchDocument(docType, transactionId, channel) {
                    if (!docType || !transactionId || !channel) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Invalid Request',
                            text: 'Missing document dispatch parameters'
                        });
                        return;
                    }

                    $.post(
                        'controllers/document_dispatch_controller.php',
                        {
                            doc_type: docType,
                            transaction_id: transactionId,
                            channel: channel
                        },
                        function (response) {

                            if (response.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success',
                                    text: response.message
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.message || 'An unexpected error occurred'
                                });
                            }

                        },
                        'json'
                    ).fail(function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Request Failed',
                            text: 'Unable to dispatch document. Please try again.'
                        });
                    });
                }
            </script>
            <script>
            $(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');     // whatsapp | email
    const docType   = $(this).data('doc-type');    // cash_sale | invoice | quotation
    const reference = $(this).data('reference');

    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}
            </script>
        </body>
    </html>