<?php
session_start();
include_once '../model/banking_model.php';
$banking_model = new banking_model();

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];

    switch ($action) {
        case 'fetch_expense':
            fetchExpenseDetails($banking_model);
            break;

        case 'update_expense':
            updateExpenseDetails($banking_model);
            break;
        
        case 'delete_expense':
            deleteExpense($banking_model);
            break;

        default:
            echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    }
}

function deleteExpense($banking_model){

    if(!isset($_POST['id'])){
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid request.'
        ]);
        exit;
    }

    $id = intval($_POST['id']);

    $deleted = $banking_model->deleteExpense($id);

    if($deleted){
        echo json_encode([
            'status' => 'success'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Delete failed or not allowed.'
        ]);
    }

    exit;
}


function updateExpenseDetails($banking_model) {

    $id = intval($_POST['id']);
     $reference_number = trim($_POST['reference_number'] ?? '');
    if ($reference_number === '') {
        $reference_number = null; // Ensure NULL if nothing selected
    }
    $expense_date = $_POST['expense_date'];
    $amount_paid = $_POST['amount_paid'];
    $description = $_POST['expense_description'];
    
    $result = $banking_model->updateExpense($id, $reference_number, $expense_date, $amount_paid, $description);

    if ($result) {
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'SUCCESS',
            'message' => "Expense updated successfully!"
        ];
        header("Location: ../expenses_list.php");
        exit();
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'ERROR',
            'message' => "Failed to update expense. Please try again."
        ];
        header("Location: ../expenses_list.php");
        exit();
    }
}

function fetchExpenseDetails($banking_model) {

    $id = intval($_POST['id']);
    $location = $_POST['location'];
    $expense = $banking_model->getExpenseDetails($id);
    $cancelledPayments = $banking_model->getCancelledPayments($location);

    echo json_encode([
        'expense' => $expense,
        'cancelled_payments' => $cancelledPayments
    ]);
}