<?php
    session_start();
    include_once '../model/common_model.php';
    include_once '../model/setup_model.php';

    $setup_model = new setup_model();
    $common_model = new common_model();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $action = $_POST['action'] ?? '';

        switch ($action) {

            case 'mark_as_read':
                MarkAsRead($common_model);
                break;
            
            case 'update_display_setting':
                updateDisplaySettings($setup_model);
                break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Setup Failed',
                    'message' => 'Unrecognised action requested.'
                ];
                header("Location: ../dashboard.php");
                exit();
        }
    }

    function MarkAsRead($common_model){
        $id = $_POST['notification_id'];
        $action = $common_model->markAsRead($id);
    }

    function updateDisplaySettings($setup_model){
        $column = $_POST['column'];
        $value  = (int) $_POST['value'];
        $username = $_SESSION['sess_username'];

        // whitelist allowed columns (VERY important)
        $allowedColumns = [
            'sales_display',
            'payments_display'
        ];

        if (!in_array($column, $allowedColumns)) {
            echo json_encode(['success' => false, 'message' => 'Invalid column']);
            exit;
        }

        $setup_model->updateDisplaySettings($username, $column, $value);

        echo json_encode(['success' => true]);
        exit;
    }
