<?php
    include 'menu_cashier.php';
    include_once 'model/sales_model.php'; 
    include_once 'model/common_model.php';

    $common_model = new common_model();
    $sales_model = new sales_model();

    $company_details = $common_model->getCompanyDetails();
    $transaction_id = isset($_GET['dn_number']) ? $_GET['dn_number'] : '';

    // Fetch delivery note details
    $deliveryNoteDetails = $sales_model->getDeliveryNoteDetails($transaction_id);    
    $state = $deliveryNoteDetails['dn_state'];

    // Determine which number to use to fetch items
    $sales_number = !empty($deliveryNoteDetails['invoice_number']) ? $deliveryNoteDetails['invoice_number'] : $deliveryNoteDetails['dn_number'];

    // Fetch items dynamically
    $items = $sales_model->getInvoiceItems($sales_number);
?>


<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <title>Powertex || Customer Delivery Note</title>
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" type="image/png" href="../finance/images/favicon.png">

            <style>
                .delivery-note { font-size: 14px; font-family: "Times New Roman", serif; }
                .delivery-note p { font-size: 16px; }
                .delivery-note h6 { font-size: 14px; }

                .office-title {
                    font-size: 20px;
                    font-weight: bold;
                    text-decoration: underline;
                    margin-bottom: 2px;
                }

                .office-text { font-size: 14px; line-height: 1.15; }
                .office-block { padding: 0 5px; }

                .dn-title { font-size: 22px; font-weight: bold; }

                .delivery-note th,
                .delivery-note td { font-size: 16px; padding: 5px !important; }

                .table td, .table th { border-bottom: 1px solid #000; }

                .delivery-logo { max-height: 70px; margin: 5px auto; display: block; }

                .watermark {
                    position: absolute;
                    top: 50%;
                    left: 55%;
                    transform: translate(-50%, -50%) rotate(-30deg);
                    font-size: 75px;
                    font-weight: bold;
                    color: inherit;
                    opacity: 0.55;
                    white-space: nowrap;
                    pointer-events: none;
                    z-index: 0;
                }

                @media print {

                    body {
                        background: #fff !important;
                        margin: 0 !important;
                        padding: 0 !important;
                        font-size: 12pt;
                    }

                    body * {
                        visibility: hidden;
                    }

                    #printableArea, #printableArea * {
                        visibility: visible;
                    }

                    #printableArea {
                        position: absolute;
                        left: 0;
                        top: 0;
                        width: 100%;
                        padding: 0;
                        margin: 0;
                    }

                    /* Remove AdminLTE / Bootstrap visual noise */
                    .card,
                    .card-body,
                    .content-wrapper,
                    .container-fluid {
                        box-shadow: none !important;
                        border: none !important;
                        padding: 0 !important;
                        margin: 0 !important;
                        background: #fff !important;
                    }

                    /* Table print clarity */
                    table {
                        width: 100% !important;
                        border-collapse: collapse !important;
                    }

                    th, td {
                        border: 1px solid #000 !important;
                        padding: 6px !important;
                        font-size: 11pt !important;
                    }

                    /* Force rows not to split across pages */
                    tr {
                        page-break-inside: avoid !important;
                    }

                    /* Hide all buttons & modals */
                    button,
                    .modal,
                    .btn,
                    .card-header {
                        display: none !important;
                    }

                    /* Watermark positioning fix */
                    .watermark {
                        position: fixed !important;
                        top: 45% !important;
                        left: 50% !important;
                        transform: translate(-50%, -50%) rotate(-30deg) !important;
                        font-size: 90px !important;
                        opacity: 0.18 !important;
                        z-index: 999 !important;
                    }
                }

            </style>
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">
            <div class="content-wrapper p-4">
                <section class="content">
                    <div class="container-fluid">
                        <div class="mb-4">
                            <div class="card shadow-sm">
                                <div class="card-body d-flex align-items-center">

                                    <!-- LEFT: TITLE ONLY -->
                                    <h4 class="mb-0" style="font-weight:bold;">
                                        Delivery Note Number #<?= htmlspecialchars($transaction_id) ?>
                                    </h4>

                                    <!-- RIGHT: ALL ACTION BUTTONS INCLUDING BACK -->
                                    <div class="d-flex align-items-center ml-auto">  <!-- ✨ THIS IS THE FIX -->

                                        <?php
                                            if($deliveryNoteDetails['dn_state'] == 1 || $deliveryNoteDetails['dn_state'] == 2):
                                                ?>

                                                <button
                                                    class="btn btn-info mr-2 create-invoice"
                                                    data-reference="<?= $transaction_id ?>"
                                                    title="Create Invoice">
                                                    <i class="fas fa-file-invoice"></i>
                                                </button>
                                                
                                                <button 
                                                    class="btn btn-success mr-2 send-doc"
                                                    data-channel="whatsapp"
                                                    data-doc-type='customer_delivery_note'
                                                    data-reference="<?= $transaction_id ?>  "
                                                    title="Send via WhatsApp">
                                                    <i class="fab fa-whatsapp"></i>
                                                </button>

                                                <!-- Send Email -->
                                                <button 
                                                    class="btn btn-danger mr-2 send-doc"
                                                    data-channel="email"
                                                    data-doc-type='customer_delivery_note'
                                                    data-reference="<?= $transaction_id ?>"
                                                    title="Send via Email">
                                                    <i class="fas fa-envelope"></i>
                                                </button>


                                        <?php 
                                                endif;
                                        ?>

                                        <!-- PRINT BUTTON -->
                                        <button class="btn btn-primary mr-2" onclick="window.print()">
                                            <i class="fa fa-print"></i>
                                        </button>

                                        <!-- BACK BUTTON (NOW ON FAR RIGHT) -->
                                        <button class="btn btn-info" onclick="history.back()">
                                            <i class="fa fa-arrow-left ml-1"></i>
                                        </button>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <div id="printableArea">

                            <?php
                                // -------------------------------------------------------
                                // STATUS AND WATERMARK LOGIC
                                // -------------------------------------------------------
                                // FIXED — now defined early

                                
                                $watermarkText = [
                                    3 => "Cancel Requested",
                                    0 => "Cancelled Delivery Note",
                                    1 => "Waiting Invoice Attachment",
                                ];

                                $watermarkColors = [
                                    0 => 'rgba(255, 0, 0, 0.35)',      // Strong Red
                                    1 => 'rgba(255, 205, 0, 0.40)',    // Strong Yellow
                                    2 => 'rgba(0, 230, 118, 0.35)',    // Strong Green
                                    3 => 'rgba(90, 100, 110, 0.40)'    // Strong Grey
                                ];


                                $wmText  = $watermarkText[$state] ?? '';
                                $wmColor = $watermarkColors[$state];
                            ?>

                            <?php if ($wmText != ''): ?>
                                <div class="watermark" style="color: <?= $wmColor ?>;">
                                    <?= $wmText ?>
                                </div>
                            <?php endif; ?>


                            <div class="container delivery-note" style="max-width: 960px; background:#fff; padding:25px; border:1px solid #000;">

                                <?php 
                                    $docTitle  = "Delivery Note";
                                    $docNumber = $transaction_id;
                                    include('print_header.php'); 
                                ?>

                                <hr>

                                <div style="font-family: Arial; font-size: 12pt; margin-bottom: 15px;">

                                    <div style="display:flex; justify-content:space-between; align-items:center;">
                                        <strong><?= htmlspecialchars($deliveryNoteDetails['customer_name']) ?></strong>
                                    </div>

                                    <hr style="border:1px solid #000; margin:5px 0;">

                                    <div style="text-align:right;">
                                        <span style="text-decoration:underline;">
                                            <strong>Date:</strong> <?= date('d F Y', strtotime($deliveryNoteDetails['dn_date'])) ?>
                                        </span>
                                    </div>

                                </div>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th style="width:20%">Quantity</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php foreach ($items as $item): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($item['product_name']) ?></td>
                                                <td><?= htmlspecialchars($item['categoryname']) ?></td>
                                                <td style="text-align:center;">
                                                    <?= htmlspecialchars($item['qty']) ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>

                                        <?php for ($i = count($items); $i < 6; $i++): ?>
                                            <tr>
                                                <td>&nbsp;</td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        <?php endfor; ?>
                                    </tbody>

                                    <tfoot>
                                        <tr>
                                            <td colspan="2" style="text-align:right; font-weight:bold;">
                                                Total Quantity:
                                            </td>
                                            <td style="text-align:center; font-weight:bold;">
                                                <?= array_sum(array_column($items, 'qty')) ?>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>

                                <div style="margin-top:40px;">

                                    <div style="
                                        display:flex;
                                        justify-content:space-between;
                                        gap:30px;
                                        text-align:center;
                                        align-items:flex-end;
                                    ">

                                        <!-- Authorized Signature -->
                                        <div style="flex:1; text-align:center;">

                                            <div style="min-height:25px; margin-bottom:5px;">
                                                <?php if (!empty($company_details['directors_signature'])): ?>
                                                    <img 
                                                        src="../finance/signatures/<?= htmlspecialchars($company_details['directors_signature']) ?>" 
                                                        alt="Authorized Signature"
                                                        style="max-width:180px; max-height:30px; display:block; margin:0 auto;"
                                                    >
                                                <?php endif; ?>
                                            </div>

                                            <hr style="border:1px solid #000; margin:0;">
                                            <strong>Authorized Signature</strong>

                                        </div>

                                        <!-- Delivered By -->
                                        <div style="flex:1; text-align:center;">

                                            <div style="
                                                min-height:25px;
                                                margin-bottom:5px;
                                                font-weight:bold;
                                                text-transform:uppercase;
                                                font-size:16px;
                                                display:flex;
                                                align-items:center;
                                                justify-content:center;
                                            ">
                                                <?= htmlspecialchars($deliveryNoteDetails['delivered_by']) ?>
                                            </div>

                                            <hr style="border:1px solid #000; margin:0;">
                                            <strong>Delivered By</strong>

                                        </div>

                                        <!-- Received By -->
                                        <div style="flex:1; text-align:center;">

                                            <div style="min-height:25px; margin-bottom:5px;"></div>

                                            <hr style="border:1px solid #000; margin:0;">
                                            <strong>Received By</strong>

                                        </div>

                                        <!-- Customer Signature -->
                                        <div style="flex:1; text-align:center;">

                                            <div style="min-height:25px; margin-bottom:5px;"></div>

                                            <hr style="border:1px solid #000; margin:0;">
                                            <strong>Customer Signature</strong>

                                        </div>

                                    </div>

                                </div>




                            </div>
                        </div> <!-- /printableArea -->
                    </div>
                </section>
            </div>

            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/dist/js/adminlte.js"></script>
            <script>
                function dispatchDocument(docType, transactionId, channel) {
                    if (!docType || !transactionId || !channel) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Invalid Request',
                            text: 'Missing document dispatch parameters'
                        });
                        return;
                    }

                    $.post(
                        'controllers/document_dispatch_controller.php',
                        {
                            doc_type: docType,
                            transaction_id: transactionId,
                            channel: channel
                        },
                        function (response) {

                            if (response.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success',
                                    text: response.message
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.message || 'An unexpected error occurred'
                                });
                            }

                        },
                        'json'
                    ).fail(function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Request Failed',
                            text: 'Unable to dispatch document. Please try again.'
                        });
                    });
                }
            </script>
            <script>
            $(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');     // whatsapp | email
    const docType   = $(this).data('doc-type');    // cash_sale | invoice | quotation
    const reference = $(this).data('reference');

    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}
            </script>
        </body>
    </html>