<?php 
include('menu_cashier.php');
include_once 'model/sales_model.php';
include_once 'model/common_model.php';

$sales_model = new sales_model();
$common_model = new common_model();

$company_details = $common_model->getCompanyDetails();
$invoice_number = $_GET['invoice_number'];

$invoice = $sales_model->getInvoiceData($invoice_number);
$items = $sales_model->getInvoiceItems($invoice_number);

$state = $invoice['order_state'];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Powertex || Customer Invoice</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">

    <style>
        .delivery-note { font-size: 14px; font-family: "Times New Roman", serif; }
        .delivery-note p { font-size: 16px; }
        .delivery-note h6 { font-size: 14px; }

        .office-title {
            font-size: 20px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 2px;
        }

        .office-text { font-size: 14px; line-height: 1.15; }
        .office-block { padding: 0 5px; }

        .dn-title { font-size: 22px; font-weight: bold; }

        .delivery-note th,
        .delivery-note td { font-size: 16px; padding: 5px !important; }

        .table td, .table th { border-bottom: 1px solid #000; }

        .delivery-logo { max-height: 70px; margin: 5px auto; display: block; }

        .watermark {
            position: absolute;
            top: 50%;
            left: 55%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 100px;
            font-weight: bold;
            color: inherit;
            opacity: 0.55;
            white-space: nowrap;
            pointer-events: none;
            z-index: 0;
        }

        @media print {

    body {
        background: #fff !important;
        margin: 0 !important;
        padding: 0 !important;
        font-size: 12pt;
    }

    body * {
        visibility: hidden;
    }

    #printableArea, #printableArea * {
        visibility: visible;
    }

    #printableArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        padding: 0;
        margin: 0;
    }

    /* Remove AdminLTE / Bootstrap visual noise */
    .card,
    .card-body,
    .content-wrapper,
    .container-fluid {
        box-shadow: none !important;
        border: none !important;
        padding: 0 !important;
        margin: 0 !important;
        background: #fff !important;
    }

    /* Table print clarity */
    table {
        width: 100% !important;
        border-collapse: collapse !important;
    }

    th, td {
        border: 1px solid #000 !important;
        padding: 6px !important;
        font-size: 11pt !important;
    }

    /* Force rows not to split across pages */
    tr {
        page-break-inside: avoid !important;
    }

    /* Hide all buttons & modals */
    button,
    .modal,
    .btn,
    .card-header {
        display: none !important;
    }

    /* Watermark positioning fix */
    .watermark {
        position: fixed !important;
        top: 45% !important;
        left: 50% !important;
        transform: translate(-50%, -50%) rotate(-30deg) !important;
        font-size: 90px !important;
        opacity: 0.18 !important;
        z-index: 999 !important;
    }
}

    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
<section class="content">
<div class="container-fluid">

<div class="mb-4">
    <div class="card shadow-sm">
        <div class="card-body d-flex align-items-center">

            <!-- LEFT: TITLE ONLY -->
            <h4 class="mb-0" style="font-weight:bold;">
                Customer Invoice #<?= htmlspecialchars($invoice_number) ?>
            </h4>

            <!-- RIGHT: ALL ACTION BUTTONS INCLUDING BACK -->
            <div class="d-flex align-items-center ml-auto">  <!-- ✨ THIS IS THE FIX -->

                <?php
                    if($invoice['order_state'] == 1 || $invoice['order_state'] == 0 || $invoice['order_state'] == 2):
                        ?>

                        <button 
                            class="btn btn-success mr-2 send-doc"
                            data-channel="whatsapp"
                            data-doc-type='invoice'
                            data-reference="<?= $invoice_number ?>"
                            title="Send via WhatsApp">
                            <i class="fab fa-whatsapp"></i>
                        </button>
                        <!-- Send Email -->
                        
                            <button 
                                class="btn btn-danger mr-2 send-doc"
                                data-channel="email"
                                data-doc-type='invoice'
                                data-reference="<?= $invoice_number ?>"
                                title="Send via Email">
                                <i class="fas fa-envelope"></i>
                            </button>
                <?php 
                        endif;
                ?>

                <!-- PRINT BUTTON -->
                <button class="btn btn-primary mr-2" onclick="window.print()">
                    <i class="fa fa-print"></i>
                </button>

                <!-- BACK BUTTON (NOW ON FAR RIGHT) -->
                <button class="btn btn-info" onclick="history.back()">
                    <i class="fa fa-arrow-left ml-1"></i>
                </button>

            </div>

        </div>
    </div>
</div>




<div id="printableArea">

<?php
// -------------------------------------------------------
// STATUS AND WATERMARK LOGIC
// -------------------------------------------------------
  // FIXED — now defined early

$statusMap = [
    0 => ['label' => 'Declined',  'badge' => 'badge-danger'],
    1 => ['label' => 'Pending',   'badge' => 'badge-warning'],
    2 => ['label' => 'Received',  'badge' => 'badge-success'],
    3 => ['label' => 'Cancelled', 'badge' => 'badge-secondary']
];

$watermarkText = [
    3 => "Cancelled Invoice",
];

$watermarkColors = [
    0 => 'rgba(255, 0, 0, 0.35)',      // Strong Red
    1 => 'rgba(255, 205, 0, 0.40)',    // Strong Yellow
    2 => 'rgba(0, 230, 118, 0.35)',    // Strong Green
    3 => 'rgba(90, 100, 110, 0.40)'    // Strong Grey
];


$wmText  = $watermarkText[$state] ?? '';
$wmColor = $watermarkColors[$state];
?>

<?php if ($wmText != ''): ?>
    <div class="watermark" style="color: <?= $wmColor ?>;">
        <?= $wmText ?>
    </div>
<?php endif; ?>


<div class="container delivery-note" 
     style="max-width: 960px; background:#fff; padding:25px; border:1px solid #000;">

    <?php 
        $docTitle  = "Customer Invoice";
        $docNumber = $invoice_number;
        $lpo_number = $invoice['lpo_number'];
        include('print_header.php'); 

    ?>

    <hr>

    <div style="font-family: Arial; font-size: 12pt; margin-bottom: 15px;">

        <div style="display:flex; justify-content:space-between; align-items:center;">
            <strong><?= htmlspecialchars($invoice['customer_name']) ?></strong>
        </div>

        <hr style="border:1px solid #000; margin:5px 0;">

        <div style="text-align:right;">
            <span style="text-decoration:underline;">
                <strong>Date:</strong> <?= date('d F Y', strtotime($invoice['invoice_date'])) ?>
            </span>
        </div>

    </div>
    <!-- ITEMS TABLE -->
     

<table class="table table-bordered">
    <thead>
    <tr>
        <th>Description</th>
        <th>Category</th>
        <th style="width:20%">Quantity</th>
        <th style="width:25%">@</th>
        <th style="width:15%">Total</th>
    </tr>
    </thead>

    <tbody>

    <?php 
    

    // ✔ Now print the rows
    foreach ($items as $item): 
    ?>
        <tr>
            <td><?= htmlspecialchars($item['product_name']) ?></td>
            <td><?= htmlspecialchars($item['categoryname']) ?></td>
            <td style="text-align: center;"><?= htmlspecialchars($item['qty']) ?></td>
            <td style="text-align:right;"><?= number_format($item['selling_price'],2) ?></td>
            <td style="text-align:right;"><?= number_format($item['subtotal'],2) ?></td>
        </tr>
    <?php endforeach; ?>

    <?php for ($i = count($items); $i < 6; $i++): ?>
        <tr>
            <td>&nbsp;</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
        </tr>
    <?php endfor; ?>

    <!-- ✔ Totals + Customer Block -->
    <tr>
        <td colspan="3" rowspan="4" style="vertical-align: top;">
            <u><?= htmlspecialchars($invoice['customer_name']) ?>
            <strong>Tel:</strong> <?= htmlspecialchars($invoice['customer_phone']) ?></u>
        </td>

        <td><strong>Subtotal</strong></td>
        <td style="text-align:right;"><?= number_format($invoice['subtotal'], 2) ?></td>
    </tr>

    <?php if ($invoice['vat_percentage'] > 0 && $invoice['total_tax'] > 0): ?>
    <tr>
        <td>
            <strong>Plus <?= number_format($invoice['vat_percentage'] * 100, 0) ?>% VAT</strong>
        </td>
        <td class="text-right">
            <?= number_format($invoice['total_tax'], 2) ?>
        </td>
    </tr>
    <?php endif; ?>

    <?php if ($invoice['discount'] > 0): ?>
    <tr>
        <td><strong>Applied Discount</strong></td>
        <td class="text-right">
            <?= number_format($invoice['discount'], 2) ?>
        </td>
    </tr>
    <?php endif; ?>

    <tr>
        <td><strong>Grand Total</strong></td>
        <td style="text-align:right; font-weight:bold;"><?= number_format($invoice['total_bill'], 2) ?></td>
    </tr>

    </tbody>
</table>


    <!-- SIGNATURES -->
    <div class="row mt-3" style="font-size:16pt; font-family:Arial;">

        
        <div class="col-4">
           <u><p class="text-decoration-underline mb-0"><?= htmlspecialchars($invoice['customer_name'])?: 'N/A'?>&nbsp;<b>Tel:</b><?= $invoice['customer_phone'] ?></p></u>
        </div>

<div class="col-4 text-center">

    <?php if ($state == 1 || $state == 0 || $state == 2): ?>
        <p class="mb-1">
            <strong>Sign:</strong><br>
            <img src="../finance/signatures/<?= htmlspecialchars($company_details['directors_signature']) ?>" 
            alt="Signature" 
            style="height:60px; margin-top:5px;">
        </p>

        <p class="mb-0"><small>Date: <?= date('d F Y', strtotime($invoice['invoice_date'])) ?></small></p>
    <?php endif; ?>

</div>


    </div>

</div>

</div> <!-- /printableArea -->

</div>
</section>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
<script>
            $(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');     // whatsapp | email
    const docType   = $(this).data('doc-type');    // cash_sale | invoice | quotation
    const reference = $(this).data('reference');

    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}
            </script>



</body>
</html>
