<?php 
    include('menu_cashier.php');
    include_once 'model/stock_model.php';
    include_once 'model/branch_model.php';

    $stock_model = new stock_model();
    $branch_model = new branch_model();

    $products = $stock_model->getproducts($location); 
    $branchDetails = $branch_model->getBranchDetails($location);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Stock Transfers</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <!-- Header: Title + Filter + Export -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-end mb-3">
        <!-- Title -->
        <h3 class="mb-0">
            Branch Stock 
            <span class="text-primary"> - <?= htmlspecialchars($branchDetails['branch_name'] ?? "") ?></span>
        </h3>

        <!-- Filter + Export -->
        <div class="d-flex flex-column flex-sm-row align-items-stretch align-items-sm-end mt-2 mt-md-0" style="min-width: 250px;">
            <!-- Filter input -->
            <input type="text" id="filter_global" class="form-control mb-2 mb-sm-0" placeholder="Search Products" style="flex: 1;">

            <!-- Generate PDF button -->
            <form name="generate_pdf" method="post" action="generate_pdf.php" class="mb-0 ml-sm-2">
                <input type="hidden" name="export_products" value="export_products" readonly>
                <input type="hidden" name="branch_id" value="<?= htmlspecialchars($location) ?>" readonly>
                <button type="submit" id="exportBtn" class="btn btn-danger d-flex align-items-center">
                    <span id="exportText">Export Products</span>
                    <span id="exportSpinner" class="spinner-border spinner-border-sm ml-2 d-none"></span>
                </button>

            </form>
        </div>
    </div>

    <!-- TABLE -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover" id="productsTable">
            <thead>
                <tr>
                    <th>Product Name</th>
                    <th>Code</th>
                    <th>Category</th>
                    <th>Unit</th>
                    <th class="text-center">Current Qty</th>
                    <th class="text-center">Min. Order Level</th>
                    <th class="text-center">Selling Price</th>
                    <th class="text-center" style="width:15%">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($products as $p): 
                    // Determine row class based on quantity
                    $rowClass = '';
                    if ($p['quantity'] == 0) {
                        $rowClass = 'bg-danger text-white'; // red row with white text
                    } elseif ($p['quantity'] < $p['min_level']) {
                        $rowClass = 'bg-warning'; // yellow row
                    }
                ?>
                    <tr class="<?= $rowClass ?>">
                        <td><?= $p['product_name'] ?></td>
                        <td><?= $p['product_code'] ?></td>
                        <td><?= $p['categoryname'] ?></td>
                        <td><?= $p['unitname'] ?></td>
                        <td class="text-center text-success font-weight-bold"><?= $p['quantity'] ?></td>
                        <td class="text-center"><?= $p['min_level'] ?></td>
                        <td class="text-right"><?= number_format($p['selling_price'], 2) ?></td>
                        <td class="text-center">
                            <button class="btn btn-warning edit-btn" 
                                data-product='<?= json_encode([
                                    "id"=>$p['product_id'],
                                    "name"=>$p['product_name'],
                                    "code"=>$p['product_code'],
                                    "category"=>$p['categoryname'],
                                    "unit"=>$p['unitname'],
                                    "selling_price"=>$p['selling_price'],
                                    "opening_stock"=>$p['opening_stock'],
                                    "current_qty"=>$p['quantity'],
                                    "min_order_level"=>$p['min_level'],
                                    "branch_id"=>$p['branch_id']
                                ]) ?>'>
                                <i class="fa fa-edit"></i>
                            </button>

                            <a title="Product Breakdown" href="product_breakdown.php?branch=<?= $location ?>&product=<?= $p['product_id'] ?>" class="btn btn-info">
                                <i class="fa fa-stream"></i>
                            </a>

                            <a title="Product Stock Sheet" href="product_stock_sheet.php?branch=<?= $location ?>&product=<?= $p['product_id'] ?>" class="btn btn-info">
                                <i class="fa fa-file-alt"></i>
                            </a>

                            <button class="btn btn-info feature-not-ready">
                                <i class="fa fa-cog"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>

                


        </table>
    </div>

</div>

<!-- MODAL: Update Product -->
<div class="modal fade" id="minOrderModal" tabindex="-1" role="dialog" aria-labelledby="minOrderModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="minOrderForm" method="POST" action="controllers/products_controller.php">
                <div class="modal-header">
                    <h5 class="modal-title" id="minOrderModalLabel">Update Product Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="product_id" id="modal_product_id">
                    <input type="hidden" name="branch_id" id="modal_branch_id">
                    <input type="hidden" name="action" value="update_details" readonly>

                    <div class="row">
                        <!-- Left Column -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Product Name</label>
                                <input type="text" class="form-control" id="modal_product_name" readonly>
                            </div>
                            <div class="form-group">
                                <label>Product Code</label>
                                <input type="text" class="form-control" id="modal_product_code" readonly>
                            </div>
                            <div class="form-group">
                                <label>Category</label>
                                <input type="text" class="form-control" id="modal_category" readonly>
                            </div>
                            <div class="form-group">
                                <label>Unit</label>
                                <input type="text" class="form-control" id="modal_unit" readonly>
                            </div>
                        </div>

                        <!-- Right Column -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Selling Price</label>
                                <input type="text" class="form-control" id="modal_selling_price" readonly>
                            </div>
                            <div class="form-group">
                                <label>Opening Stock</label>
                                <input type="number" class="form-control" id="modal_opening_stock" readonly>
                            </div>
                            <div class="form-group">
                                <label>Current Quantity</label>
                                <input type="number" class="form-control" id="modal_current_qty" readonly>
                            </div>
                            <div class="form-group">
                                <label>Minimum Order Level</label>
                                <input type="number" class="form-control" name="min_order_level" id="modal_min_order_level" min="0" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- SCRIPTS -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
        <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="../includes/dist/js/adminlte.js"></script>
        
        <script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    let table;

                $(document).ready(function () {

                    table = $('#productsTable').DataTable({
                        paging: true,
                        pageLength: 500,
                        lengthChange: false,
                        ordering: true,
                        order: [
                            [4, 'desc'],
                            [0, 'desc']
                        ],
                        info: true,
                        searching: true,
                        responsive: true,
                        autoWidth: false,
                        dom: 'rtip',
                        columnDefs: [{
                            targets: 7, // Status column
                            render: function (data, type) {
                                if (type === 'filter' || type === 'search') {
                                    return $('<div>').html(data).text().replace(/\s+/g, ' ').trim();
                                }
                                return data;
                            }
                        }]
                    });


                    

                    // Global search
                    $('#globalSearch').on('keyup', function () {
                        table.search(this.value).draw();
                    });

                    // Payment Method filter (column 4)
                    $('#filterPaymentMethod').on('change', function () {
                        table.column(5).search(this.value).draw();
                    });

                    // Status filter (column 6)
                    $('#filterStatus').on('change', function () {
                        let val = this.value;

                        console.log('Selected:', val);

                        if (val) {
                            table.column(7)
                                .search('^' + val + '$', true, false)
                                .draw();
                        } else {
                            table.column(7).search('').draw();
                        }
                    });

                    


                });
$(document).ready(function(){
    // Global search filter
    $("#filter_global").on("keyup", function(){
        let value = $(this).val().toLowerCase();
        $("#productsTable tbody tr").filter(function(){
            $(this).toggle($(this).text().toLowerCase().includes(value));
        });
    });

    // Feature not ready
    $(".feature-not-ready").on("click", function(e) {
        e.preventDefault();
        toastr.info("This feature is currently disabled.", "Message", {
            closeButton: true,
            progressBar: true,
            timeOut: 3500,
            positionClass: "toast-top-right"
        });
    });

    // Edit button
    $(".edit-btn").on("click", function(){
        let product = $(this).data("product");
        $("#modal_product_id").val(product.id);
        $("#modal_branch_id").val(product.branch_id);
        $("#modal_product_name").val(product.name);
        $("#modal_product_code").val(product.code);
        $("#modal_category").val(product.category);
        $("#modal_unit").val(product.unit);
        $("#modal_selling_price").val(product.selling_price);
        $("#modal_opening_stock").val(product.opening_stock);
        $("#modal_current_qty").val(product.current_qty);
        $("#modal_min_order_level").val(product.min_order_level || 0);

        $("#minOrderModal").modal("show"); // BS4 compatible
    });
});
</script>
<script>
                document.querySelector("form[name='generate_pdf']").addEventListener("submit", function(e) {
                    let btn = document.getElementById("exportBtn");

                    // Disable button
                    btn.disabled = true;

                    // Change text
                    document.getElementById("exportText").innerText = "Generating...";

                    // Show spinner
                    document.getElementById("exportSpinner").classList.remove("d-none");

                    // Auto enable button again after download trigger (2–3 sec delay)
                    // This prevents locking the button forever.
                    setTimeout(function(){
                        btn.disabled = false;
                        document.getElementById("exportText").innerText = "Export Products";
                        document.getElementById("exportSpinner").classList.add("d-none");
                    }, 8000); // adjust time if needed
                });
                </script>
                

</body>
</html>
