<?php

include_once 'config.php';

class finance_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }


    public function getSalesData($location, $type = 'daily'){

        if ($type === 'daily') {
            $startDate = date('Y-m-d');
            $endDate   = date('Y-m-d');
        } 
        elseif ($type === 'monthly') {
            $startDate = date('Y-m-01');
            $endDate   = date('Y-m-t');
        } 
        else {
            return [
                'cash_sales' => 0,
                'invoice_sales' => 0
            ];
        }

        $sql = "SELECT
                -- Cash Sales (payments only)
                (
                    SELECT 
                        IFNULL(SUM(p.amount_paid), 0)
                    FROM 
                        payments p
                    WHERE 
                        p.payment_state = 1
                        AND p.payment_type = 'Cash Sale'
                        AND p.location = :location
                        AND p.payment_date BETWEEN :startDate AND :endDate
                ) AS cash_sales,

                -- Invoice Sales (invoices only)
                (
                    SELECT 
                        IFNULL(SUM(so.total_bill), 0)
                    FROM 
                        saved_orders so
                    WHERE
                        so.invoice_location = :location
                        AND so.order_state IN (0,1,2)
                        AND so.orderdate BETWEEN :startDate AND :endDate
                ) AS invoice_sales,

                (
                    SELECT 
                        IFNULL(SUM(p.amount_paid),0)
                    FROM 
                        payments p
                    WHERE
                        payment_state = 1
                        AND p.location = :location
                        AND p.payment_date BETWEEN :startDate AND :endDate
                )as total_payments
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->execute([
            ':location'  => $location,
            ':startDate'=> $startDate,
            ':endDate'  => $endDate
        ]);

        return $stmt->fetch(PDO::FETCH_ASSOC);
    }


    public function countOpenInvoices($location){
        $sql = "SELECT 
            count(*) as openbills 
        FROM 
            saved_orders 
        WHERE 
            order_state IN(0, 1) 
            AND invoice_location =:location";
        $smtp = $this->link->prepare($sql);
        $smtp ->bindParam(':location', $location, PDO::PARAM_INT);
        $smtp->execute();

        $open_bills = $smtp->fetchColumn();
        return $open_bills !== false ? $open_bills : 0;

    }

    public function countActiveQuotations($location, $operator){
        $sql = "SELECT 
            count(*) as active_quotations
        FROM 
            quotations 
        WHERE 
            quotation_state = 0
            AND DATE(quotation_valid_until) >= CURDATE() 
            AND quote_from =:location OR operator =:operator";
        $smtp = $this->link->prepare($sql);
        $smtp ->bindParam(':operator', $operator, PDO::PARAM_INT);
        $smtp ->bindParam(':location', $location, PDO::PARAM_INT);
        $smtp->execute();

        $active_quotations = $smtp->fetchColumn();
        return $active_quotations !== false ? $active_quotations : 0;

    }

    public function getTotalOutstandingInvoices($location){
        // $employee_code is optional in case you want to filter by operator
        $sql = "SELECT 
                    SUM(total_bill - IFNULL(total_paid, 0)) AS total_outstanding
                FROM 
                    saved_orders
                LEFT JOIN (
                    SELECT 
                        invoice_number, 
                        SUM(amount_paid) AS total_paid
                    FROM 
                        invoice_payments
                    WHERE 
                        payment_state = 1
                    GROUP BY 
                        invoice_number
                ) AS p ON saved_orders.order_number = p.invoice_number
                WHERE order_state IN (0,1)
                AND invoice_location = :location"; 

        

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return floatval($row['total_outstanding'] ?? 0);
    }



           
}