<?php

include_once 'config.php';

class warehouse_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getWarehouses() {
        try {
            $stmt = $this->link->prepare("SELECT 
                    w.*, 
                    l.location_name,
                    COUNT(wp.product_id) AS product_count,
                    w.warehouse_state,
                    CASE 
                        WHEN w.warehouse_state = 1 THEN 'Active warehouse'
                        WHEN w.warehouse_state = 0 THEN 'Deactivated warehouse'
                    END as warehouse_status
                FROM 
                    warehouses w
                LEFT JOIN 
                    locations l ON w.location = l.loc_id
                LEFT JOIN 
                    warehouse_products wp ON w.warehouse_id = wp.warehouse_id
                WHERE 
                    w.warehouse_state IN (0,1)
                GROUP BY 
                    w.warehouse_id
                ORDER BY 
                    w.warehouse_name ASC
            ");
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get warehouses error: " . $e->getMessage());
            return [];
        }
    }
           
}