<?php
include_once 'menu_cashier.php';
include_once 'model/stock_model.php';
include_once 'model/customers_model.php';

$stock_model     = new stock_model();
$customers_model = new customers_model();

$customers = $customers_model->getCustomers($location, ['Corporate', 'Dealer'], [1]);
$products  = $stock_model->getproducts($location);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Create Delivery Note</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <style>
/* Make Select2 look exactly like form-control */
.select2-container .select2-selection--single {
    height: 38px;
    padding: 6px 12px;
    border: 1px solid #ced4da;
    border-radius: 4px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 24px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px;
}
</style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="content-wrapper p-4">

<!-- ================= CONTENT HEADER (FULL PAGE CONTENT) ================= -->
<section class="content-header">
<div class="container-fluid">

<form method="post" action="controllers/products_controller.php" id="deliveryNoteForm">

<input type="hidden" name="action" value="create_delivery_note">
<input type="hidden" name="location" value="<?= intval($location) ?>">

<!-- ===== PAGE TITLE ===== -->
<div class="row mb-3">
    <div class="col-md-6">
        <h1 class="m-0">
            <i class="fa fa-truck"></i> New Delivery Note
        </h1>
    </div>
    <div class="col-md-6 text-right">
        <a href="delivery_notes.php" class="btn btn-secondary btn-sm">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>

<!-- ================= DELIVERY INFO ================= -->
<div class="row">
<div class="col-md-12">

<div class="card card-primary">
    <div class="card-header">
        <h3 class="card-title">Delivery Information</h3>
    </div>

    <div class="card-body">
        <div class="row">

            <div class="col-md-2">
                <label>Delivery Note No.</label>
                <input type="text"
                       name="delivery_note_no"
                       class="form-control"
                       value="<?= $_GET['dn_number'] ?? '' ?>"
                       readonly>
            </div>
            <div class="col-md-2">
                <label>Customer</label>
                <select name="customer_id" class="form-control product-select" required>
                    <option value="">-- Select Customer --</option>
                    <?php foreach ($customers as $c): ?>
                        <option value="<?= $c['customer_id'] ?>">
                            <?= htmlspecialchars($c['customer_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label>Item Collection Date</label>
                <input type="date"
                       name="delivery_date"
                       max="<?= date('Y-m-d') ?>"
                       class="form-control"
                       required>
            </div>

            <div class="col-md-2">
                <label>Delivered By</label>
                <input type="text"
                       name="delivered_by" placeholder="Items collected By"
                       class="form-control" required>
            </div>

            <div class="col-md-3">
                <label>Reference</label>
                <input type="text"
                       name="reference_no"
                       class="form-control"
                       placeholder="Optional">
            </div>

            

        </div>
    </div>
</div>

</div>
</div>

<!-- ================= DELIVERY ITEMS ================= -->
<div class="row">
<div class="col-md-12">

<div class="card card-outline card-info">
    <div class="card-header">
        <h3 class="card-title">Delivery Items</h3>
    </div>

    <div class="card-body p-0">
        <table class="table table-bordered mb-0" id="itemsTable">
            <thead>
                <tr>
                    <th width="35%">Product</th>
                    <th width="35%">Category</th>
                    <th width="10%">Available</th>
                    <th width="15%">Qty</th>
                    <th width="5%"></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <select name="product_id[]" class="form-control product-select" required>
                            <option value="">-- Select Product --</option>
                            <?php foreach ($products as $p): ?>
                                <option value="<?= $p['product_id'] ?>"
                                        data-stock="<?= $p['quantity'] ?>"
                                        data-category="<?= $p['categoryname'] ?>">
                                        
                                    <?= htmlspecialchars($p['product_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>

                    <td>
                        <input type="text"  class="form-control product-category" readonly>
                    </td>

                    <td>
                        <input type="text"
                               class="form-control available-stock" style="text-align: center;"
                               readonly>
                    </td>

                    <td>
                        <input type="number"
                               name="qty[]"
                               class="form-control qty"
                               min="1"
                               required>
                    </td>

                    <td class="text-center">
                        <button type="button" class="btn btn-danger btn-sm remove-row">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="card-footer">
        <button type="button" class="btn btn-default" id="addRow">
            <i class="fa fa-plus"></i> Add Item
        </button>
    </div>
</div>

</div>
</div>

<!-- ================= ACTIONS ================= -->
<div class="row">
<div class="col-md-12 text-right">
    <button type="submit" class="btn btn-success">
        <i class="fa fa-save"></i> Save Delivery Note
    </button>
</div>
</div>

</form>

</div>
</section>

</div><!-- jQuery -->
<!-- jQuery -->
<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.min.js"></script>
<script src="../includes/plugins/select2/js/select2.min.js"></script>


<script>
$(document).ready(function () {

    /* ================= INIT SELECT2 ================= */
    function initSelect2(context = document) {
        $(context).find('.product-select').select2({
            width: '100%',
            placeholder: '-- Select Product --',
            allowClear: true
        });
    }

    initSelect2();

    /* ================= PRODUCT CHANGE ================= */
    $(document).on('change', '.product-select', function () {
        const selectedProduct = $(this).val();
        const currentRow = $(this);

        currentRow.closest('tr').find('.available-stock').val('');
        currentRow.closest('tr').find('.product-category').val('');

        if (!selectedProduct) return;

        let duplicate = false;

        $('.product-select').not(this).each(function () {
            if ($(this).val() === selectedProduct) {
                duplicate = true;
                return false;
            }
        });

        if (duplicate) {
            Swal.fire({
                icon: 'warning',
                title: 'Duplicate Item',
                text: 'This product is already added to the delivery note.'
            });

            currentRow.val(null).trigger('change');
            return;
        }

        const stock    = currentRow.find(':selected').data('stock') || 0;
        const category = currentRow.find(':selected').data('category') || '';

        currentRow.closest('tr').find('.available-stock').val(stock);
        currentRow.closest('tr').find('.product-category').val(category);
    });

    /* ================= QTY VALIDATION (REAL-TIME) ================= */
    $(document).on('input', '.qty', function () {

        const row = $(this).closest('tr');
        const available = parseFloat(row.find('.available-stock').val()) || 0;
        const qty = parseFloat($(this).val()) || 0;

        if (qty > available) {
            Swal.fire({
                icon: 'error',
                title: 'Insufficient Stock',
                text: 'Quantity cannot exceed available stock (' + available + ').'
            });

            $(this).val('');
        }
    });


    /* ================= ADD ROW ================= */
    $('#addRow').on('click', function () {

        const $tbody = $('#itemsTable tbody');
        const $template = $tbody.find('tr:first');

        // Clone WITHOUT Select2 artifacts
        let $newRow = $template.clone(false);

        // Remove Select2 container completely
        $newRow.find('.select2-container').remove();

        // Get original select HTML (clean)
        let $cleanSelect = $template.find('select.product-select').first().clone(false);

        // Reset select & inputs
        $cleanSelect.val('');
        $newRow.find('input').val('');

        // Replace the select in the new row
        $newRow.find('select.product-select').replaceWith($cleanSelect);

        // Append row
        $tbody.append($newRow);

        // Re-init Select2 on the NEW select only
        $cleanSelect.select2({
            width: '100%',
            placeholder: '-- Select Product --',
            allowClear: true
        });
    });


    /* ================= REMOVE ROW ================= */
    $(document).on('click', '.remove-row', function () {
        if ($('#itemsTable tbody tr').length > 1) {
            $(this).closest('tr').remove();
        }
    });

    /* ================= FORM SUBMIT VALIDATION ================= */
    $('#deliveryNoteForm').on('submit', function (e) {
        let products = [];
        let duplicate = false;
        let qtyError = false;

        $('.product-select').each(function () {
            const val = $(this).val();
            if (val) {
                if (products.includes(val)) {
                    duplicate = true;
                    return false;
                }
                products.push(val);
            }
        });

        $('.qty').each(function () {
            if (parseFloat($(this).val()) <= 0 || isNaN($(this).val())) {
                qtyError = true;
                return false;
            }
        });

        if (duplicate) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'Duplicate Products',
                text: 'Please remove duplicate items before saving.'
            });
            return;
        }

        if (qtyError) {
            e.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'Invalid Quantity',
                text: 'Quantity must be greater than zero.'
            });
        }
    });

});
</script>




</body>
</html>
