<?php 
    include('menu_cashier.php');
    include_once 'model/payments_model.php';

    $payments_model = new payments_model();

        if(!isset($_GET['start_date']) && !isset($_GET['end_date'])){
            $start_date = date('Y-m-01');
            $end_date = date('Y-m-t');
        }else{
            $start_date = $_GET['start_date'];
            $end_date = $_GET['end_date'];
        }

    $payments = $payments_model->getPayments($location, $start_date, $end_date);
?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Powertex || Payments</title>
            <link rel="icon" type="image/png" href="../finance/images/favicon.png">
        </head>

        <body class="hold-transition sidebar-mini layout-fixed">

            <div class="content-wrapper p-4">
                <section class="content">
                    <div class="container-fluid">
                        <h4 class="mb-3">
                            Customer Payments
                        </h4>

                        <div class="row mb-3 align-items-center">

                            <div class="col-md-3">
                                <input type="text" id="globalSearch" class="form-control" placeholder="Search payments...">
                            </div>

                            <div class="col-md-2">
                                <select id="filterPaymentMethod" class="form-control">
                                    <option value="">All Payment Methods</option>
                                    <option value="Cash">Cash</option>
                                    <option value="Online Transfer">Bank Transfer</option>
                                    <option value="Airtel Money">Airtel Money</option>
                                    <option value="Mpamba">Mpamba</option>
                                    <option value="Visa">Visa</option>
                                    <option value="POS Machine">POS Payment</option>
                                    <option value="Cheque">Cheque</option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <select id="filterStatus" class="form-control">
                                    <option value="">All Status</option>
                                    <option value="Completed">Completed</option>
                                    <option value="Cancelled">Cancelled</option>
                                    <option value="Failed">Failed</option>
                                </select>
                            </div>

                            <div class="col-md-5">
                                <div id="dateFilterBar" class="d-flex align-items-center">

                                    <div class="input-group mr-2">
                                        <input type="text" class="form-control" id="start_date" value="<?= $start_date ?>" autocomplete="off">
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                    </div>

                                    <div class="input-group mr-2">
                                        <input type="text" class="form-control" id="end_date" value="<?= $end_date ?>" autocomplete="off">
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="far fa-calendar-alt"></i>
                                            </span>
                                        </div>
                                    </div>

                                    <button id="applyDateFilter" class="btn btn-primary">
                                        Filter
                                    </button>

                                </div>
                            </div>
                        </div>
            

                        <!-- Payments Table -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Customer Payments</h5>
                            </div>

                            <div class="card-body table-responsive">
                                <table id="paymentsTable" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Receipt</th>
                                            <th>Customer</th>
                                            <th>Type</th>
                                            <th>Reference</th>
                                            <th>Payment Method</th>
                                            <th class="text-right">Amount</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php if (empty($payments)): ?>
                                            <tr>
                                                <td colspan="8" class="text-center text-muted">
                                                    No payment records found.
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <?php foreach ($payments as $row): ?>
                                                <tr>
                                                    <td><?= htmlspecialchars($row['date']) ?></td>
                                                    <td><?= htmlspecialchars($row['payment_reference']) ?></td>
                                                    <td><?= htmlspecialchars($row['customer']) ?></td>
                                                    <td><?= htmlspecialchars($row['type']) ?></td>
                                                    <td><?= htmlspecialchars($row['invoice_reference'] ?? '—') ?></td>
                                                    <td><?= htmlspecialchars($row['payment_method'] ?? '—') ?></td>
                                                    <td class="text-right"><?= number_format($row['amount'], 2) ?></td>
                                                    <td>
                                                        <span class="<?= ($row['status']=='Completed')?'badge badge-success':($row['status']=='Pending'?'badge badge-warning':'badge badge-danger') ?>">
                                                            <?= $row['status'] ?>
                                                        </span>
                                                    </td>
                                                    <?php
                                                        if($row['payment_type'] == 'Order Payment'){
                                                            $url = "invoice_payment_receipt.php?id=".$row['id'];
                                                        }elseif($row['payment_type'] == 'Cash Sale'){
                                                            $url = 'cash_sale_receipt.php?id='.$row['sale_id'];
                                                        }
                                                    ?>
                                                    <td class="text-center">
                                                        <a href="<?= $url ?>" class="btn btn-sm btn-info">
                                                            <i class="fas fa-receipt"></i>
                                                        </a>

                                                        <button 
                                                        class="btn btn-success btn-sm send-doc"
                                                        data-channel="whatsapp"
                                                        data-doc-type="<?= ($row['payment_type']=='Cash Sale') ? 'cash_sale' : 'invoice_payment' ?>"
                                                        data-reference="<?= $row['invoice_reference'] ?>"
                                                        title="Send via WhatsApp">
                                                        <i class="fab fa-whatsapp"></i>
                                                    </button>

                                                    <!-- Send Email -->
                                                    <button 
                                                        class="btn btn-primary btn-sm send-doc"
                                                        data-channel="email"
                                                        data-doc-type="<?= ($row['payment_type']=='Cash Sale') ? 'cash_sale' : 'invoice_payment' ?>"
                                                        data-reference="<?= $row['invoice_reference'] ?>"
                                                        title="Send via Email">
                                                        <i class="fas fa-envelope"></i>
                                                    </button>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>

                                    <tfoot>
                                        <tr style="background:#333;color:#fff;font-weight:bold;">
                                            <td colspan="6" class="text-right">TOTAL</td>
                                            <td class="text-right" id="totalAmount"></td>
                                            <td colspan="2"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </section>
            </div>


            <script src="../includes/plugins/datatables/jquery.dataTables.min.js"></script>
            <script src="../includes/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
            <script src="../includes/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
            <script src="../includes/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
            <link rel="stylesheet" href="../includes/plugins/daterangepicker/daterangepicker.css">
            <script src="../includes/plugins/moment/moment.min.js"></script>
            <script src="../includes/plugins/daterangepicker/daterangepicker.js"></script>

            <script>
                let table;

                $(document).ready(function () {

                    table = $('#paymentsTable').DataTable({
                        paging: true,
                        pageLength: 15,
                        lengthChange: false,
                        ordering: true,
                        order: [[0, 'desc']],
                        info: true,
                        searching: true,
                        responsive: true,
                        autoWidth: false,
                        dom: 'rtip',
                        columnDefs: [{
                            targets: 7, // Status column
                            render: function (data, type) {
                                if (type === 'filter' || type === 'search') {
                                    return $('<div>').html(data).text().replace(/\s+/g, ' ').trim();
                                }
                                return data;
                            }
                        }]
                    });


                    // INITIAL TOTALS
                    calculateTotals();

                    // Recalculate totals on every draw
                    table.on('draw', function () {
                        calculateTotals();
                    });

                    // Global search
                    $('#globalSearch').on('keyup', function () {
                        table.search(this.value).draw();
                    });

                    // Payment Method filter (column 4)
                    $('#filterPaymentMethod').on('change', function () {
                        table.column(5).search(this.value).draw();
                    });

                    // Status filter (column 6)
                    $('#filterStatus').on('change', function () {
                        let val = this.value;

                        console.log('Selected:', val);

                        if (val) {
                            table.column(7)
                                .search('^' + val + '$', true, false)
                                .draw();
                        } else {
                            table.column(7).search('').draw();
                        }
                    });

                    table.column(7).data().each(function (d) {
                        console.log(JSON.stringify(d));
                    });


                });

                function calculateTotals() {

                    let totalAmount = 0;

                    table.rows({ search: 'applied' }).every(function () {
                        let data = this.data();
                        totalAmount += parseFloat(data[6].replace(/,/g, '')) || 0;
                    });

                    $('#totalAmount').text(totalAmount.toLocaleString(undefined, { minimumFractionDigits: 2 }));
                }

                $('#applyDateFilter').on('click', function () {

                    const start = $('#start_date').val();
                    const end   = $('#end_date').val();

                    if (!start || !end) {
                        alert('Please select both dates');
                        return;
                    }

                    const params = new URLSearchParams(window.location.search);
                    params.set('start_date', start);
                    params.set('end_date', end);

                    window.location.search = params.toString();
                });

                $('#start_date, #end_date').daterangepicker({
                    singleDatePicker: true,
                    showDropdowns: true,
                    autoUpdateInput: true,
                    locale: {
                        format: 'YYYY-MM-DD'
                    }
                });
            </script>
            <script>
$(document).on('click', '.send-doc', function () {

    const channel   = $(this).data('channel');     // whatsapp | email
    const docType   = $(this).data('doc-type');    // cash_sale | invoice | quotation
    const reference = $(this).data('reference');

    console.log(`Preparing to send ${docType} via ${channel} for reference: ${reference}`);

    Swal.fire({
        title: 'Send Document?',
        text: `Send this ${docType.replace('_',' ')} via ${channel}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Proceed To Send',
        cancelButtonText: 'Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            sendDocument(channel, docType, reference);
        }
    });
});

function sendDocument(channel, docType, reference) {

    // 🔹 Show loader while server is generating document
    Swal.fire({
        title: 'Please wait...',
        html: 'Processing Data...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: 'controllers/documents_controller.php',
        type: 'POST',
        dataType: 'json',
        data: {
            channel: channel,
            document_type: docType,
            reference: reference
        },
        success: function (res) {
            console.log('WhatsApp URL:', res.debug ? res.debug.url : 'No URL');

            Swal.close(); // 🔹 Close the loader first

            if (res.success) {

                if (channel === 'whatsapp' && res.debug && res.debug.url) {
                    window.open(res.debug.url, '_blank'); // existing WhatsApp behavior
                }

                // ✅ Show success for both WhatsApp and Email
                Swal.fire({
                    icon: 'success',
                    title: 'Ready',
                    html: res.message
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Failed',
                    html: res.message
                });
            }
        },

        error: function () {
            Swal.close(); // 🔹 Close loader even if request fails
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Could not send document.'
            });
        }
    });
}

</script>
        </body>
    </html>
