<?php 
include('menu_cashier.php');
include_once 'model/stock_model.php';
include_once 'model/branch_model.php';

$stock_model = new stock_model();
$branch_model = new branch_model();

// Get branch and product from URL
$location   = $_GET['branch'] ?? 0;
$product_id = $_GET['product'] ?? 0;

// Fetch branch details
$branchDetails = $branch_model->getBranchDetails($location);
// Fetch product details
$productDetails = $stock_model->getProductDetails($product_id);

// Fetch stock breakdown for this product
$breakdown = $stock_model->getProductBreakdown($location, $product_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex || Product Breakdown</title>
<link rel="icon" type="image/png" href="../finance/images/favicon.png">
<link rel="stylesheet" href="../includes/plugins/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="../includes/plugins/fontawesome/css/all.min.css">

<style>
    /* Product card enhancements */
    .product-card {
        border-radius: 12px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        transition: all 0.2s ease-in-out;
    }
    .product-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0,0,0,0.15);
    }
    .product-card h5 {
        font-weight: 600;
        font-size: 1.3rem;
    }
    .product-card p {
        font-size: 0.95rem;
        margin-bottom: 0;
    }

    /* Table styling */
    .table thead {
        background: #343a40; /* dark header */
        color: #fff;
    }
    .table tbody tr:nth-child(even) {
        background: #f8f9fa;
    }
    .table tbody tr:hover {
        background: #e2e6ea;
    }
    .text-icon {
        margin-right: 5px;
    }

    /* Title row with back button */
    .title-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <div class="title-row">
        <h3>
            <i class="fas fa-boxes text-primary"></i> Product Breakdown 
            <span class="text-primary"> - <?= htmlspecialchars($warehouseDetails['warehouse_name'] ?? "") ?></span>
            <span class="text-info"> - <?=  htmlspecialchars($productDetails['product_name'] ?? "") ?></span>
        </h3>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left text-white"></i> Back
        </a>
    </div>

    <!-- Product Info Card -->
    <div class="card product-card mb-4">
        <div class="card-body">
            <h5>
                <i class="fas fa-cube text-success text-icon"></i>
                <?= htmlspecialchars($productDetails['product_name'] ?? "") ?> 
                (<?= $productDetails['product_code'] ?? "" ?>)
            </h5>
            <p>
                <i class="fas fa-tags text-info text-icon"></i> <strong>Category:</strong> <?= $productDetails['categoryname'] ?? "" ?> |
                <i class="fas fa-balance-scale text-warning text-icon"></i> <strong>Unit:</strong> <?= $productDetails['unitname'] ?? "" ?> |
                <i class="fas fa-dollar-sign text-danger text-icon"></i> <strong>Selling Price:</strong> <?= number_format($productDetails['selling_price'] ?? 0, 2) ?>
            </p>
        </div>
    </div>

    <!-- Stock Breakdown Table -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="text-center">
                <tr>
                    <th><i class="fas fa-calendar-alt text-info text-icon"></i> Transfer Date</th>
                    <th><i class="fas fa-exchange-alt text-primary text-icon"></i> Type</th>
                    <th><i class="fas fa-sort-numeric-up text-success text-icon"></i> Quantity</th>
                    <th><i class="fas fa-link text-warning text-icon"></i> Reference</th>
                    <th><i class="fas fa-boxes text-danger text-icon"></i> Closing Stock</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($breakdown as $b): ?>
                <tr class="text-center">
    <td style="text-align: left;"><?= date("d F Y", strtotime($b['date'])) ?></td>

    <td style="text-align: left;"
        class="<?php 
            $type = strtolower($b['type']);
            if ($type == 'transfer in') {
                echo 'bg-success text-white';
            } elseif ($type == 'sold' || $type == 'transfer out') {
                echo 'bg-danger text-white';
            }
        ?>">
        <?= htmlspecialchars($b['type']) ?>
    </td>

    <td><?= (int)$b['quantity'] ?></td>
    <td style="text-align: left;"><?= htmlspecialchars($b['reference'] ?? '-') ?></td>
    <td><?= isset($b['closing_stock']) ? (int)$b['closing_stock'] : '-' ?></td>
</tr>

                <?php endforeach; ?>
                <?php if(empty($breakdown)): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No transactions found for this period.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>


</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
</body>
</html>
