<?php 
include('menu_cashier.php');
include_once 'model/stock_model.php';
include_once 'model/branch_model.php';

$stock_model     = new stock_model();
$branch_model = new branch_model();

$location   = $_GET['branch'] ?? 0;
$product_id = $_GET['product'] ?? 0;

// Default dates = current month
$start_date = $_GET['start'] ?? date("Y-m-01");
$end_date   = $_GET['end']   ?? date("Y-m-t");

$branchDetails = $branch_model->getBranchDetails($location);
$productDetails   = $stock_model->getProductDetails($product_id);

// Fetch stock sheet
$sheet = $stock_model->getProductStockSheet($location, $product_id, $start_date, $end_date);
?>
<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Powertex | Product Stock Sheet</title>

<link rel="icon" type="image/png" href="../finance/images/favicon.png">
<link rel="stylesheet" href="../includes/plugins/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="../includes/plugins/fontawesome/css/all.min.css">

<style>
    /* FORCE EVERYTHING TO SAME HEIGHT IN HEADER (Bootstrap 4 safe) */
    .header-bar .form-control,
    .header-bar .btn,
    .header-bar .input-group-text {
        height: 38px !important;
    }

    .header-bar {
        background: #fff;
        border-radius: 10px;
        padding: 12px;
        display: flex;
        flex-wrap: wrap;
        align-items: center;     /* Works in BS4 */
        justify-content: space-between;
    }

    .header-item {
        display: flex;
        align-items: center;     /* Vertical center alignment */
        margin-right: 10px;
        margin-bottom: 8px;
    }

    /* Responsive fix */
    @media(max-width: 992px){
        .header-bar {
            flex-direction: column;
            align-items: stretch;
        }
        .header-item {
            width: 100%;
            justify-content: space-between;
        }
    }
</style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">

    <!-- ====================== HEADER BAR ====================== -->
    <div class="header-bar">

    <!-- TITLE -->
    <div class="header-item flex-grow-1">
        <h4 class="mb-0 fw-bold">
            <i class="fas fa-file-alt text-primary"></i>
            Stock Sheet –
            <span class="text-primary"><?= htmlspecialchars($branchDetails['branch_name']) ?></span>
            –
            <span class="text-info"><?= htmlspecialchars($productDetails['product_name']) ?></span>
        </h4>
    </div>

    <!-- SEARCH -->
    <div class="header-item">
        <div class="input-group">
            <span class="input-group-text"><i class="fas fa-search"></i></span>
            <input type="text" id="filter_global" placeholder="Search…" class="form-control">
        </div>
    </div>

    <!-- DATE FILTER -->
    <form class="header-item" method="GET">
        <input type="hidden" name="warehouse" value="<?= $location ?>">
        <input type="hidden" name="product" value="<?= $product_id ?>">

        <div class="input-group mr-2">
            <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
            <input type="date" class="form-control" name="start" value="<?= $start_date ?>">
        </div>

        <div class="input-group mr-2">
            <span class="input-group-text"><i class="fas fa-calendar-check"></i></span>
            <input type="date" class="form-control" name="end" value="<?= $end_date ?>">
        </div>

        <button class="btn btn-primary"><i class="fas fa-filter"></i> Load</button>
    </form>

    <!-- RESET -->
    <a class="header-item btn btn-warning" 
       href="product_stock_sheet.php?warehouse=<?= $location ?>&product=<?= $product_id ?>">
        <i class="fas fa-undo"></i> Reset
    </a>

    <!-- BACK -->
    <a class="header-item btn btn-secondary" href="javascript:history.back()">
        <i class="fas fa-arrow-left"></i>
    </a>

</div>



    <!-- ====================== PRODUCT DETAILS ====================== -->
    <div class="card product-card">
        <div class="card-body">
            <h5>
                <i class="fas fa-box-open text-info"></i>
                <?= htmlspecialchars($productDetails['product_name']) ?>
                (<?= $productDetails['product_code'] ?>)
            </h5>

            <p class="mt-2">
                <i class="fas fa-tags text-primary"></i> <strong>Category:</strong> <?= $productDetails['categoryname'] ?>
                &nbsp; | &nbsp;
                <i class="fas fa-balance-scale text-warning"></i> <strong>Unit:</strong> <?= $productDetails['unitname'] ?>
                &nbsp; | &nbsp;
                <i class="fas fa-dollar-sign text-success"></i> <strong>Price:</strong> <?= number_format($productDetails['selling_price'], 2) ?>
            </p>
        </div>
    </div>


    <!-- ====================== TABLE ====================== -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover" id="sheetTable">
            <thead class="text-center">
                <tr>
                    <th><i class="fas fa-calendar-alt"></i> Date</th>
                    <th><i class="fas fa-box"></i> Product</th>
                    <th><i class="fas fa-tags"></i> Category</th>
                    <th><i class="fas fa-layer-group"></i> Opening</th>
                    <th><i class="fas fa-info-circle"></i> Description</th>
                    <th><i class="fas fa-sort-numeric-up"></i> Qty</th>
                    <th><i class="fas fa-check-circle"></i> Closing</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($sheet as $s): ?>
                <tr>
                    <td><?= date("d M Y, H:i", strtotime($s['date'])) ?></td>
                    <td><?= htmlspecialchars($productDetails['product_name']) ?></td>
                    <td><?= htmlspecialchars($productDetails['categoryname']) ?></td>
                    <td class="text-center"><?= $s['opening_stock'] ?></td>
                    <td><?= htmlspecialchars($s['description']) ?></td>
                    <td class="text-center 
                        <?php 
                            $desc = strtolower($s['description']);
                            echo ($desc == 'stock transfer in') 
                                ? 'bg-success text-white' 
                                : 'bg-danger text-white';
                        ?>
                    ">
                        <?= $s['quantity'] ?>
                    </td>

                    <td class="text-center fw-bold text-success"><?= $s['closing_stock'] ?></td>
                </tr>
                <?php endforeach; ?>

                <?php if(empty($sheet)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">No records found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>


<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<script>
    // GLOBAL SEARCH FILTER
    $(document).ready(function(){
        $("#filter_global").on("keyup", function(){
            let value = $(this).val().toLowerCase();
            $("#sheetTable tbody tr").filter(function(){
                $(this).toggle($(this).text().toLowerCase().includes(value));
            });
        });
    });
</script>

</body>
</html>
