<?php
include('menu_cashier.php');
include_once 'model/banking_model.php';

$banking_model = new banking_model();

// Fetch cancelled payments for dropdown
$cancelled_payments = $banking_model->getCancelledPayments($location);

// Handle form submission
$success = $error = '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || Capture Cash Expense</title>
    <link rel="icon" type="image/png" href="../finance/images/favicon.png">
    <link rel="stylesheet" href="../includes/plugins/bootstrap/css/bootstrap.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">

<div class="content-wrapper p-4">
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="row mb-3">
            <div class="col-sm-6">
                <h3 class="m-0 text-dark">
                    <i class="fas fa-money-bill-wave mr-2"></i>
                    Capture Cash Expense
                </h3>
            </div>
        </div>

        <!-- Messages -->
        <?php if($success): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>
        <?php if($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <!-- Expense Form -->
        <div class="card card-outline card-primary">
            <div class="card-body">
                <form method="POST" action="controllers/banks_controller.php">

                    <!-- Reference Number Dropdown -->
                    <div class="form-group">
                        <label for="reference_number">Reference (Cancelled Payments)</label>
                        <select name="reference_number" id="reference_number" class="form-control">
                            <option value="">-- Select Cancelled Payment --</option>
                            <?php foreach($cancelled_payments as $payment): ?>
                                <option value="<?= htmlspecialchars($payment['transaction_id']) ?>">
                                    <?= htmlspecialchars($payment['transaction_id']) ?> - <?= htmlspecialchars($payment['customer_name']) ?> - MWK <?= number_format($payment['amount'],2) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <small class="text-muted">Leave blank if not linked to a cancelled payment</small>
                    </div>

                    <!-- Expense Description -->
                    <div class="form-group">
                        <label for="expense_description">Expense Description/Reason</label>
                        <input type="text" name="expense_description" id="expense_description" class="form-control" required>
                    </div>

                    <!-- Expense Date -->
                    <div class="form-group">
                        <label for="expense_date">Expense Date</label>
                        <input type="date" name="expense_date" id="expense_date" class="form-control" max="<?= date('Y-m-d') ?>" value="<?= date('Y-m-d') ?>" required>
                    </div>

                    <!-- Amount Paid -->
                    <div class="form-group">
                        <label for="amount_paid">Amount Paid (MWK)</label>
                        <input type="number" step="0.01" min="0" name="amount_paid" id="amount_paid" class="form-control" required>
                    </div>

                    <!-- Hidden Fields -->
                    <input type="hidden" name="location" value="<?= $location ?>" readonly>
                    <input type="hidden" name="action" value="record_expense" readonly>

                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check-circle mr-1"></i> Record Expense
                    </button>

                </form>
            </div>
        </div>

    </div>
</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
<script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../includes/plugins/fontawesome-free/js/all.min.js"></script>
<script src="../includes/dist/js/adminlte.js"></script>
</body>
</html> 