<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Lookups\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;


class BucketContext extends InstanceContext
    {
    /**
     * Initialize the BucketContext
     *
     * @param Version $version Version that contains the resource
     * @param string $field bucket name
     * @param string $bucket bucket name
     */
    public function __construct(
        Version $version,
        $field,
        $bucket
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'field' =>
            $field,
        'bucket' =>
            $bucket,
        ];

        $this->uri = '/RateLimits/Fields/' . \rawurlencode($field)
        .'/Bucket/' . \rawurlencode($bucket)
        .'';
    }

    /**
     * Delete the BucketInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->delete('DELETE', $this->uri, [], [], $headers);
    }


    /**
     * Fetch the BucketInstance
     *
     * @return BucketInstance Fetched BucketInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): BucketInstance
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->fetch('GET', $this->uri, [], [], $headers);

        return new BucketInstance(
            $this->version,
            $payload,
            $this->solution['field'],
            $this->solution['bucket']
        );
    }


    /**
     * Update the BucketInstance
     *
     * @return BucketInstance Updated BucketInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): BucketInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $rateLimitRequest->toArray();
        $payload = $this->version->update('PUT', $this->uri, [], $data, $headers);

        return new BucketInstance(
            $this->version,
            $payload,
            $this->solution['field'],
            $this->solution['bucket']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Lookups.V2.BucketContext ' . \implode(' ', $context) . ']';
    }
}
