<?php
	session_start();
	//include 'model/customers_model.php';
	include_once 'model/company_model.php';
	include_once 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Company</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 24px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$company_model = new company_model();
			$common_model = new common_model();

			$locations = $common_model->getAllLocations();

		?>
		
		<form action="controllers/company_controller.php" method="post">	
			<center>
				<h2 class="page_titles">ADD NEW COMPANY <i class="fa fa-mug-hot"></i></h2>
				<hr>

				<!-- Company Name Input -->
				<input type="text" style="width: 320px; height:40px;" autocomplete="off" id="company_name" name="company_name" class="form-control" required placeholder="Enter Company Name">
				<span id="Error" style="color: red;"></span><br>

				<!-- Location Dropdown -->
				<select name="location" class="form-control" style="width: 320px;height:40px" required>
					<option value="" selected disabled>Select Location</option>
					<?php
						foreach($locations as $location):
					?>
						<option value="<?php echo $location['loc_id']; ?>"><?php echo $location['location_name']; ?></option>
					<?php
						endforeach;
					?>
				</select>
				<br>

				<!-- Contact Person Input -->
				<input type="text" name="contact_person" style="width: 320px; height:40px;" class="form-control" placeholder="Enter Contact Person" required><br>

				<!-- Email Address Input -->
				<input type="email" name="email" style="width: 320px; height:40px;" class="form-control" placeholder="Enter Email Address" required><br>

				<!-- Phone Number Input -->
				<input type="tel" name="phone_number" style="width: 320px; height:40px;" class="form-control" placeholder="Enter Phone Number" required><br>

				<!-- Hidden Action Field -->
				<input type="hidden" name="action" value="add_new_third_party_company" readonly>

				<!-- Save Button -->
				<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:322px;font-size: 18px;">SAVE COMPANY <i class="fa fa-save"></i></button>
			</center>
		</form>

	</body>
</html>