<?php
date_default_timezone_set('Africa/Blantyre');
session_start();

require_once 'model/companies_model.php';
require_once 'model/setup_model.php';

$companies_model = new companies_model();
$setup_model = new setup_model();

// Check procurement module status
$isProcurementEnabled = $setup_model->checkProcurement('procurement');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = $_POST['company_id'] ?? "";
    $product_ids = $_POST['product_ids'] ?? [];
    $opening_stock = $_POST['opening_stock'] ?? [];
    $order_price = $_POST['order_price'] ?? []; // May be missing if procurement is off
    $min_stock = $_POST['min_stock'] ?? [];
    $datecaptured = date('Y-m-d H:i:s');
    $operator = $_SESSION['sess_employeecode'] ?? 'system'; // fallback to avoid undefined error
    $product_state = 1;

    // ✅ Validate product selection
    if (!empty($product_ids)) {
        foreach ($product_ids as $pid_raw) {
            $pid = trim($pid_raw);

            $stock = isset($opening_stock[$pid]) ? (float)$opening_stock[$pid] : 0;
            $min_level = isset($min_stock[$pid]) ? (float)$min_stock[$pid] : 0;
            $price = $isProcurementEnabled ? (float)($order_price[$pid] ?? 0) : 0;

            // ✅ Save each product to third_party_products
            $companies_model->linkSingleProductToLocation(
                $company_id,
                $pid,
                $stock,       // quantity
                $stock,       // opening_stock
                $min_level,   // min_stock
                $price,       // order_price
                $datecaptured,
                $operator,
                $product_state
            );
        }

        // ✅ Success feedback
        $_SESSION['notification'] = [
            'type' => 'success',
            'title' => 'Success',
            'message' => 'Products attached successfully.'
        ];
        header("Location: third_party_products.php?company_id=" . urlencode($company_id));
        exit;

    } else {
        // ❌ No products selected
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Failed',
            'message' => 'Please select at least one product to attach.'
        ];
        header("Location: attach_third_party_products.php");
        exit;
    }
}
?>
