

<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/sales_model.php';
                        include_once 'model/customers_model.php';

                        $sales_model = new sales_model();
                        $customers_model = new customers_model();
                        $transaction_id = isset($_GET['id']) ? $_GET['id'] : '';

                        $receiptDetails = $sales_model->getReceiptData($transaction_id);
                        $sales_number = $receiptDetails['sale_id'];
                        $customer_id = $receiptDetails['customer'];
                        $receipt_items = $sales_model->getReceiptitems($sales_number);
                        $customerDetails = $customers_model->getCustomerDetails($customer_id);
                        

                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Sales </small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                            <!-- Left side: Customer Name -->
                                            <div>
                                                <h2 class="mb-0">Sales Receipt</h2>
                                            </div>
                                            <!-- Right side: Back Button -->
                                            <ul class="nav navbar-right panel_toolbox mb-0 d-flex align-items-center" style="gap: 8px;">
                                                <?php include 'components/action_buttons.php'; ?>
                                                <li>
                                                    <a class="dropdown-item" href="javascript:void(0);" onclick="history.back();">
                                                        <button class="btn btn-secondary btn-sm">
                                                            <i class="fa fa-arrow-left"></i> Back
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>

                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">
                                                        <div id="print-area"> 
                                                            <?php if ($receiptDetails['payment_state'] == 0): ?>
                                                                <div style=" position: absolute; top: 120px; left: 300px; right: 0; text-align: left; z-index: 1000; pointer-events: none; ">
                                                                    <span style=" display: inline-block; transform: rotate(-30deg); font-size: 50px; color: rgba(220, 53, 69, 0.3); font-weight: bold; border: 4px dashed rgba(220, 53, 69, 0.4); padding: 10px 40px; background-color: rgba(255, 255, 255, 0.2); ">CANCELLED PAYMENT</span>
                                                                </div>
                                                            <?php endif; ?>

                                                            <div class="x_panel" style="font-family: Arial, sans-serif; font-size: 14px; max-width: 1200px; margin: auto;">
                                                                <!-- Header Section -->
                                                                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 5px;">
                                                                    <div>
                                                                        <p style="margin: 0;"><strong>TPIN No.</strong> 20205854</p>
                                                                    </div>
                                                                    <div style="text-align: center;">
                                                                        <img src="images/logo.png" alt="Logo" style="height: 60px;"><br>
                                                                    </div>
                                                                    <div style="text-align: right;">
                                                                        <p style="margin: 0;"><strong>CASH SALE No.</strong> <?= $receiptDetails['receipt_number'] ?></p>
                                                                        <p style="margin: 0;"><strong>SOLAR DIVISION</strong></p>
                                                                        <p style="margin: 0;"><strong>Date:</strong> <?= date('d F Y', strtotime($receiptDetails['datecaptured'])) ?></p>
                                                                    </div>
                                                                </div>

                                                                <hr style="margin: 8px 0;">

                                                                <?php
                                                                    include_once 'general_header.php';
                                                                ?>

                                                                <hr style="margin: 10px 0;">

                                                                <!-- Customer -->
                                                                <p><strong><?= strtoupper($receiptDetails['customer_name']) ?></strong></p>

                                                                    <!-- Items Table -->
                                                                    <table class="table table-bordered" style="width: 100%; font-size: 13px; border-collapse: collapse;">
                                                                        <thead style="background: #f2f2f2;">
                                                                            <tr>
                                                                                <th style="text-align:center;">QTY</th>
                                                                                <th>DESCRIPTION</th>
                                                                                <th style="text-align:right;">@</th>
                                                                                <th style="text-align:right;">TOTAL</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php foreach ($receipt_items as $item): ?>
                                                                            <tr>
                                                                                <td style="text-align:center;"><?= $item['quantity'] ?></td>
                                                                                <td><?= $item['description'] ?></td>
                                                                                <td style="text-align:right;"><?= number_format($item['selling_price'], 2) ?></td>
                                                                                <td style="text-align:right;"><?= number_format($item['total'], 2) ?></td>
                                                                             </tr>
                                                                            <?php endforeach; ?>
                                                                        </tbody>
                                                                        <tfoot>
                                                                            <tr>
                                                                                <td colspan="3" style="text-align:right;"><strong>Total</strong></td>
                                                                                <td style="text-align:right;"><strong><?= number_format($receiptDetails['amount_paid'], 2) ?></strong></td>
                                                                            </tr>
                                                                        </tfoot>
                                                                    </table>

                                                                    <!-- Footer Info -->
                                                                    <p style="margin-top: 10px;"><strong>Payment Mode:</strong> <?= $receiptDetails['payment_method'] ?></p>
                                                                    <p><strong>Customer Tel:</strong> <?= $customerDetails['phone_number'] ?? 'N/A' ?></p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>

            <?php
                include_once 'libraries.php';
            ?>
            <script>
                function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
            </script>
        </body>
    </html>
