<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <link rel="icon" href="images/favicon.png" type="image/ico" />

            <title>Powertex LTD - Company Details</title>
            <?php include_once 'css_links.php'; ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">

                    <?php 
                        include 'menu_finance.php'; 
                        include_once 'model/common_model.php';  

                        $common_model = new common_model();
                        $locations = $common_model->getAllLocations();

                        
                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Company Profile</small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <?php
                                    
                                    include_once 'model/company_model.php';
                                    $company_model = new company_model();
                                    $company = $company_model->getCompanyDetails();

                                    $logoPath = !empty($company['logo']) ? "images/" . $company['logo'] : "images/default-logo.jpg";
                                    ?>

                                    <div class="x_title">
                                        
                                        <div class="clearfix"></div>
                                    </div>

                                    <div class="x_content">
                                        <div class="text-left mb-3">
                                            <button class="btn btn-success" data-toggle="modal" data-target="#editCompanyModal">
                                                <i class="fa fa-edit"></i> Update Details
                                            </button>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-9 col-sm-9 col-xs-12">
                                                <table class="table table-striped table-bordered" style="font-size: 14px;">
                                                    <tbody>
                                                        <tr>
                                                            <th>Registration Number</th>
                                                            <td><?= htmlspecialchars($company['company_id']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Company Name</th>
                                                            <td><?= htmlspecialchars($company['company_name']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>TPIN</th>
                                                            <td><?= htmlspecialchars($company['tpin']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Location</th>
                                                            <td><?= htmlspecialchars($company['location_name']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Address</th>
                                                            <td><?= htmlspecialchars($company['address']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Phone Number</th>
                                                            <td><?= htmlspecialchars($company['phone_number']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Alternate Phone Number</th>
                                                            <td><?= !empty($company['company_phone2']) ? htmlspecialchars($company['company_phone2']) : 'Not Available' ?></td>

                                                        </tr>
                                                        <tr>
                                                            <th>Email</th>
                                                            <td><?= htmlspecialchars($company['email']) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <th>Website</th>
                                                            <td><a href="<?= htmlspecialchars($company['website']) ?>" target="_blank"><?= htmlspecialchars($company['website']) ?></a></td>
                                                        </tr>
                                                        
                                                        <tr>
                                                            <th>Director's Signature</th>
                                                            <td>
                                                                <?php if (!empty($company['directors_signature']) && file_exists("signatures/" . $company['directors_signature'])): ?>
                                                                    <img src="signatures/<?= $company['directors_signature'] ?>" alt="Signature" style="height: 60px;">
                                                                <?php else: ?>
                                                                    <span class="text-muted">Not Available</span>
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-3 col-sm-3 col-xs-12 text-center">
                                                <div class="profile_img">
                                                    <div id="crop-avatar">
                                                        <img class="img-fluid img-thumbnail" src="<?= $logoPath ?>" alt="Company Logo">
                                                    </div>
                                                    <h4 class="mt-3"><?= htmlspecialchars($company['company_name']) ?></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <?php 
                        include_once 'footer.php'; 
                    ?>
                </div>
            </div>

            <?php 
                include_once 'libraries.php'; 
            ?>
            <!-- ADDED: Modal for editing company details -->
            <div class="modal fade" id="editCompanyModal" tabindex="-1" role="dialog" aria-labelledby="editCompanyModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <form action="controllers/company_controller.php" method="POST" enctype="multipart/form-data">
                        <div class="modal-content">
                            <div class="modal-header bg-success text-white">
                                <h5 class="modal-title" id="editCompanyModalLabel">Edit Company Details</h5>
                                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <div class="modal-body">
                                <div class="row">
                                    <!-- Left Column -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Company ID/Registration Number</label>
                                            <input type="text" name="company_id" class="form-control" value="<?= htmlspecialchars($company['company_id']) ?>">
                                        </div>

                                        <div class="form-group">
                                            <label>Company Name</label>
                                            <input type="text" name="company_name" class="form-control" value="<?= htmlspecialchars($company['company_name']) ?>" required>
                                            <input type="hidden" name="action" value="update_company_details" readonly>
                                        </div>
                                        <div class="form-group">
                                            <label>TPIN</label>
                                            <input type="text" name="tpin" class="form-control" value="<?= htmlspecialchars($company['tpin']) ?>">
                                        </div>
                                        <div class="form-group">
                                            <label>Location</label>
                                            <select name="location" class="form-control" required>
                                                <option selected value="<?php echo htmlspecialchars($company['location'])?>"><?php echo htmlspecialchars($company['location_name'])?></option>
                                                <?php
                                                    foreach($locations as $loca):
                                                        if($company['location']!=$loca['loc_id']):
                                                ?>
                                                    <option value="<?php echo $loca['loc_id']?>"><?php echo $loca['location_name']?></option>
                                                <?php
                                                        endif;
                                                    endforeach;
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <?php
                                            $mainPhone = preg_replace('/^\+265/', '', $company['phone_number']);
                                            $altPhone  = preg_replace('/^\+265/', '', $company['company_phon2']);
                                        ?>

                                        <div class="form-group">
                                            <label>Phone Number</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">+265</span>
                                                </div>
                                                <input type="text" id="phone_number" name="phone_number" class="form-control" value="<?= htmlspecialchars($mainPhone) ?>" maxlength="9" required>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Alternate Phone Number</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">+265</span>
                                                </div>
                                                <input type="text" id="alt_phone_number" name="company_phone2" class="form-control" value="<?= htmlspecialchars($altPhone) ?>" maxlength="9" placeholder="Enter Alternative Phone Number">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Right Column -->
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Address</label>
                                            <input type="text" name="address" class="form-control" value="<?= htmlspecialchars($company['address']) ?>">
                                        </div>
                                                    
                                        <div class="form-group">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($company['email']) ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Website</label>
                                            <?php
                                                $website = $company['website'];
                                                if (!empty($website) && !preg_match('/^https?:\/\//', $website)) {
                                                    $website = 'https://' . $website;
                                                }
                                            ?>

                                            <input type="url" name="website" class="form-control" value="<?= htmlspecialchars($website) ?>" required>

                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Company Logo</label>
                                            <input type="file" name="logo" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label>Director Signature</label>
                                            <input type="file" name="directors_signature" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                    
                            <div class="modal-footer">
                                <input type="hidden" name="id" value="<?= $company['id'] ?>">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <script>
                function sanitizePhoneInput(input) {
                    input.value = input.value.replace(/\D/g, '').slice(0, 9); // Remove non-digits, max 9
                }

                document.getElementById('phone_number').addEventListener('input', function () {
                    sanitizePhoneInput(this);
                });

                document.getElementById('alt_phone_number').addEventListener('input', function () {
                    sanitizePhoneInput(this);
                });
            </script>

        </body>
    </html>
