<?php
session_start();
include_once '../model/branch_model.php';
include_once '../model/employees_model.php';

$employees_model = new employees_model();
$branch_model = new branch_model();

// Check if form was submitted and action is set
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['edit_branch']) && $_POST['edit_branch'] === 'edit_branch') {
        editBranch($branch_model, $employees_model);
    }

    
}

function editBranch($branch_model, $employees_model) {
    $branch_id   = $_POST['branch_id'] ?? null;
    $branch_name = trim($_POST['branch_name'] ?? '');
    $shop_manager     = $_POST['manager'] ?? null;
    $location       = $_POST['location'] ?? null;

    if ($branch_id && $branch_name && $shop_manager && $location) {

         if ($branch_model->doesLocationExistExcludingBranch($location, $branch_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Location',
                'message' => 'We already Have a branch in the selected location.'
            ];
            header('Location: ../manage_branches.php');
            exit();
        }

        // Check supervisor uniqueness excluding current warehouse
        if ($branch_model->isManagerInAnotherWarehouseExcludingCurrent($shop_manager, $branch_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Roles',
                'message' => 'This sales assistant  is already assigned to a different branch/warehouse.'
            ];
            header('Location: ../manage_branches.php');
            exit();
        }

        if (!$employees_model->isActiveEmployee($shop_manager)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Inactive Employee',
                'message' => 'Selected shop manager is not an active employee.'
            ];
            header('Location: ../manage_branches.php');
            exit();
        }

        $warehouseData = $branch_model->getWarehouseBySupervisor($shop_manager);

        if ($warehouseData) {
            $warehouseLocation = $warehouseData['location'];
            $warehouseState = $warehouseData['warehouse_state'];

            // If branch is active but location differs, block the update
            if ($warehouseState == 1 && $warehouseLocation !== $location) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Supervisor Conflict',
                    'message' => 'This employee is already a Supervisor in a different location. A supervisor/shop manager must belong to the same location.'
                ];
                header('Location: ../manage_branches.php');
                exit();
            }
        }

        if ($branch_model->doesBranchNameExistExcludingCurrent($branch_name, $branch_id)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Duplicate Branch Name',
                'message' => 'This branch name is already in use. Please choose a different name.'
            ];
            header('Location: ../manage_branches.php');
            exit();
        }


        $success = $branch_model->updatebranch($branch_id, $branch_name, $shop_manager, $location);

        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Success',
                'message' => 'Branch details updated successfully.'
            ];
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Failed',
                'message' => 'Failed to update branch details.'
            ];
        }
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'Invalid Input',
            'message' => 'Please fill in all required fields.'
        ];
    }

    header('Location: ../manage_branches.php');
    exit();
}
