<?php
    session_start();
    include_once '../model/users_model.php';
    include_once '../model/employees_model.php';
    include_once '../model/common_model.php';

    $users_model = new users_model();
    $employees_model = new employees_model();
    $common_model = new common_model();

    require_once '../vendor/phpmailer/phpmailer/src/Exception.php';
    require_once '../vendor/phpmailer/phpmailer/src/PHPMailer.php';
    require_once '../vendor/phpmailer/phpmailer/src/SMTP.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;

    

    // Now process the action
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        $post_action = $_POST['action'];

        switch ($post_action) {
            case 'add_new_user':
                addNewUser($users_model, $employees_model);
            break;
            
            case 'update_user':
                updateuserRole($users_model);
            break;

            case 'change_location':
                changeAssignedLocation($users_model, $employees_model, $common_model);
            break;

            case 'change_password':
                changeUserPassword($users_model, $employees_model);
            break;

            case'check_username':
                checkUsername($users_model);
                break;

            default:
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Unknown Action',
                    'message' => 'The requested action is not recognized.'
                ];
                header('Location: ../system_users.php');
                exit();
        }
    }
    function checkUsername($users_model){
        $username = trim($_POST['username']);
        $exists = $users_model->usernameExists($username);

        echo json_encode([
            'exists' => $exists
        ]);
        exit;
    }

    function changeUserPassword($users_model, $employees_model) {
        $employee_code = (int) ($_POST['employee_code'] ?? 0);
        $current_password = $_POST['current_password'] ?? '';
        $new_password = $_POST['new_password'] ?? '';
        $username = $_SESSION['sess_username'];

        $exempted_codes = [2000, 2001, 2002, 2003];

        // 1. Validate input
        if (!$employee_code || !$current_password || !$new_password || !$username) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'All fields are required to change password.'
            ];
            header('Location: ../change_pass.php');
            exit();
        }

        if (!in_array($employee_code, $exempted_codes)) {
            $user = $employees_model->getUserByEmployeeCode($employee_code);
            
            if (!$user) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'User Not Found',
                    'message' => 'User record not found.'
                ];
                header('Location: ../change_pass.php');
                exit();
            }
        }

        $hashed_password_old = $users_model->getPasswordByUsername($username);

        // 3. Verify current password
        if (!password_verify($current_password, $hashed_password_old)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Password Error',
                'message' => 'The current password is incorrect.'
            ];
            header('Location: ../change_pass.php');
            exit();
        }

        // 4. Prevent reusing the same password
        if (password_verify($new_password, $hashed_password_old)) {
            $_SESSION['notification'] = [
                'type' => 'warning',
                'title' => 'Unchanged Password',
                'message' => 'The new password cannot be the same as the old password.'
            ];
            header('Location: ../change_pass.php');
            exit();
        }

        // 5. Hash and update new password
        $hashed_password = password_hash($new_password, PASSWORD_BCRYPT);
        $result = $users_model->updateUserPassword($username, $hashed_password);

        if ($result) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Password Changed',
                'message' => 'Your password has been updated successfully.'
            ];
             header('Location: ../dashboard.php');
            exit();
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Update Failed',
                'message' => 'An error occurred while updating your password.'
            ];
             header('Location: ../change_pass.php');
            exit();
        }
    }


    function changeAssignedLocation($users_model, $employees_model, $common_model){
        $employee_code = (int) $_POST['employee_code']; // Cast to integer
        $new_location_id = trim($_POST['new_location']); // Clean up whitespace
        $current_location = trim($_POST['current_location']);


        if (empty($_POST['employee_code']) || empty($_POST['new_location'])) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Fields',
                'message' => 'Employee code and new location are required.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        $user = $employees_model->getUserByEmployeeCode($employee_code);
        if (!$user) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'User Not Found',
                'message' => 'No user found with the given employee code.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        $location = $common_model->verifyLocation($new_location_id);
        if (!$location) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Invalid Location',
                'message' => 'Selected location is not valid.'
            ];  
            header('Location: ../system_users.php');
            exit();
        }

        if ($current_location == $new_location_id) {
            $_SESSION['notification'] = [
                'type' => 'warning',
                'title' => 'No Change Detected',
                'message' => "There's no change in the previous location and the selected location."
            ];
            header('Location: ../system_users.php');
            exit();
        }

        // Check if the location has a warehouse and branch
        $has_warehouse = $users_model->locationHasWarehouse($new_location_id);
        $has_branch = $users_model->locationHasBranch($new_location_id);

        if (!$has_warehouse && !$has_branch) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Invalid Location',
                'message' => 'The selected location does not have either a warehouse or a branch.'
            ];
            header('Location: ../system_users.php');
            exit();
        }elseif($has_warehouse && !$has_branch){
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Transfer Failed',
                'message' => 'Invalid Command Initiated'
            ];
            header('Location: ../system_users.php');
            exit();
        }elseif($has_branch && !$has_warehouse){
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Transfer Failed',
                'message' => 'Invalid Command Initiated'
            ];
            header('Location: ../system_users.php');
            exit();
        }elseif($has_branch && $has_warehouse){
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Transfer Failed',
                'message' => 'Invalid Command Initiated'
            ];
            header('Location: ../system_users.php');
            exit();
        }else{
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Transfer Failed',
                'message' => 'Invalid Command Initiated'
            ];
            header('Location: ../system_users.php');
            exit();
        }

    }

    function updateuserRole($users_model) {
        // Sanitize and retrieve input
        $username = $_POST['username'] ?? '';
        $employee_code = $_POST['employee_code'] ?? '';
        $new_role = $_POST['new_role'] ?? '';
        $current_role = $_POST['current_role'] ?? '';
        $new_location = $_POST['new_role_location'] ?? null;

        // Basic validation
        if (empty($username) || empty($new_role)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'Username and new role are required.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        // If role hasn't changed
        if ($new_role === $current_role) {
            $_SESSION['notification'] = [
                'type' => 'warning',
                'title' => 'No Change',
                'message' => 'The selected role is the same as the current role.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        // For roles that require a location
        $rolesRequiringLocation = ['Supervisor', 'Cashier'];
        if (in_array($new_role, $rolesRequiringLocation)) {
            if (empty($new_location)) {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Missing Location',
                    'message' => 'Please select a location for the new role.'
                ];
                header('Location: ../system_users.php');
                exit();
            }
        } else {
            $new_location = null; // Reset if role doesn't need it
        }

        if (!$users_model->validateEmployeeLocation($employee_code, $new_role, $new_location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Location Mismatch',
                'message' => 'The selected location does not<br>match  the employee’s assigned location.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        // Proceed to update
        $success = $users_model->updateRole($username, $new_role);

        if ($success) {
            $_SESSION['notification'] = [
                'type' => 'success',
                'title' => 'Role Updated',
                'message' => "The user's role has been successfully updated."
            ];
        } else {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Update Failed',
                'message' => 'An error occured!!. Please try again.'
            ];
        }

        header('Location: ../system_users.php');
        exit();
    }
  

    function addNewUser($users_model, $employees_model) {

        

        $system_role = trim($_POST['system_role']);
        $location = isset($_POST['location']) ? trim($_POST['location']) : null;
        $employee_code = (int) trim($_POST['employee_code']);
        $raw_phone = trim($_POST['phone_number']);
        $phone_number = (strpos($raw_phone, '+265') === 0) ? $raw_phone : '+265' . ltrim($raw_phone, '0');
        $email = trim($_POST['email']);
        $username = trim($_POST['username']);
        $operator = $_SESSION['sess_employeecode'];

        $employeeDetails = $employees_model->getEmployeeDetails($employee_code);
        if (!$employeeDetails) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Employee Not Found',
                'message' => 'Could not find the employee details for the provided code.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        $employee_name = $employeeDetails['fullname'];


        // Validate required fields
        if (empty($system_role) || empty($employee_code) || empty($username)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Missing Data',
                'message' => 'Please fill in all required fields.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        if(!$users_model->checkemployee($employee_code)){
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FATAL ERROR',
                'message' => 'Unrecognised Action.<br> Please login Again'
            ];
            header('Location:../../index.php');
            exit();
        }


        if ($users_model->checkuser($username)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Username Exists',
                'message' => 'This username is already taken.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

          
        // ✅ New Condition: Location must exist as branch or warehouse based on role
        if ($system_role === 'Cashier' && !$users_model->isBranchLocation($location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Invalid Branch',
                'message' => 'The selected location does not have a valid branch'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        if ($system_role === 'Supervisor' && !$users_model->isWarehouseLocation($location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Invalid Warehouse',
                'message' => 'The selected location does not have a warehouse for supervisors.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        if ($users_model->employeeRoleExists($employee_code, $system_role, $location)) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'Role Exists',
                'message' => 'This employee is already assigned to the selected role.'
            ];
            header('Location: ../system_users.php');
            exit();
        }

        function generatePassword($length = 8) {
            $letters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $numbers = '123456789';
            $special = '#';

            $pass = '';
            $pass .= $numbers[rand(0, strlen($numbers) - 1)];
            $pass .= $numbers[rand(0, strlen($numbers) - 1)];
            $pass .= $special[rand(0, strlen($special) - 1)];

            $remainingLength = $length - 3;
            $allCharacters = $letters . $numbers . $special;
            for ($i = 0; $i < $remainingLength; $i++) {
                $pass .= $allCharacters[rand(0, strlen($allCharacters) - 1)];
            }

            return str_shuffle($pass);
        }

        $password = generatePassword();
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
        
        try {
            if (empty($email)) {
                throw new Exception("Email address is missing. Cannot proceed.");
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Missing Email',
                    'message' => 'Email address is missing. Cannot proceed.'
                ];
                header('Location: ../system_users.php');
                exit();
            }

            $mail = new PHPMailer(true);
            $mail->isSMTP();
            $mail->Host = 'poweronline-mw.com';
            $mail->SMTPAuth = true;
            $mail->SMTPDebug = 0;
            $mail->Username = 'noreply@smartplus-mw.com';
            $mail->Password = '#2024!@EMAIL';
            $mail->SMTPSecure = ''; // or 'tls'
            $mail->Port = 587;

            $mail->setFrom('noreply@smartplus-mw.com', 'Powertex Ltd');
            $mail->addAddress($email, $employee_name);
            $mail->isHTML(true);
            $mail->Subject = 'Account Activated';
            $mail->Body = "<h1>Welcome, $employee_name</h1>
                        <p>Your account has been created with the following credentials:</p>
                        <p><b>USERNAME:</b> $username</p>
                        <p><b>PASSWORD:</b> $password</p>
                        <p>Please change your password after logging in for security reasons.</p>
                        <p>Email Generated From Smart Plus Essentials</p>";

            if (!$mail->send()) {
                throw new Exception("Failed to send email: " . $mail->ErrorInfo);
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'Failed to Send Email',
                    'message' => 'Failed to send email:' . $mail->ErrorInfo
                ];
                header('Location: ../system_users.php');
                exit();

            }

            // Email sent successfully, now create the user
            $result = $users_model->createUser(['employee_code' => $employee_code, 'username' => $username, 'password' => $hashed_password, 'system_role' => $system_role, 'phone_number' => $phone_number, 'location' => $location]);

            $_SESSION['notification'] = [
                'type' => 'info',
                'title' => 'SUCCESS',
                'message' => "Account Successfully Created.<br>Username & Password sent to $email"
            ];

        } catch (Exception $e) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED!',
                'message' => "Error during user creation:<br>" . $e->getMessage()
            ];
        }

        header("Location: ../system_users.php");
        exit();


    }

?>
