<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <!-- Meta, title, CSS, favicons, etc. -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
                <link rel="icon" href="images/favicon.png" type="image/ico" />
            <title>Powertex LTD</title>
            <?php
                include_once 'css_links.php';
            ?>
        </head>

        <body class="nav-md">
            <div class="container body">
                <div class="main_container">
            
                    <?php
                        include 'menu_finance.php';
                        include_once 'model/customers_model.php';

                        $customers_model = new customers_model();
                        $customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : '';

                        $customerDetails = $customers_model->getCustomerDetails($customer_id);
                        $lastdate = $customers_model->getLastTransactionDate($customer_id);

                        $transactions = $customers_model->getCustomerTransactions($customer_id);

                    ?>
                    <!-- page content -->
                    <div class="right_col" role="main">
                        <div class="">
                            <div class="page-title">
                                <div class="title_left">
                                    <h3><small>Customers </small></h3>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row">
                                <div class="col-md-12 col-sm-12 ">
                                    <div class="x_panel">
                                        <div class="x_title">
                                            <h2>Customer Details</h2>
                                            <ul class="nav navbar-right panel_toolbox d-flex align-items-center" style="gap: 8px;">
                                                <li class="nav-item">
                                                    <button class="btn btn-warning btn-sm editCustomerBtn"
                                                        data-id="<?= $customerDetails['customer_id'] ?>"
                                                        data-name="<?= htmlspecialchars($customerDetails['customer_name']) ?>"
                                                        data-number="<?= $customerDetails['phone_number'] ?>"
                                                        data-email="<?= $customerDetails['email'] ?>"
                                                        data-gender="<?= $customerDetails['gender'] ?>"
                                                        data-address="<?= $customerDetails['customer_address'] ?>"
                                                        data-location="<?= $customerDetails['location'] ?>"
                                                        data-type="<?= $customerDetails['type_customer'] ?>"
                                                        data-location_name="<?= $customerDetails['location_name'] ?>"
                                                        data-nationality_id="<?= $customerDetails['nationality_id'] ?>"
                                                        data-nationality_name="<?= $customerDetails['nationality_name'] ?>"
                                                        data-whatsapp_number="<?= $customerDetails['whatsapp_number'] ?>"
                                                        data-state="<?= $customerDetails['customer_state'] ?>"
                                                        title="Update Customer Details">
                                                        <i class="fa fa-edit"></i> Update Customer
                                                    </button>
                                                </li>
                                                <li class="nav-item">
                                                    <button  class="btn btn-secondary btn-sm" onclick="history.back();">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </a>
                                                </li>
                                            </ul>

                                            <div class="clearfix"></div>
                                        </div>
                                        <div class="x_content">
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="card-box table-responsive">
                                                        <table class="table table-bordered" style="font-family: Times;font-size:17px">
                                                            <tr>
                                                                <td><strong>Customer Name</strong></td>
                                                                <td><?php echo $customerDetails['customer_name'] ?></td>
                                                                <td><strong>Phone Number</strong></td>
                                                                <td><?php echo $customerDetails['phone_number'] ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong>Type of Customer</strong></td>
                                                                <td><?php echo $customerDetails['type_customer'] ?></td>
                                                                <td><strong>SPECIAL WHATSAPP NUMBER</strong></td>
                                                                <td>
                                                                    <?php
                                                                        if (!empty($customerDetails['whatsapp_number'])) {
                                                                            echo htmlspecialchars($customerDetails['whatsapp_number']);
                                                                        } else {
                                                                            echo '<span class="text-muted">Number Not Set</span>';
                                                                        }
                                                                    ?>
                                                                </td>

                                                            </tr>
                                                            <tr>
                                                                <td><strong>Email Address</strong></td>
                                                                <td><?php echo $customerDetails['email'] ?></td>
                                                                <td><strong>Postal Address</strong></td>
                                                                <td><?php echo $customerDetails['customer_address'] ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><strong>Gender</strong></td>
                                                                <td><?php echo $customerDetails['gender'] ?></td>
                                                                <td><strong>Location  of Residence</strong></td>
                                                                <td><?php echo $customerDetails['location_name'] ?></td>
                                                            </tr>

                                                            <tr>
                                                                <td><strong>Country of Origin</strong></td>
                                                                <td><?php echo $customerDetails['country_name'] ?></td>
                                                                <td><strong>Nationality</strong></td>
                                                                <td><?php echo $customerDetails['nationality'] ?></td>
                                                            </tr>
                                                            
                                                            
                                                            
                                                            <tr>
                                                                <td><strong>Customer State</strong></td>
                                                                <?php
                                                                    $status = $customerDetails['customer_state'];
                                                                    $bgClass = '';

                                                                    if ($status == 1) {
                                                                        $bgClass = 'bg-success text-white';
                                                                    } elseif ($status == 0) {
                                                                        $bgClass = 'bg-danger text-white';
                                                                    } elseif ($status == 3) {
                                                                        $bgClass = 'bg-warning';
                                                                    }
                                                                ?>

                                                                <td class="<?php echo $bgClass; ?>">
                                                                    <?php echo $customerDetails['customer_status']; ?>
                                                                </td>
                                                                <td><strong>Last Transaction</strong></td>
                                                                <td>
                                                                    <?php if (!empty($lastdate['datecaptured'])): ?>
                                                                        <?php
                                                                            $formattedDate = date('d F Y H:i', strtotime($lastdate['datecaptured']));
                                                                            $link = '#';
                                                                            $label = '';

                                                                            switch ($lastdate['source']) {
                                                                                case 'cash_sale':
                                                                                    $link = 'cash_sale_receipt.php?id=' . urlencode($lastdate['transaction_id']);
                                                                                    $label = 'Cash Sale Receipt';
                                                                                    break;

                                                                                case 'customer_order':
                                                                                    $link = 'invoice_payment_receipt.php?receipt_number=' . urlencode($lastdate['receipt_number']);
                                                                                    $label = 'Payment Receipt';
                                                                                    break;

                                                                                case 'saved_orders':
                                                                                    $link = 'invoice.php?invoice_number=' . urlencode($lastdate['transaction_id']);
                                                                                    $label = 'Invoice';
                                                                                    break;

                                                                                default:
                                                                                    $label = 'Unknown';
                                                                                    break;
                                                                            }
                                                                        ?>
                                                                        <a href="<?= $link ?>" class="btn btn-sm btn-info" title="View <?= $label ?>">
                                                                            <i class="fa fa-list"></i>
                                                                            View Transaction (Last Date - <?= $formattedDate ?>)
                                                                        </a>
                                                                    <?php else: ?>
                                                                        No transactions yet
                                                                    <?php endif; ?>
                                                                </td>



                                                            </tr>

                                                            <tr>
                                                                <td><strong>Date Account Opened</strong></td>
                                                                <td><?php echo date('d F Y',strtotime($customerDetails['datecreated'])) ?></td>
                                                                <td><strong>Customer Added By</strong></td>
                                                                <td><?php echo $customerDetails['operator'] ?></td>
                                                            </tr>
                                                        </table>  
                                                        <?php
                                                        if ($customers_model->hasTransactions($customer_id)) { ?>
                                                            <table class="table table-bordered">
                                                                <thead class="bg-info text-white">
                                                                    <tr>
                                                                        <th>Date</th>
                                                                        <th>Transaction Type</th>
                                                                        <th>Reference Number</th>
                                                                        <th>Operator</th>
                                                                        <th>Sales</th>
                                                                        <th>Payments</th>
                                                                        <th>Status</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php foreach ($transactions as $data) { ?>
                                                                        <tr>
                                                                            <td><?php echo date('d F Y H:i', strtotime($data['date_captured'])); ?></td>
                                                                            <td><?php echo htmlspecialchars($data['activity']); ?></td>
                                                                            <td><?php echo htmlspecialchars($data['reference_number']); ?></td>
                                                                            <td><?php echo htmlspecialchars($data['operator']); ?></td>
                                                                            <td style="text-align: right;">
                                                                                <?php echo number_format($data['sales_amount'], 2); ?>
                                                                            </td>
                                                                            
                                                                            <td style="text-align: right;">
                                                                                <?php echo number_format($data['payments_amount'], 2); ?>
                                                                            </td>
                                                                            <td class="
                                                                                <?php
                                                                                    $state = $data['state'];
                                                                                    $source = $data['source'];

                                                                                    if ($source === 'cash_sale') {
                                                                                        switch ($state) {
                                                                                            case 0:
                                                                                                echo 'bg-danger text-white'; // Declined
                                                                                                break;
                                                                                            case 1:
                                                                                                echo 'bg-success text-white'; // Success
                                                                                                break;
                                                                                            default:
                                                                                                echo '';
                                                                                        }
                                                                                    } elseif ($source === 'invoice') {
                                                                                        switch ($state) {
                                                                                            case 0:
                                                                                                echo 'bg-secondary text-dark'; // Unpaid
                                                                                                break;
                                                                                            case 1:
                                                                                                echo 'bg-warning text-dark'; // Partial
                                                                                                break;
                                                                                            case 2:
                                                                                                echo 'bg-success text-white'; // Full
                                                                                                break;
                                                                                            case 3:
                                                                                                echo 'bg-danger text-white'; // Cancelled
                                                                                                break;
                                                                                            default:
                                                                                                echo '';
                                                                                        }
                                                                                    }elseif ($source === 'invoice_payment') {
                                                                                        switch ($state) {
                                                                                            case 0:
                                                                                                echo 'bg-danger text-white'; // Unpaid
                                                                                                break;
                                                                                            case 1:
                                                                                                echo 'bg-success text-white'; // Partial
                                                                                                break;
                                                                                            default:
                                                                                                echo '';
                                                                                        }
                                                                                    }
                                                                                ?>
                                                                            ">
                                                                                <?php echo htmlspecialchars($data['transaction_status']); ?>
                                                                            </td>

                                                                        </tr>
                                                                    <?php } ?>
                                                                </tbody>
                                                            </table>
                                                        <?php } ?>                                                      
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /page content -->

                    <!-- Edit Customer Modal -->
                    <div class="modal fade" id="editCustomerModal" tabindex="-1" role="dialog" aria-labelledby="editCustomerLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <form id="editCustomerForm" method="POST" action="controllers/customer_controller.php">
                                <div class="modal-content">
                                    <div class="modal-header bg-warning">
                                        <h5 class="modal-title text-dark" id="editCustomerLabel">Edit Customer Details</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span>&times;</span>
                                        </button>
                                    </div>
                            
                                    <div class="modal-body row">
                                        <input type="hidden" name="customer_id" id="edit_customer_id">
                                        <input type="hidden" name="action" value="update_customer">

                                        <div class="form-group col-md-6">
                                            <label>Customer Name</label>
                                            <input type="text" class="form-control" name="customer_name" id="edit_customer_name" required>
                                        </div>

                                        

                                        <div class="form-group col-md-6">
                                            <label>Email Address</label>
                                            <input type="email" class="form-control" name="email" id="edit_email">
                                        </div>


                                        <div class="form-group col-md-6">
                                            <label>Contact Number</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">+265</span>
                                                </div>
                                                <input type="text" class="form-control" maxlength="9" minlength="5" name="contact_number" id="edit_contact_number" placeholder="991234567">
                                            </div>
                                        </div>

                                        

                                        <div class="form-group col-md-6">
                                            <label>Special Whatsapp Number</label>
                                            <input type="text" class="form-control" name="whatsapp_number" id="edit_whatsapp_number">
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Gender</label>
                                            <select class="form-control" name="gender" id="edit_gender">
                                                <option value="Male">Male</option>
                                                <option value="Female">Female</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Customer Address</label>
                                            <input type="text" class="form-control" name="customer_address" id="edit_customer_address">
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Location</label>
                                            <select class="form-control" name="location" id="edit_location">
                                            <!-- Dynamically populate this using PHP or JS -->
                                            </select>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Type of Customer</label>
                                            <select class="form-control" name="type_customer" id="edit_type_customer">
                                                <option value="Retail">Retail</option>
                                                <option value="Wholesale">Wholesale</option>
                                                <option value="Corporate">Corporate</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Nationality</label>
                                            <select class="form-control" name="nationality" id="edit_nationality">
                                            <!-- Dynamically populate this using PHP or JS -->
                                            </select>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label>Customer State</label>
                                            <select class="form-control" name="customer_state" id="edit_customer_state">
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-warning">Update Customer</button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                        include_once 'footer.php';
                    ?>
                </div>
            </div>
            <?php
                include_once 'libraries.php';
            ?>
            <script>
                $(document).on('click', '.editCustomerBtn', function () {
                    const locationId = $(this).data('location');
                    const locationName = $(this).data('location_name');
                    const currentType = $(this).data('type');
                    const nationalityId = $(this).data('nationality_id');
                    const nationalityName = $(this).data('nationality_name');
                    const allTypes = ['Dealer', 'Walk In Customer', 'Corporate Customers'];
                    const customerState = $(this).data('state'); // either 1 or 0
                    let contact = $(this).data('number').replace(/^(\+265)/, ''); // strip +265 if present
                    $('#edit_contact_number').val(contact);

                    let stateOptions = '';

                    if (customerState == 1) {
                        stateOptions = `
                            <option selected hidden value="1">Active Customer</option>
                            <option value="0">Deactivate Customer</option>`;
                    } else {
                        stateOptions = `
                            <option selected hidden value="0">Deactivated Customer</option>
                            <option value="1">Activate Customer</option>`;
                    }

                    $('#edit_customer_state').html(stateOptions);

                    // Set default selected location as the first option
                    $('#edit_location').html(`<option selected hidden value="${locationId}">${locationName}</option>`);

                    // ✅ Now this works correctly
                    $('#edit_nationality').html(`<option selected hidden value="${nationalityId}">${nationalityName}</option>`);
                    
                    // Load other locations via AJAX
                    $.ajax({
                        url: 'get_locations.php',
                        method: 'GET',
                        success: function (data) {
                            const options = JSON.parse(data);
                            let locationOptions = '';

                            options.forEach(function (loc) {
                                if (loc.loc_id != locationId) {
                                    locationOptions += `<option value="${loc.loc_id}">${loc.location_name}</option>`;
                                }
                            });

                            $('#edit_location').append(locationOptions);
                        }
                    });

                    // Load other nationalities via AJAX
                    $.ajax({
                        url: 'get_nationalities.php',
                        method: 'GET',
                        success: function (data) {
                            const nations = JSON.parse(data);
                            let options = '';
                            nations.forEach(function (nat) {
                                if (nat.id !== nationalityId) {
                                    options += `<option value="${nat.id}">${nat.nationality}</option>`;
                                }
                            });
                            $('#edit_nationality').append(options);
                        }
                    });

                    // Populate Type of Customer
                    let typeOptions = `<option selected value="${currentType}">${currentType}</option>`;
                    allTypes.forEach(function(type) {
                        if (type !== currentType) {
                            typeOptions += `<option value="${type}">${type}</option>`;
                        }
                    });
                    $('#edit_type_customer').html(typeOptions);

                    // Populate remaining fields
                    $('#edit_customer_id').val($(this).data('id'));
                    
                    $('#edit_customer_name').val($(this).data('name'));
                    $('#edit_location_name').val($(this).data('location_name'));
                    $('#edit_email').val($(this).data('email'));
                    $('#edit_gender').val($(this).data('gender'));
                    $('#edit_customer_address').val($(this).data('address'));
                    $('#edit_location').val($(this).data('location'));
                    $('#edit_customer_state').val($(this).data('state'));
                    $('#edit_whatsapp_number').val($(this).data('whatsapp_number'));
                    $('#editCustomerModal').modal('show');
                });

                
    

            </script>            
        </body>
    </html>
