<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD || Dashboard</title>
      <?php
        include_once 'css_links.php';
      ?>
      <style>
        #customerData {
          height: 100% !important;
          width: 100% !important;
        }

        .col-md-3.bg-white .col-md-12 {
          height: 100%;
          min-height: 300px;
          position: relative;
        }
        /* Align all controls in the row vertically */
#locationFilter,
#toggleSales,
#togglePayments,
#reportrange {
    display: inline-block;
    vertical-align: middle; /* Align middle with buttons */
    margin-bottom: 0;       /* Remove any default margin */
}

#locationFilter {
    height: 34px;           /* Match button height */
    padding: 5px 10px;      /* Match Bootstrap input padding */
    line-height: 1.42857143; /* Bootstrap default for input-sm */
}

      </style>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          <?php
            include 'menu_finance.php';

            include_once 'model/finance_model.php';
            include_once 'model/customers_model.php';
            include_once 'model/stock_model.php';

            $finance_model = new finance_model();
            $stock_model = new stock_model();
            $customers_model  = new customers_model();


            $todayStart = date('Y-m-d 00:00:00');
            $todayEnd   = date('Y-m-d 00:00:00', strtotime('+1 day'));
            $yesterdayStart = date('Y-m-d 00:00:00', strtotime('-1 day'));
            $yesterdayEnd   = date('Y-m-d 00:00:00');
            $start_this_month = date('Y-m-01 00:00:00');
            $end_this_month   = date('Y-m-d 23:59:59');
            $start_last_month = date('Y-m-01 00:00:00', strtotime('first day of last month'));
            $end_last_month   = date('Y-m-t 23:59:59', strtotime('last month'));
            $end_of_today = date('Y-m-d');
            $day_of_week = date('w');  
            $start_of_this_week = date('Y-m-d', strtotime("-$day_of_week days"));
            $start_last_week = date('Y-m-d 00:00:00', strtotime('monday last week'));
            $end_last_week   = date('Y-m-d 23:59:59', strtotime('sunday last week'));

            $sales_today = $finance_model->getsalesTotals($todayStart, $todayEnd);
            $sales_yesterday = $finance_model->getsalesTotals($yesterdayStart, $yesterdayEnd);
            $sales_lastweek = $finance_model->getsalesTotals($start_last_week, $end_last_week);
            $sales_thisweek = $finance_model->getsalesTotals($start_of_this_week, $end_of_today);
            $sales_lastmonth = $finance_model->getsalesTotals($start_last_month,$end_last_month);
            $sales_thismonth = $finance_model->getsalesTotals($start_this_month, $end_this_month);

            $daily_growth = ($sales_yesterday > 0) ? min((($sales_today - $sales_yesterday) / $sales_yesterday) * 100, 100) : ($sales_today > 0 ? 100 : 0);
            $weekly_growth = ($sales_lastweek > 0) ? min((($sales_thisweek - $sales_lastweek) / $sales_lastweek) * 100, 100) : ($sales_thisweek > 0 ? 100 : 0);
            $monthly_growth = ($sales_lastmonth > 0) ? min((($sales_thismonth - $sales_lastmonth) / $sales_lastmonth) * 100, 100) : ($sales_thismonth > 0 ? 100 : 0);


            // Round for display
            $daily_growth = round($daily_growth);
            $weekly_growth = round($weekly_growth);
            $monthly_growth = round($monthly_growth);

            $num_open_invoices = $finance_model->countOpenInvoices();
            $num_customers_this_month = $customers_model->getCustomersRegisteredThisMonth();

            $num_this_month = $customers_model->getCustomersRegisteredThisMonth();
            $num_last_month = $customers_model->getCustomersRegisteredLastMonth();

            if ($num_last_month > 0) {
              $change = (($num_this_month - $num_last_month) / $num_last_month) * 100;
            } else {
              // If last month had 0 customers, we assume full growth or set to 100% or any default
              $change = $num_this_month > 0 ? 100 : 0;
            }

            $change = round($change);

            $top_selling_product = $finance_model->getTopSellingProducts();

            if ($top_selling_product) {
              $top_product_name = $top_selling_product['product_name'];
              $top_product_code = $top_selling_product['product_code'];
            } else {
              // Default values if no product found
              $top_product_name = "No sales";
              $top_product_code = "";
            }

            $growth = 0;

            $total_sold_last_month = $finance_model->getTotalSoldLastMonth($top_product_code);
            $total_sold_this_month = $finance_model->getTotalSoldThisMonth($top_product_code);


            if ($total_sold_last_month > 0) {
              $growth = (($total_sold_this_month - $total_sold_last_month) / $total_sold_last_month) * 100;
            } else {
              $growth = $total_sold_this_month  > 0 ? 100 : 0; // 100% growth from 0 or 0 if no sales
            }
            $top_product_growth = round($growth);

            
            

            

            


            

            $day_of_week = date('w'); 
          ?>
          <div class="right_col" role="main">
            <!-- top tiles -->
            <div class="row" style="display: inline-block;width:100%" >
              <div class="tile_count">

                <div class="col-md-2 col-sm-2 tile_stats_count">
                  <span class="count_top"><i class="fa fa-money-bill"></i> Sales Today</span>
                    <div class="count">
                      <a href="sales.php?range=daily" style="text-decoration: none; color: inherit;">
                        <?php echo number_format($sales_today, 2) ?>
                      </a>
                    </div>
                    <span class="count_bottom">
                      <i class="<?php echo ($daily_growth >= 1) ? 'green' : 'red'; ?>">
                        <i class="fa <?php echo ($daily_growth >= 1) ? 'fa-sort-asc' : 'fa-sort-desc'; ?>"></i>
                        <?php echo abs($daily_growth); ?>% From Yesterday
                      </i>
                    </span>
                </div>

                <div class="col-md-2 col-sm-4 tile_stats_count">
                  <span class="count_top"><i class="fa fa-money-bill"></i> Weekly Sales</span>
                  <div class="count">
                    <a href="sales.php?range=weekly" style="text-decoration: none; color: inherit;">
                      <?php echo number_format($sales_thisweek, 2) ?>
                    </a>
                  </div>
                  <span class="count_bottom">
                    <i class="<?php echo ($weekly_growth >= 1) ? 'green' : 'red'; ?>">
                      <i class="fa <?php echo ($weekly_growth >= 1) ? 'fa-sort-asc' : 'fa-sort-desc'; ?>"></i>
                      <?php echo abs($weekly_growth); ?>% From Last Week
                    </i>
                    </span>
                </div>

                <div class="col-md-2 col-sm-4 tile_stats_count">
                  <span class="count_top"><i class="fa fa-money-bill"></i> Monthly Sales</span>
                  <div class="count">
                    <a href="sales.php?range=monthly" style="text-decoration: none; color: inherit;">
                      <?php echo number_format($sales_thismonth, 2) ?>
                    </a>
                  </div>
                  <span class="count_bottom">
                    <i class="<?php echo ($monthly_growth >= 1) ? 'green' : 'red'; ?>">
                      <i class="fa <?php echo ($monthly_growth >= 1) ? 'fa-sort-asc' : 'fa-sort-desc'; ?>"></i>
                        <?php echo abs($monthly_growth); ?>% From Last Month
                      </i>
                  </span>
                </div>

                <div class="col-md-2 col-sm-4 tile_stats_count">
                  <span class="count_top"><i class="fa fa-star"></i> Top-Selling Product This Month</span>
                  
                  <div class="count" style="font-size: 28px;">
                    <?php if (!empty($top_product_code) && !empty($top_product_name)): ?>
                      <a href="top_selling_product.php?product_code=<?php echo urlencode($top_product_code); ?>" style="text-decoration: none; color: inherit;">
                        <?php echo htmlspecialchars($top_product_name); ?>
                      </a>
                    <?php else: ?>
                      <i><?php echo htmlspecialchars($top_product_name); ?></i>
                    <?php endif; ?>
                  </div>

                  <?php
                    $growth = floatval($top_product_growth); // Ensure it's treated as a number
                    $growthClass = $growth >= 1 ? 'green' : 'red';
                    $growthIcon = $growth >=1 ? 'fa-sort-asc' : 'fa-sort-desc';
                  ?>

                  <span class="count_bottom">
                    <i class="<?php echo $growthClass; ?>">
                      <i class="fa <?php echo $growthIcon; ?>"></i>
                      <?php echo htmlspecialchars(abs($growth)); ?>%
                    </i> From last Month
                  </span>

                </div>


                <div class="col-md-2 col-sm-4 tile_stats_count">
                  <span class="count_top"><i class="fa fa-money-bill"></i> Outstanding Invoices</span>
                  <div class="count text-danger">
                    <a href="open_invoices.php" class="text-danger" style="text-decoration: none;">
                      <?php echo $num_open_invoices ?>
                    </a>
                  </div>
                  <span class="count_bottom">
                    <u><a href="open_invoices.php">Open/Active Invoices</a></u>
                  </span>
                </div>

                <div class="col-md-2 col-sm-4 tile_stats_count">
                  <span class="count_top"><i class="fa fa-user"></i> New Customers This Month</span>
                  <div class="count">
                    <a href="manage_customers.php" style="text-decoration: none; color: inherit;">
                      <?php echo $num_this_month ?>
                    </a>
                  </div>

                  <span class="count_bottom">
                    <i class="<?php echo ($change >= 0) ? 'green' : 'red'; ?>">
                      <i class="fa fa-sort-<?php echo ($change >= 0) ? 'asc' : 'desc'; ?>"></i>
                      <?php echo abs($change); ?>%
                      </i> From Last Month
                  </span>
                </div>
              </div>
            </div>
            <!-- /top tiles -->

            
            <div class="row">
              <div class="col-md-12 col-sm-12">
                <div class="dashboard_graph">
                  <div class="row x_title">

    <!-- LEFT: TITLE -->
    <div class="col-md-4 col-sm-12">
        <h3>Sales & Payments Overview</h3>
    </div>

    <!-- RIGHT CONTROLS -->
    <div class="col-md-8 col-sm-12 text-right">

        <!-- GROUP EVERYTHING -->
        <div class="btn-group" style="margin-right:10px; display:inline-block; vertical-align:middle;">

            <!-- LOCATION FILTER -->
            <select id="locationFilter" class="form-control input-sm"
                    style="height:34px; min-width:180px;">
                <option value="">All Locations</option>
            </select>

        </div>

        <!-- SALES TOGGLE -->
        <button
            id="toggleSales"
            class="btn btn-sm <?= $salesDisplay == 1 ? 'btn-danger' : 'btn-outline-success' ?>"
            data-current="<?= $salesDisplay ?>"
            style="height:34px; margin-right:5px; vertical-align:middle;"
        >
            <i class="fa <?= $salesDisplay == 1 ? 'fa-eye-slash' : 'fa-eye' ?>"></i>
            <?= $salesDisplay == 1 ? 'Hide Sales' : 'Show Sales' ?>
        </button>

        <!-- PAYMENTS TOGGLE -->
        <button
            id="togglePayments"
            class="btn btn-sm <?= $paymentsDisplay == 1 ? 'btn-danger' : 'btn-outline-success' ?>"
            data-current="<?= $paymentsDisplay ?>"
            style="height:34px; margin-right:10px; vertical-align:middle;"
        >
            <i class="fa <?= $paymentsDisplay == 1 ? 'fa-eye-slash' : 'fa-eye' ?>"></i>
            <?= $paymentsDisplay == 1 ? 'Hide Payments' : 'Show Payments' ?>
        </button>

        <!-- DATE PICKER -->
        <div id="reportrange" class="pull-right"
             style="background:#fff; cursor:pointer; padding:5px 10px; border:1px solid #ccc; height:34px; line-height:24px; display:inline-block; vertical-align:middle;">
            <i class="fa fa-calendar"></i>
            <span></span> <b class="caret"></b>
        </div>

    </div>
</div>



                  <div class="col-md-12" style="display: <?= $salesDisplaySetting ?>;">
                      <div class="x_title">
                          <h2>Sales Transactions</h2>
                          <div class="clearfix"></div>
                      </div>
                      <div class="x_content" style="overflow-x:auto; max-height: auto">
                          <table class="table table-striped table-bordered" id="salesTransactionsTable">
                              <thead>
                                  <tr>
                                      <th>Date</th>
                                      <th>Transaction ID</th>
                                      <th>Customer</th>
                                      <th>Sales Location</th>
                                      <th>Transaction Type</th>
                                      <th>Sales Amount</th>
                                      <th>Total Paid</th>
                                      <th>Balance</th>
                                      <th>Action</th>
                                  </tr>
                              </thead>
                              <tbody>
                                  <!-- Rows will be populated dynamically -->
                              </tbody>
                          </table>
                      </div>
                  </div>
                  
                  
                  <div class="col-md-12" style="display: <?= $paymentsDisplaySetting ?>;">
                      <div class="x_title">
                          <h2>Payments</h2>
                          <div class="clearfix"></div>
                      </div>
                      <div class="x_content" style="overflow-x:auto; max-height: auto">
                          <table class="table table-striped table-bordered" id="paymentTransactionsTable" >
                              <thead>
                                  <tr>
                                      <th>Date</th>
                                      <th>Payment Method</th>
                                      <th>Transaction ID</th>
                                      <th>Customer</th>
                                      <th>Location</th>
                                      <th>Transaction Type</th>
                                      <th>Amount Paid</th>
                                      <th>Action</th>
                                  </tr>
                              </thead>
                              <tbody>
                                  <!-- Rows will be populated dynamically -->
                              </tbody>
                          </table>
                      </div>
                  </div>


                  

                  <div class="col-md-9 col-sm-9 ">
                    <canvas id="chart_plot_01" height="90"></canvas>
                  </div>

                  <div class="col-md-3 col-sm-3 bg-white" style="height: 100%;">
                    <div class="x_title">
                      <h2>Top Customers</h2>
                      <div class="clearfix"></div>
                    </div>
                    <div class="col-md-12 col-sm-12" style="height: 100%; min-height: 320px; position: relative;">
                      <canvas id="customerData" style="height: 100% !important; width: 100% !important;"></canvas>
                    </div>
                  </div>



                  <div class="clearfix"></div>

                </div>
              </div>
            </div>

            <div class="row">
              <div class="col-md-12 col-sm-12">
                <div class="dashboard_graph">
                  <div class="row x_title">
                    <div class="col-md-6">
                      <h3>Leave Overview</h3>
                    </div>
                    <canvas id="employeeLeaveChart" width="400" height="90"></canvas>
                  </div>
                </div>
              </div>
            </div>  
            <br />
            
            <div class="row">
              <div class="col-md-12 col-sm-12">
                <div class="dashboard_graph">
                  <div class="row x_title">
                    <div class="col-md-6">
                      <h3>Leave Overview</h3>
                    </div>
                    <canvas id="salaryProjectionChart" width="400" height="90"></canvas>
                  </div>
                </div>
              </div>
            </div>  
            <br />

          </div>

        </div>
        <?php
          include_once 'footer.php';
        ?>
      </div>
      

      <?php
        include_once 'libraries.php';
      ?>
      <script>
        document.addEventListener('DOMContentLoaded', function () {
          const ctx = document.getElementById('chart_plot_01').getContext('2d');
          const customersCtx = document.getElementById('customerData').getContext('2d');
          const employeeLeaveCtx = document.getElementById('employeeLeaveChart').getContext('2d');
          const salaryProjectionCtx = document.getElementById('salaryProjectionChart').getContext('2d');

          const salaryProjectionChart = new Chart(salaryProjectionCtx, {
            type: 'line',
            data: {
              labels: [], // e.g., ['January', 'February', ...]
              datasets: [{
                label: 'Projected Salaries (MWK)',
                data: [],
                backgroundColor: 'rgba(153, 102, 255, 0.2)',
                borderColor: 'rgba(153, 102, 255, 1)',
                borderWidth: 2,
                tension: 0.4,
                fill: true
              }]
            },
            options: {
              responsive: true,
              scales: {
                y: {
                  beginAtZero: true,
                  title: {
                    display: true,
                    text: 'Amount (MWK)'
                  }
                },
                x: {
                  title: {
                    display: true,
                    text: 'Department'
                  }
                }
              },
              plugins: {
                title: {
                  display: true,
                  text: 'Salary Monthly Projections'
                }
              }
            }
          });


          const employeeLeaveChart = new Chart(employeeLeaveCtx, {
            type: 'bar',
            data: {
              labels: [], // Employee names
              datasets: [
                {
                  label: 'Total Leave Days',
                  data: [],
                  backgroundColor: 'rgba(54, 162, 235, 0.6)',
                  borderColor: 'rgba(54, 162, 235, 1)',
                  borderWidth: 1
                },
                {
                  label: 'Approved Leave Days',
                  data: [],
                  backgroundColor: 'rgba(255, 99, 132, 0.6)',
                  borderColor: 'rgba(255, 99, 132, 1)',
                  borderWidth: 1
                },
                {
                  label: 'Remaining Leave Days',
                  data: [],
                  backgroundColor: 'rgba(75, 192, 192, 0.6)',
                  borderColor: 'rgba(75, 192, 192, 1)',
                  borderWidth: 1
                }
              ]
            },
            options: {
              responsive: true,
              scales: {
                y: {
                  beginAtZero: true
                }
              },
              plugins: {
                title: {
                  display: true,
                  text: 'Employee Leave Overview'
                }
              }
            }
          });

          const myChart = new Chart(ctx, {
            type: 'bar',
            data: {
              labels: [],
              datasets: [{
                label: 'Total Sales',
                data: [],
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
              }]
            },
            options: {
              responsive: true,
              scales: {
                y: { beginAtZero: true }
              }
            }
          });

          const myCustomerChart = new Chart(customersCtx, {
            type: 'bar',
            data: {
              labels: [],
              datasets: [{
                label: 'Top Customers',
                data: [],
                backgroundColor: [
                  '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF', '#FF9F40'
                ],
                borderColor: [
                  '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF', '#FF9F40'
                ],
                borderWidth: 1
              }]
            },
            options: {
              responsive: true,
              maintainAspectRatio: false, // ❗️Allows it to fill the container height
              indexAxis: 'y', // 🔁 Horizontal bars
              scales: {
                x: {
                  beginAtZero: true,
                  title: {
                    display: true,
                    text: 'Sales Amount'
                  }
                },
                y: {
                  title: {
                    display: true,
                    text: 'Customer Name'
                  }
                }
              },
              plugins: {
                legend: { display: false },
                title: {
                  display: true,
                  text: 'Top Customers'
                }
              }
            }
          });

          function fetchEmployeeLeaveData(start, end) {
          $.ajax({
            url: 'fetch_graph_data.php',
            method: 'GET',
            dataType: 'json',
            data: {
              start: start.format('YYYY-MM-DD'),
              end: end.format('YYYY-MM-DD'),
              graph: 'employee_leaves'
            },
            success: function (res) {
              if (res.error) {
                console.error(res.error);
                return;
              }

              employeeLeaveChart.data.labels = res.labels;
              employeeLeaveChart.data.datasets[0].data = res.total_days;
              employeeLeaveChart.data.datasets[1].data = res.approved_days;
              employeeLeaveChart.data.datasets[2].data = res.remaining_days;
              employeeLeaveChart.update();
            },
            error: function (xhr, status, error) {
              console.error('Employee Leave Data AJAX Error:', status, error);
            }
          });
        }


          // Fetch sales graph
          function fetchSalesData(start, end) {
            $.ajax({
                url: 'fetch_graph_data.php',
                method: 'GET',
                dataType: 'json',
                data: {
                    start: start.format('YYYY-MM-DD'),
                    end: end.format('YYYY-MM-DD'),
                    graph: 'sales_activity',
                    include_transactions: 1,
                    include_payments: 1,
                    fetch_locations:1
                },
                success: function (res) {
                    if (res.error) {
                        console.error(res.error);
                        return;
                    }

                    // Update chart
                    myChart.data.labels = res.labels;
                    myChart.data.datasets[0].data = res.data;
                    myChart.update();

                    // Populate transactions table
                    if (res.transactions) {
                      const tbody = $('#salesTransactionsTable tbody');
                      tbody.empty();

                      let totalSales= 0;
                      let totalPayments= 0;
                      let oveallBalances = 0;

                      res.transactions.forEach(sale => {
                          let link = '';
                          if (sale.transaction_type === 'Cash Sale') {
                              link = `cash_sale_receipt.php?id=${encodeURIComponent(sale.transaction_number)}`;
                          } else if (sale.transaction_type === 'Customer Invoice') {
                              link = `invoice.php?invoice_number=${encodeURIComponent(sale.transaction_number)}`;
                          }

                          totalSales += parseFloat(sale.sales_amount);
                          totalPayments += parseFloat(sale.total_paid);
                          oveallBalances += parseFloat(sale.balance);



                          tbody.append(`
                              <tr>
                                  <td>${sale.sale_date}</td>
                                  <td>${sale.transaction_number}</td>
                                  <td>${sale.customer}</td>
                                  <td>${sale.location_from}</td>
                                  <td>${sale.transaction_type}</td>
                                  <td style="text-align:right">${Number(sale.sales_amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
                                  <td style="text-align:right">${Number(sale.total_paid).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
                                  <td style="text-align:right">${Number(sale.balance).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
                                  <td>
                                      <a class="btn btn-info btn-sm text-white" href="${link}">View Details</a>
                                  </td>
                              </tr>
                          `);
                      });

                      // Append totals row
                      recalculateTotals();
                  }

                            if (res.payments) {
                      const tbody = $('#paymentTransactionsTable tbody');
                      tbody.empty();

                      let totalAmount = 0;

                      res.payments.forEach(sale => {
                          let link = '';
                          if (sale.transaction_type === 'Cash Sale') {
                              link = `cash_sale_receipt.php?id=${encodeURIComponent(sale.transaction_number)}`;
                          } else if (sale.transaction_type === 'Customer Invoice Payment') {
                              link = `invoice_payment_receipt.php?receipt_number=${encodeURIComponent(sale.receipt_number)}`;
                          }

                          totalAmount += parseFloat(sale.sales_amount);

                          tbody.append(`
                              <tr>
                                  <td>${sale.sale_date}</td>
                                  <td>${sale.payment_method}</td>
                                  <td>${sale.transction_id}</td>
                                  <td>${sale.customer}</td>
                                  <td>${sale.location_from}</td>
                                  <td>${sale.transaction_type}</td>
                                  <td style="text-align:right">${Number(sale.sales_amount).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
                                  <td>
                                      <a class="btn btn-info btn-sm text-white" href="${link}">View Details</a>
                                  </td>
                              </tr>
                          `);
                      });

                      // Append totals row
                      recalculateTotals();
                  }

                  // Populate locations dropdown
if (res.locations) {
    const select = $('#locationFilter'); // make sure you have <select id="locationFilter"></select> in HTML
    select.empty();
    select.append('<option value="">All Locations</option>'); // default option

    res.locations.forEach(loc => {
        select.append(`<option value="${loc.location_name}">${loc.location_name}</option>`);
    });

    console.log('Locations populated in dropdown:', res.locations); // debug
}





                                  },
                                  error: function (xhr, status, error) {
                                      console.error('Sales Data AJAX Error:', status, error);
                                  }
                              });
                              }


                            //Fetch Salary Data for Employees
                            function fetchSalaryProjections(start, end) {
                              $.ajax({
                                url: 'fetch_graph_data.php',
                                method: 'GET',
                                dataType: 'json',
                                data: {
                                  start: start.format('YYYY-MM-DD'),
                                  end: end.format('YYYY-MM-DD'),
                                  graph: 'salary_projection'
                                },
                                success: function (res) {
                                  if (res.error) {
                                    console.error(res.error);
                                    return;
                                  }

                                  salaryProjectionChart.data.labels = res.labels;     // e.g., ['Jan', 'Feb', ...]
                                  salaryProjectionChart.data.datasets[0].data = res.data; // e.g., [1000000, 1100000, ...]
                                  salaryProjectionChart.update();
                                },
                                error: function (xhr, status, error) {
                                  console.error('Salary Projection AJAX Error:', status, error);
                                }
                              });
                            }


                            // Fetch top customers graph
                            function fetchCustomerData(start, end) {
                              $.ajax({
                                url: 'fetch_graph_data.php',
                                method: 'GET',
                                dataType: 'json',
                                data: {
                                  start: start.format('YYYY-MM-DD'),
                                  end: end.format('YYYY-MM-DD'),
                                  graph: 'top_customers'
                                },
                                success: function (res) {
                                  if (res.error) {
                                    console.error(res.error);
                                    return;
                                  }

                                  myCustomerChart.data.labels = res.labels;
                                  myCustomerChart.data.datasets[0].data = res.data;
                                  myCustomerChart.update();
                                },
                                error: function (xhr, status, error) {
                                  console.error('Customer Data AJAX Error:', status, error);
                                }
                              });
                            }

                            // Default: Current month
                            let start = moment().startOf('week');
          let end = moment().endOf('week');

        
          function updateDateRange(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
            fetchSalesData(start, end);
            fetchCustomerData(start, end);
            fetchEmployeeLeaveData(start, end);
            fetchSalaryProjections(start, end); // ➕ added here
          }


          $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
              'Today': [moment(), moment()],
              'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
              'This Week': [moment().startOf('week'), moment().endOf('week')],
              'Last Week': [moment().subtract(1, 'week').startOf('week'), moment().subtract(1, 'week').endOf('week')],
              'Last 7 Days': [moment().subtract(6, 'days'), moment()],
              'Last 30 Days': [moment().subtract(29, 'days'), moment()],
              'This Month': [moment().startOf('month'), moment().endOf('month')],
              'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
              'Year to Date': [moment().startOf('year'), moment()]
            }
          }, updateDateRange);

          updateDateRange(start, end); // initial chart load
        });

$('#togglePayments').on('click', function () {
    const current = parseInt($(this).data('current'));
    const next = current === 1 ? 0 : 1;

    $.post('controllers/settings_controller.php', {
        action: 'update_display_setting',
        column: 'payments_display',
        value: next
    }, function () {
        location.reload();
    });
});



$('#toggleSales').on('click', function () {
    const current = parseInt($(this).data('current'));
    const next = current === 1 ? 0 : 1;

    $.post('controllers/settings_controller.php', {
        action: 'update_display_setting',
        column: 'sales_display',
        value: next
    }, function () {
        location.reload(); // reload to respect DB state
    });
});




function updateDateRange(start, end) {
    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    
    fetchSalesData(start, end);
    fetchCustomerData(start, end);
    fetchEmployeeLeaveData(start, end);
    fetchSalaryProjections(start, end);

}


      </script>

      <script>
$('#locationFilter').on('change', function() {
    const selectedLocation = $(this).val();

    // Filter Sales Transactions
    $('#salesTransactionsTable tbody tr').each(function() {
        const rowLocation = $(this).find('td:eq(3)').text().trim();
        if (selectedLocation === "" || rowLocation === selectedLocation) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });

    // Filter Payments Transactions
    $('#paymentTransactionsTable tbody tr').each(function() {
        const rowLocation = $(this).find('td:eq(4)').text().trim();
        if (selectedLocation === "" || rowLocation === selectedLocation) {
            $(this).show();
        } else {
            $(this).hide();
        }
    });

    // Recalculate totals after filtering
    recalculateTotals();
});


function recalculateTotals() {
    // Sales Transactions Table
    let totalSales = 0;
    let totalPayments = 0;
    let overallBalance = 0;

    $('#salesTransactionsTable tbody tr:visible').each(function() {
        totalSales += parseFloat($(this).find('td:eq(5)').text().replace(/,/g, '')) || 0; // Sales Amount
        totalPayments += parseFloat($(this).find('td:eq(6)').text().replace(/,/g, '')) || 0; // Total Paid
        overallBalance += parseFloat($(this).find('td:eq(7)').text().replace(/,/g, '')) || 0; // Balance
    });

    // Remove existing totals row
    $('#salesTransactionsTable tbody tr.total-row').remove();

    // Append updated totals row
    $('#salesTransactionsTable tbody').append(`
        <tr class="total-row" style="font-weight:bold; background-color:#f1f1f1;">
            <td colspan="5" style="text-align:left">Total</td>
            <td style="text-align:right">${totalSales.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
            <td style="text-align:right">${totalPayments.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
            <td style="text-align:right">${overallBalance.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
            <td></td>
        </tr>
    `);

    // Payments Transactions Table
    let totalAmount = 0;
    $('#paymentTransactionsTable tbody tr:visible').each(function() {
        totalAmount += parseFloat($(this).find('td:eq(6)').text().replace(/,/g, '')) || 0; // Amount Paid
    });

    $('#paymentTransactionsTable tbody tr.total-row').remove();

    $('#paymentTransactionsTable tbody').append(`
        <tr class="total-row" style="font-weight:bold; background-color:#f1f1f1;">
            <td colspan="6" style="text-align:left">Total</td>
            <td style="text-align:right">${totalAmount.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</td>
            <td></td>
        </tr>
    `);
}

</script>


    </body>
  </html>
