<?php
	session_start();
    include_once 'model/branch_model.php';
    include_once 'model/employees_model.php';
    include_once 'model/common_model.php';
	
?>
<html>
	<head>
		<title>Branches</title>
		<style>
			#result {
				height:20px;
				font-size:16px;
				font-family:Arial, Helvetica, sans-serif;
				color:#333;
				padding:5px;
				margin-bottom:10px;
				background-color:#FFFF99;
			}
			#country{
				border: 1px solid #999;
				background: #EEEEEE;
				padding: 5px 10px;
				box-shadow:0 1px 2px #ddd;
				-moz-box-shadow:0 1px 2px #ddd;
				-webkit-box-shadow:0 1px 2px #ddd;
			}
			.suggestionsBox {
				position: absolute;
				left: 10px;
				margin: 0;
				width: 268px;
				top: 40px;
				padding:0px;
				background-color: #000;
				color: #fff;
			}
			.suggestionList {
				margin: 0px;
				padding: 0px;
			}
			.suggestionList ul li {
				list-style:none;
				margin: 0px;
				padding: 6px;
				border-bottom:1px dotted #666;
				cursor: pointer;
			}
			.suggestionList ul li:hover {
				background-color: #FC3;
				color:#000;
			}

			.load{
			background-image:url(loader.gif);
			background-position:right;
			background-repeat:no-repeat;
			}

			#suggest {
				position:relative;
			}
			.combopopup{
				padding:3px;
				width:268px;
				border:1px #CCC solid;
			}
			.select_fields{	
				width:80%;
				height:35px;
				text-transform: capitalize;
				border:2px solid #796CED;
				border-radius: 8px;
				padding-left: 8px;
				font-size: 15px;
			}
			.text_fields {	
				width:100%;
				height:80%;
				text-transform: capitalize;
				padding: 8px;
				text-align: center;
				font-size: 15px;
				border: 2px solid #677BF0;
				border-radius: 8px;
			}
			.page_titles{
				font-family: Times New Roman;
				font-size: 20px;
				color: #069;
				text-transform:uppercase;
			}
		</style>
	</head>
	<body>
		<?php
			$branch_id = $_GET['id'];
            $branch_model = new branch_model();
            $employees_model = new employees_model();
            $common_model = new common_model();

            $branchDetails = $branch_model->getBranchDetails($branch_id);
			$managers = $employees_model->getShopManagers();
			$locations = $common_model->getAllLocations();
		?>
		
		<form action="controllers/branch_controller.php" method="POST">
			
				<center>
					<h2 class="page_titles">EDIT BRANCH DETAILS <i class="fa fa-mug-hot"></i></h2>
					<hr>
					
					<input type="text" style="width: 280px; height:40px;" autocomplete="off" id="branchname" name="branch_name" value="<?php echo $branchDetails['branch_name']?>" class="form-control" required placeholder="Enter New Branch Name">
					<span id="Error" style="color: red;"></span><br>
					
					<select name="manager" class="form-control" style="width: 280px; height:40px;" required>
						<option value="<?php echo $branchDetails['shop_manager']?>"><?php echo $branchDetails['supervisor_name']?></option>
						<?php
							foreach($managers as $manager):
								if($branchDetails['shop_manager'] != $manager['employee_code']):
						?>
									<option value="<?php echo $manager['employee_code']?>"><?php echo $manager['fullname']?></option>
						<?php
								endif;
							endforeach;
						?>
					</select>
					<br>

					<select name="location" class="form-control" style="width: 280px; height:40px;" required>
						<option value="<?php echo $branchDetails['location']?>"><?php echo $branchDetails['location_name']?></option>
						<?php
							foreach($locations as $location):
								if($branchDetails['location'] != $location['loc_id']):
						?>
									<option value="<?php echo $location['loc_id']?>"><?php echo $location['location_name']?></option>
						<?php
								endif;
							endforeach;
						?>
					</select>
					<br>

                    <input type="hidden" name="edit_branch" value="edit_branch" readonly>
                    <input type="hidden" name="branch_id" value="<?php echo $branch_id ?>" readonly>

					<button class="btn btn-success btn-block btn-large" id="SaveButton" style="width:282px;font-size: 18px;">SAVE DETAILS <i class="fa fa-save"></i></button>
				</center>
			
		</form>	
	</body>
</html>